/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.netbeans.modules.java.tools.ElementFilter;
import org.netbeans.modules.java.tools.InheritanceSupport;
import org.netbeans.modules.java.ui.wizard.MethodsChildren;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.MethodElement;
import org.openide.src.nodes.MethodElementNode;
import org.openide.util.Task;
import org.openide.util.TaskListener;

class InheritanceChildren
extends Children.Keys
implements InheritanceSupport.HierarchyListener {
    private static final Object WAIT = new Object();
    private static final String WAIT_STRING = "wait";
    private InheritanceSupport support;
    private Comparator comparator;
    private Comparator methodComp;
    private ElementFilter.Method filter;
    private boolean methodsOnly = false;
    private InheritanceSupport.HierarchyListener listener;

    public InheritanceChildren(InheritanceSupport data, Comparator classComp, Comparator methodComp, ElementFilter.Method filter) {
        this.support = data;
        this.comparator = classComp;
        this.methodComp = methodComp;
        this.filter = filter;
        this.setWaitNode();
        this.listener = this;
    }

    public void addNotify() {
        this.support.addHierarchyListener(this.listener);
        this.support.prepareHierarchy().addTaskListener(new TaskListener(){

            public void taskFinished(Task t) {
                t.removeTaskListener((TaskListener)this);
                InheritanceChildren.this.refreshData();
                InheritanceChildren.this.support.addHierarchyListener(InheritanceChildren.this.listener);
            }
        });
        this.refreshData();
    }

    public void removeNotify() {
        this.support.removeHierarchyListener(this.listener);
        this.setKeys(Collections.EMPTY_SET);
    }

    public void setMethodsOnly(boolean mo) {
        if (this.methodsOnly != mo) {
            this.methodsOnly = mo;
            this.refreshData();
        }
    }

    public boolean isMethodsOnly() {
        return this.methodsOnly;
    }

    public void setFilter(ElementFilter.Method f) {
        if (this.filter != f) {
            this.filter = f;
            if (this.methodsOnly) {
                this.refreshData();
            } else {
                Node[] classNodes = this.getNodes();
                int i = 0;
                while (i < classNodes.length) {
                    ((Methods)classNodes[i].getChildren()).refreshKeys();
                    ++i;
                }
            }
        }
    }

    public ElementFilter.Method getFilter() {
        return this.filter;
    }

    private void refreshData() {
        Collection result;
        Comparator comp;
        Collection original;
        if (this.methodsOnly) {
            original = this.support.createMethodMap(this.support.getInheritedClasses(), false, this.filter).values();
            comp = this.methodComp;
        } else {
            original = this.support.getInheritedClasses();
            comp = this.comparator;
        }
        if (comp == null) {
            result = original;
        } else {
            result = new TreeSet(comp);
            result.addAll(original);
        }
        this.setKeys(result);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof ClassElement) {
            return new Node[]{this.support.createClassElementNode((ClassElement)key, (Children)new Methods((ClassElement)key), false)};
        }
        if (key instanceof MethodElement) {
            MethodElementNode me = new MethodElementNode((MethodElement)key, false);
            me.setElementFormat(MethodsChildren.METHOD_FORMAT);
            return new Node[]{me};
        }
        if (key == WAIT) {
            return new Node[]{new AbstractNode(Children.LEAF){

                public String getDisplayName() {
                    return InheritanceChildren.WAIT_STRING;
                }
            }};
        }
        throw new IllegalArgumentException(key.getClass().toString());
    }

    private final void setWaitNode() {
        this.setKeys(new Object[]{WAIT});
    }

    public void inheritanceChanged() {
        this.setWaitNode();
    }

    public void inheritedClassesComputed(Map classes) {
        this.refreshData();
    }

    public void inheritedMethodsComputed(Collection methods) {
    }

    static class OverridenMethods
    extends Children.Keys
    implements PropertyChangeListener {
        ClassElement classElement;
        InheritanceSupport support;
        Comparator comparator;

        public OverridenMethods(ClassElement clazz, InheritanceSupport support, Comparator comp) {
            this.classElement = clazz;
            this.support = support;
            this.comparator = comp;
        }

        protected void addNotify() {
            this.classElement.addPropertyChangeListener((PropertyChangeListener)this);
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.classElement.removePropertyChangeListener((PropertyChangeListener)this);
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof MethodElement) {
                MethodElementNode me = new MethodElementNode((MethodElement)key, false);
                me.setElementFormat(MethodsChildren.METHOD_FORMAT);
                return new Node[]{me};
            }
            throw new IllegalArgumentException(key.getClass().toString());
        }

        void refreshKeys() {
            ArrayList keys = new ArrayList(this.support.getOverridingMethods());
            Collections.sort(keys, this.comparator);
            this.setKeys(keys);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("methods".equals(evt.getPropertyName())) {
                this.refreshKeys();
            }
        }
    }

    class Methods
    extends Children.Keys {
        protected ClassElement classElement;

        public Methods(ClassElement clazz) {
            this.classElement = clazz;
        }

        protected void addNotify() {
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof MethodElement) {
                MethodElementNode me = new MethodElementNode((MethodElement)key, false);
                me.setElementFormat(MethodsChildren.METHOD_FORMAT);
                return new Node[]{me};
            }
            throw new IllegalArgumentException(key.getClass().toString());
        }

        void refreshKeys() {
            ArrayList<ClassElement> keys = new ArrayList<ClassElement>();
            keys.add(this.classElement);
            TreeSet subKeys = new TreeSet(InheritanceChildren.this.methodComp);
            subKeys.addAll(InheritanceChildren.this.support.createMethodMap(keys, false, InheritanceChildren.this.filter).values());
            this.setKeys(subKeys);
        }
    }
}

