/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Modifier;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.netbeans.modules.java.ui.wizard.ModifierEditor;
import org.openide.util.NbBundle;

public class MethodTypePanel
extends JPanel
implements ModifierEditor.ModifierPanel {
    private JCheckBox synchronizedCheckBox;
    private JRadioButton regularRadioButton;
    private JCheckBox finalCheckBox;
    private JRadioButton abstractRadioButton;
    private JCheckBox staticCheckBox;
    private JCheckBox nativeCheckBox;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$MethodTypePanel;

    public MethodTypePanel() {
        this.initComponents();
        this.setBorder(new TitledBorder(new EtchedBorder(), NbBundle.getBundle((Class)(class$org$netbeans$modules$java$ui$wizard$MethodTypePanel == null ? (class$org$netbeans$modules$java$ui$wizard$MethodTypePanel = MethodTypePanel.class$("org.netbeans.modules.java.ui.wizard.MethodTypePanel")) : class$org$netbeans$modules$java$ui$wizard$MethodTypePanel)).getString("LBL_MethodType")));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.regularRadioButton);
        bg.add(this.abstractRadioButton);
        this.regularRadioButton.setSelected(true);
        this.regularRadioButton.setMnemonic(JavaWizardIterator.getString("LBL_DefaultType_Mnemonic").charAt(0));
        this.abstractRadioButton.setMnemonic(JavaWizardIterator.getMnemonic("MNEMO_AbstractMethod"));
        this.finalCheckBox.setMnemonic(JavaWizardIterator.getMnemonic("MNEMO_FinalMethod"));
        this.nativeCheckBox.setMnemonic(JavaWizardIterator.getMnemonic("MNEMO_NativeMethod"));
        this.staticCheckBox.setMnemonic(JavaWizardIterator.getMnemonic("MNEMO_StaticMethod"));
        this.synchronizedCheckBox.setMnemonic(JavaWizardIterator.getMnemonic("MNEMO_SynchronizedMethod"));
    }

    public void setTypeModifier(int mod) {
        this.abstractRadioButton.setSelected(Modifier.isAbstract(mod));
        this.regularRadioButton.setSelected(!Modifier.isAbstract(mod));
        this.finalCheckBox.setSelected(Modifier.isFinal(mod));
        this.nativeCheckBox.setSelected(Modifier.isNative(mod));
        this.staticCheckBox.setSelected(Modifier.isStatic(mod));
        this.synchronizedCheckBox.setSelected(Modifier.isSynchronized(mod));
    }

    public int getTypeModifier() {
        if (this.abstractRadioButton.isSelected()) {
            return 1024;
        }
        int mod = 0;
        if (this.finalCheckBox.isSelected()) {
            mod |= 0x10;
        }
        if (this.nativeCheckBox.isSelected()) {
            mod |= 0x100;
        }
        if (this.staticCheckBox.isSelected()) {
            mod |= 8;
        }
        if (this.synchronizedCheckBox.isSelected()) {
            mod |= 0x20;
        }
        return mod;
    }

    public int getMask() {
        return 1336;
    }

    public Component getComponent() {
        return this;
    }

    private void initComponents() {
        this.regularRadioButton = new JRadioButton();
        this.finalCheckBox = new JCheckBox();
        this.nativeCheckBox = new JCheckBox();
        this.staticCheckBox = new JCheckBox();
        this.synchronizedCheckBox = new JCheckBox();
        this.abstractRadioButton = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Method Type"));
        this.regularRadioButton.setToolTipText(JavaWizardIterator.getString("ACS_DefaultMethodTypeA11yDesc"));
        this.regularRadioButton.setText(JavaWizardIterator.getString("LBL_DefaultType"));
        this.regularRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MethodTypePanel.this.regularRadioButtonStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.regularRadioButton, gridBagConstraints);
        this.finalCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_FinalMethodModifierA11yDesc"));
        this.finalCheckBox.setText("final");
        this.finalCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MethodTypePanel.this.checkBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 18, 0, 6);
        this.add((Component)this.finalCheckBox, gridBagConstraints);
        this.nativeCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_NativeMethodModifierA11yDesc"));
        this.nativeCheckBox.setText("native");
        this.nativeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MethodTypePanel.this.checkBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 18, 0, 6);
        this.add((Component)this.nativeCheckBox, gridBagConstraints);
        this.staticCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_StaticMethodModifierA11yDesc"));
        this.staticCheckBox.setText("static");
        this.staticCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MethodTypePanel.this.checkBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.staticCheckBox, gridBagConstraints);
        this.synchronizedCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_SynchronizedMethodModifierA11yDesc"));
        this.synchronizedCheckBox.setText("synchronized");
        this.synchronizedCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MethodTypePanel.this.checkBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.synchronizedCheckBox, gridBagConstraints);
        this.abstractRadioButton.setToolTipText(JavaWizardIterator.getString("ACS_AbstractMethodTypeA11yDesc"));
        this.abstractRadioButton.setText("abstract");
        this.abstractRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MethodTypePanel.this.abstractRadioButtonStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.abstractRadioButton, gridBagConstraints);
    }

    private void abstractRadioButtonStateChanged(ChangeEvent evt) {
        if (this.abstractRadioButton.isEnabled()) {
            this.changeChecksEnabled(!this.abstractRadioButton.isSelected());
            this.firePropertyChange("typeModifier", null, null);
        }
    }

    private void regularRadioButtonStateChanged(ChangeEvent evt) {
        this.changeChecksEnabled(this.regularRadioButton.isSelected());
        this.firePropertyChange("typeModifier", null, null);
    }

    private void checkBoxActionPerformed(ActionEvent evt) {
        this.firePropertyChange("typeModifier", null, null);
    }

    private void changeChecksEnabled(boolean b) {
        this.finalCheckBox.setEnabled(b);
        this.staticCheckBox.setEnabled(b);
        this.nativeCheckBox.setEnabled(b);
        this.synchronizedCheckBox.setEnabled(b);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

