/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.java.ui.IndexedRoot;
import org.netbeans.modules.java.ui.wizard.JavaPanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardData;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.netbeans.modules.java.ui.wizard.MemberListPanel;
import org.netbeans.modules.java.ui.wizard.MethodCustomizer;
import org.netbeans.modules.java.ui.wizard.MethodsChildren;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.src.Identifier;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MethodsPanel
extends JPanel
implements JavaPanel,
MemberListPanel.ElementCreator,
ExplorerManager.Provider {
    private static final MessageFormat METHOD_NAME_FORMAT = new MessageFormat(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$ui$wizard$MethodsPanel == null ? (class$org$netbeans$modules$java$ui$wizard$MethodsPanel = MethodsPanel.class$("org.netbeans.modules.java.ui.wizard.MethodsPanel")) : class$org$netbeans$modules$java$ui$wizard$MethodsPanel), (String)"FMT_NewMethodName"));
    private JavaWizardData wizardData;
    private MethodElement method;
    private MethodCustomizer methodCustomizer;
    private MemberListPanel listPanel;
    private ExplorerManager manager;
    private PropertyChangeListener managerListener;
    private int newElementCount = 0;
    private MethodElement created;
    private JLabel methodsLabel;
    private JLabel headLabel;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$wizard$MethodsPanel;
    static /* synthetic */ Class class$org$openide$src$MethodElement;

    public void initialize(JavaWizardData data) {
        this.wizardData = data;
        this.initComponents();
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(4));
        this.listPanel = new MemberListPanel(this);
        this.listPanel.newButton.setToolTipText(JavaWizardIterator.getString("ACS_NewMethodA11yDesc"));
        this.listPanel.duplicateButton.setToolTipText(JavaWizardIterator.getString("ACS_DuplicateMethodA11yDesc"));
        this.listPanel.deleteButton.setToolTipText(JavaWizardIterator.getString("ACS_DeleteMethodA11yDesc"));
        this.listPanel.upButton.setToolTipText(JavaWizardIterator.getString("ACS_UpMethodA11yDesc"));
        this.listPanel.downButton.setToolTipText(JavaWizardIterator.getString("ACS_DownMethodA11yDesc"));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.listPanel, gridBagConstraints1);
        this.methodCustomizer = new MethodCustomizer(this.method);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 2;
        this.add((Component)this.methodCustomizer, gridBagConstraints1);
        MethodsChildren c = new MethodsChildren(data.getCustomizedClass());
        IndexedRoot n = new IndexedRoot(c);
        this.getExplorerManager().setRootContext((Node)n);
        this.methodsLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Methods_Mnemonic").charAt(0));
        this.methodsLabel.setLabelFor(this.listPanel);
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.listPanel.setAccessibleDesc(JavaWizardIterator.getString("ACS_MethodListViewA11yName"), JavaWizardIterator.getString("ACS_MethodListViewA11yDesc"));
        this.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_MethodsPanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_MethodsPanelA11yDesc"));
        this.headLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Add_methodA11yDesc"));
    }

    private void initComponents() {
        this.headLabel = new JLabel();
        this.methodsLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setName(JavaWizardIterator.getString("TIT_AddMethodsWizardPanel"));
        this.headLabel.setText(JavaWizardIterator.getString("LBL_Add_method"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.headLabel, gridBagConstraints);
        this.methodsLabel.setText(JavaWizardIterator.getString("LBL_Methods"));
        this.methodsLabel.setLabelFor(this.listPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.methodsLabel, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (this.managerListener == null) {
            this.managerListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("selectedNodes".equals(evt.getPropertyName())) {
                        MethodsPanel.this.handleSelection((Node[])evt.getNewValue());
                    }
                }
            };
        }
        this.manager.addPropertyChangeListener(this.managerListener);
        this.handleSelection(this.manager.getSelectedNodes());
    }

    private void handleSelection(Node[] nodes) {
        MethodElement me = null;
        boolean enable = false;
        if (nodes.length == 1) {
            me = (MethodElement)nodes[0].getCookie(class$org$openide$src$MethodElement == null ? (class$org$openide$src$MethodElement = MethodsPanel.class$("org.openide.src.MethodElement")) : class$org$openide$src$MethodElement);
            enable = !this.containsOriginal(me);
        }
        this.customizeMethod(me, enable);
    }

    private void customizeMethod(MethodElement me, boolean enable) {
        if (enable) {
            this.methodCustomizer.setEnabled(true);
            this.methodCustomizer.setObject(me);
            if (this.created == me) {
                this.methodCustomizer.requestNameFocus();
            }
        } else {
            this.methodCustomizer.setObject(me);
            this.methodCustomizer.setEnabled(false);
        }
        this.created = null;
    }

    public void removeNotify() {
        super.removeNotify();
        this.manager.removePropertyChangeListener(this.managerListener);
    }

    public MemberElement createElement() throws SourceException {
        MethodElement el = new MethodElement();
        this.createName(el);
        this.wizardData.getCustomizedClass().addMethod(el);
        this.created = this.findMethod(el);
        return el;
    }

    MethodElement findMethod(MethodElement el) {
        MethodParameter[] pars = el.getParameters();
        Type[] t = new Type[pars.length];
        int i = 0;
        while (i < pars.length) {
            t[i] = pars[i].getType();
            ++i;
        }
        return this.wizardData.getCustomizedClass().getMethod(el.getName(), t);
    }

    public MemberElement duplicateElement(MemberElement template) throws SourceException {
        MethodElement el;
        try {
            el = (MethodElement)template.clone();
            this.createName(el);
        }
        catch (CloneNotSupportedException ex) {
            System.err.println(ex);
            el = (MethodElement)this.createElement();
        }
        this.wizardData.getCustomizedClass().addMethod(el);
        this.created = this.findMethod(el);
        return el;
    }

    private void createName(MethodElement el) throws SourceException {
        String name = METHOD_NAME_FORMAT.format(new Object[]{new Integer(this.newElementCount)});
        el.setName(Identifier.create((String)name));
        ++this.newElementCount;
    }

    public void deleteElement(MemberElement el) throws SourceException {
        this.wizardData.getCustomizedClass().removeMethod((MethodElement)el);
    }

    public boolean canDelete(MemberElement el) {
        return !this.containsOriginal((MethodElement)el);
    }

    private boolean elementEquals(MemberElement e1, MemberElement e2) {
        MethodElement.Key k1 = new MethodElement.Key((MethodElement)e1);
        MethodElement.Key k2 = new MethodElement.Key((MethodElement)e2);
        return k1.equals((Object)k2);
    }

    private boolean containsOriginal(MethodElement m) {
        MethodElement[] me = this.wizardData.getOriginalClass().getMethods();
        int i = 0;
        while (i < me.length) {
            if (this.elementEquals((MemberElement)m, (MemberElement)me[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
        }
        return this.manager;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.java.wizard.MethodDefs");
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
    }

    public boolean isValid() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

