/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Modifier;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import org.netbeans.modules.java.ui.wizard.AccessLevelPanel;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

public abstract class ModifierEditor
extends PropertyEditorSupport
implements PropertyChangeListener,
EnhancedCustomPropertyEditor {
    public static final String PROP_MODIFIER = "modifier";
    private static final String[] MODIFIER_NAMES = new String[]{"abstract", "final", "static", "synchronized", "transient", "volatile", "native"};
    private static final int[] MODIFIER_VALUES = new int[]{1024, 16, 8, 32, 128, 64, 256};
    private static final int MODIFIER_COUNT = MODIFIER_VALUES.length;
    private static final String[] ACCESS_NAMES = new String[]{"<default>", "private", "protected", "public"};
    private static final int[] ACCESS_VALUES = new int[]{0, 2, 4, 1};
    private static final int ACCESS_MASK = 7;
    private AccessLevelPanel accessLevelPanel;
    private ModifierPanel modifierPanel;
    private JPanel customEditor;

    public ModifierEditor(AccessLevelPanel accessLevelPanel, ModifierPanel modifierPanel) {
        this.accessLevelPanel = accessLevelPanel;
        this.modifierPanel = modifierPanel;
        accessLevelPanel.addPropertyChangeListener(this);
        modifierPanel.addPropertyChangeListener(this);
    }

    public AccessLevelPanel getAccessLevelPanel() {
        return this.accessLevelPanel;
    }

    public ModifierPanel getModifierPanel() {
        return this.modifierPanel;
    }

    public void setValue(Object object) throws IllegalArgumentException {
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        this.accessLevelPanel.setAccessLevel(7 & (Integer)object);
        this.modifierPanel.setTypeModifier((Integer)object);
    }

    public String getJavaInitializationString() {
        return this.getValue().toString();
    }

    public Object getValue() {
        return new Integer(this.accessLevelPanel.getAccessLevel() | this.modifierPanel.getTypeModifier());
    }

    public String getAsText() {
        return Modifier.toString((Integer)this.getValue());
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int newValue = 0;
        int oldValue = (Integer)this.getValue();
        int mask = this.modifierPanel.getMask();
        StringTokenizer tukac = new StringTokenizer(string, ", ", false);
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            boolean known = false;
            int i = 0;
            while (i < MODIFIER_COUNT) {
                if ((MODIFIER_VALUES[i] & mask) != 0 && token.equals(MODIFIER_NAMES[i])) {
                    if (MODIFIER_VALUES[i] == 16 && (newValue & 0x400) != 0 || MODIFIER_VALUES[i] == 1024 && (newValue & 0x10) != 0) break;
                    newValue |= MODIFIER_VALUES[i];
                    known = true;
                    break;
                }
                ++i;
            }
            if ((newValue & 7) == 0) {
                int i2 = 1;
                while (i2 <= 3) {
                    if ((ACCESS_VALUES[i2] & mask) != 0 && token.equals(ACCESS_NAMES[i2])) {
                        newValue |= ACCESS_VALUES[i2];
                        known = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (known) continue;
            throw new IllegalArgumentException();
        }
        if (oldValue != newValue) {
            this.setValue(new Integer(newValue));
            this.firePropertyChange();
        }
    }

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.customEditor = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 0, 11, 0);
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.anchor = 18;
            this.customEditor.add((Component)this.accessLevelPanel, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.anchor = 18;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            this.customEditor.add(this.modifierPanel.getComponent(), gridBagConstraints1);
        }
        return this.customEditor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getValue();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("typeModifier".equals(evt.getPropertyName())) {
            this.firePropertyChange();
        } else if ("accessLevel".equals(evt.getPropertyName())) {
            this.firePropertyChange();
        }
    }

    public static interface ModifierPanel {
        public static final String PROP_TYPE_MODIFIER = "typeModifier";

        public void setTypeModifier(int var1);

        public int getTypeModifier();

        public int getMask();

        public Component getComponent();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }
}

