/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.java.tools.ElementFilter;
import org.netbeans.modules.java.ui.wizard.InheritanceChildren;
import org.netbeans.modules.java.ui.wizard.JavaPanel;
import org.netbeans.modules.java.ui.wizard.JavaWizardData;
import org.netbeans.modules.java.ui.wizard.JavaWizardIterator;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.util.HelpCtx;

public class OverridePanel
extends JPanel
implements JavaPanel {
    private JavaWizardData wizardData;
    private PropertyChangeListener managerListener;
    private JCheckBox inheritedCheckBox;
    private JLabel overridenMethodsLabel;
    private JLabel avaliableMethodsLabel;
    private JButton addAllButton;
    private JCheckBox abstractCheckBox;
    private JButton removeAllButton;
    private JCheckBox superCheckBox;
    private JPanel jPanel1;
    private JLabel headLabel;
    private JButton addButton;
    private JButton removeButton;
    private ListView listView;
    private BeanTreeView beanTreeView;
    private ExPanel treeExplorerPanel;
    private ExPanel listExplorerPanel;
    static /* synthetic */ Class class$org$openide$src$MemberElement;
    static /* synthetic */ Class class$org$openide$src$MethodElement;

    public void initialize(JavaWizardData data) {
        this.wizardData = data;
        this.initComponents();
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(3));
        InheritanceChildren lc = new InheritanceChildren(data.getInheritance(), new ClassComparator(), new MethodComparator(), this.getAvailableMethodsFilter(true, false));
        AbstractNode treeNode = new AbstractNode((Children)lc);
        this.treeExplorerPanel = new ExPanel();
        this.treeExplorerPanel.setLayout(new BorderLayout());
        this.treeExplorerPanel.getExplorerManager().setRootContext((Node)treeNode);
        this.beanTreeView = new BeanTreeView();
        this.beanTreeView.setRootVisible(false);
        this.beanTreeView.setPopupAllowed(false);
        this.treeExplorerPanel.add("Center", (Component)this.beanTreeView);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.gridheight = 1;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 0, 5, 11);
        gridBagConstraints1.weightx = 0.2;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.treeExplorerPanel, gridBagConstraints1);
        InheritanceChildren.OverridenMethods methodsToOverride = new InheritanceChildren.OverridenMethods(data.getCustomizedClass(), data.getInheritance(), new MethodComparator());
        AbstractNode listNode = new AbstractNode((Children)methodsToOverride);
        this.listExplorerPanel = new ExPanel();
        this.listExplorerPanel.setLayout(new BorderLayout());
        this.listExplorerPanel.getExplorerManager().setRootContext((Node)listNode);
        this.listView = new ListView();
        this.listView.setPopupAllowed(false);
        this.listExplorerPanel.add("Center", (Component)this.listView);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridheight = 1;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.listExplorerPanel, gridBagConstraints1);
        this.avaliableMethodsLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Available_superclass_Mnemonic").charAt(0));
        this.avaliableMethodsLabel.setLabelFor((Component)this.beanTreeView);
        this.overridenMethodsLabel.setDisplayedMnemonic(JavaWizardIterator.getString("LBL_Methods_overridden_Mnemonic").charAt(0));
        this.overridenMethodsLabel.setLabelFor((Component)this.listView);
        this.inheritedCheckBox.setMnemonic(JavaWizardIterator.getString("LBL_Show_inherited_Mnemonic").charAt(0));
        this.abstractCheckBox.setMnemonic(JavaWizardIterator.getString("LBL_Only_show_abstract_Mnemonic").charAt(0));
        this.addButton.setMnemonic(JavaWizardIterator.getString("LBL_Add_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(JavaWizardIterator.getString("LBL_Remove_Mnemonic").charAt(0));
        this.addAllButton.setMnemonic(JavaWizardIterator.getString("LBL_Add_All_Mnemonic").charAt(0));
        this.removeAllButton.setMnemonic(JavaWizardIterator.getString("LBL_Remove_All_Mnemonic").charAt(0));
        this.superCheckBox.setMnemonic(JavaWizardIterator.getString("LBL_Generate_super_calls_Mnemonic").charAt(0));
        this.initAccessibility();
        this.updateButtons();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(JavaWizardIterator.getString("ACS_OverridePanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_OverridePanelA11yDesc"));
        this.headLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Select_methodsA11yDesc"));
        this.avaliableMethodsLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Available_superclassA11yDesc"));
        this.overridenMethodsLabel.getAccessibleContext().setAccessibleDescription(JavaWizardIterator.getString("ACS_Methods_overriddenA11yDesc"));
    }

    public boolean requestDefaultFocus() {
        return this.treeExplorerPanel.requestDefaultFocus();
    }

    private void initComponents() {
        this.headLabel = new JLabel();
        this.avaliableMethodsLabel = new JLabel();
        this.overridenMethodsLabel = new JLabel();
        this.inheritedCheckBox = new JCheckBox();
        this.abstractCheckBox = new JCheckBox();
        this.superCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addAllButton = new JButton();
        this.removeAllButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setName(JavaWizardIterator.getString("TIT_OverrideWizardPanel"));
        this.headLabel.setText(JavaWizardIterator.getString("LBL_Select_methods"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.headLabel, gridBagConstraints);
        this.avaliableMethodsLabel.setLabelFor((Component)this.beanTreeView);
        this.avaliableMethodsLabel.setText(JavaWizardIterator.getString("LBL_Available_superclass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.avaliableMethodsLabel, gridBagConstraints);
        this.overridenMethodsLabel.setLabelFor((Component)this.listView);
        this.overridenMethodsLabel.setText(JavaWizardIterator.getString("LBL_Methods_overridden"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.overridenMethodsLabel, gridBagConstraints);
        this.inheritedCheckBox.setText(JavaWizardIterator.getString("LBL_Show_inherited"));
        this.inheritedCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_Show_inheritedA11yDesc"));
        this.inheritedCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverridePanel.this.inheritedCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.inheritedCheckBox, gridBagConstraints);
        this.abstractCheckBox.setText(JavaWizardIterator.getString("LBL_Only_show_abstract"));
        this.abstractCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_Only_show_abstractA11yDesc"));
        this.abstractCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverridePanel.this.abstractCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.abstractCheckBox, gridBagConstraints);
        this.superCheckBox.setText(JavaWizardIterator.getString("LBL_Generate_super_calls"));
        this.superCheckBox.setToolTipText(JavaWizardIterator.getString("ACS_Generate_super_callsA11yDesc"));
        this.superCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverridePanel.this.superCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.add((Component)this.superCheckBox, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.addButton.setText(JavaWizardIterator.getString("LBL_Add"));
        this.addButton.setToolTipText(JavaWizardIterator.getString("ACS_AddA11yDesc"));
        this.addButton.setMargin(new Insets(2, 8, 2, 8));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverridePanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText(JavaWizardIterator.getString("LBL_Remove"));
        this.removeButton.setToolTipText(JavaWizardIterator.getString("ACS_RemoveA11yDesc"));
        this.removeButton.setMargin(new Insets(2, 8, 2, 8));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverridePanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.jPanel1.add((Component)this.removeButton, gridBagConstraints);
        this.addAllButton.setText(JavaWizardIterator.getString("LBL_Add_All"));
        this.addAllButton.setToolTipText(JavaWizardIterator.getString("ACS_Add_AllA11yDesc"));
        this.addAllButton.setMargin(new Insets(2, 8, 2, 8));
        this.addAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverridePanel.this.addAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.addAllButton, gridBagConstraints);
        this.removeAllButton.setText(JavaWizardIterator.getString("LBL_Remove_All"));
        this.removeAllButton.setToolTipText(JavaWizardIterator.getString("ACS_Remove_AllA11yDesc"));
        this.removeAllButton.setMargin(new Insets(2, 8, 2, 8));
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OverridePanel.this.removeAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.removeAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void superCheckBoxActionPerformed(ActionEvent evt) {
        Collection override = this.collectMethodsToOverride(new Node[]{this.listExplorerPanel.getExplorerManager().getRootContext()});
        this.undoOverrideMethods(override);
        this.overrideMethods(override);
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        this.undoOverrideMethods(this.collectMethodsToOverride(new Node[]{this.listExplorerPanel.getExplorerManager().getRootContext()}));
        this.updateButtons();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.undoOverrideMethods(this.collectMethodsToOverride(this.listExplorerPanel.getExplorerManager().getSelectedNodes()));
        this.updateButtons();
    }

    private void addAllButtonActionPerformed(ActionEvent evt) {
        this.overrideMethods(this.collectMethodsToOverride(new Node[]{this.treeExplorerPanel.getExplorerManager().getRootContext()}));
        this.updateButtons();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.overrideMethods(this.collectMethodsToOverride(this.treeExplorerPanel.getExplorerManager().getSelectedNodes()));
        this.updateButtons();
    }

    private void abstractCheckBoxActionPerformed(ActionEvent evt) {
        InheritanceChildren children = (InheritanceChildren)this.treeExplorerPanel.getExplorerManager().getRootContext().getChildren();
        children.setFilter(this.getAvailableMethodsFilter(true, this.abstractCheckBox.isSelected()));
        this.updateButtons();
    }

    private void inheritedCheckBoxActionPerformed(ActionEvent evt) {
        InheritanceChildren children = (InheritanceChildren)this.treeExplorerPanel.getExplorerManager().getRootContext().getChildren();
        children.setMethodsOnly(this.inheritedCheckBox.isSelected());
        this.updateButtons();
    }

    private void undoOverrideMethods(Collection methods) {
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MethodElement me = (MethodElement)iter.next();
            try {
                if (this.containsOriginal(me)) continue;
                this.wizardData.getInheritance().getSourceClass().removeMethod(me);
            }
            catch (SourceException ex) {
                // empty catch block
            }
        }
    }

    private void overrideMethods(Collection methods) {
        ArrayList<MethodElement> newMethods = new ArrayList<MethodElement>();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MethodElement me = (MethodElement)iter.next();
            try {
                newMethods.add(this.wizardData.getInheritance().overrideMethod(me, this.superCheckBox.isSelected()));
            }
            catch (SourceException ex) {
                // empty catch block
            }
        }
    }

    private Collection collectMethodsToOverride(Node[] n) {
        ArrayList<MemberElement> list = new ArrayList<MemberElement>();
        int i = 0;
        while (i < n.length) {
            if (!n[i].isLeaf()) {
                list.addAll(this.collectMethodsToOverride(n[i].getChildren().getNodes()));
            } else {
                MemberElement me = (MemberElement)n[i].getCookie(class$org$openide$src$MemberElement == null ? OverridePanel.class$("org.openide.src.MemberElement") : class$org$openide$src$MemberElement);
                if (me instanceof MethodElement) {
                    list.add(me);
                }
            }
            ++i;
        }
        return list;
    }

    private void updateButtons() {
        Node[] treeSelectedNodes = this.treeExplorerPanel.getExplorerManager().getSelectedNodes();
        Node[] listSelectedNodes = this.listExplorerPanel.getExplorerManager().getSelectedNodes();
        Node[] treeNodes = this.treeExplorerPanel.getExplorerManager().getRootContext().getChildren().getNodes();
        Node[] listNodes = this.listExplorerPanel.getExplorerManager().getRootContext().getChildren().getNodes();
        this.addButton.setEnabled(treeSelectedNodes.length > 0);
        this.addAllButton.setEnabled(treeNodes.length > 0);
        this.removeAllButton.setEnabled(listNodes.length > 0);
        try {
            Node[] firstNode;
            if (treeNodes.length > 0 && treeSelectedNodes.length == 0) {
                firstNode = new Node[]{treeNodes[0]};
                this.treeExplorerPanel.getExplorerManager().setSelectedNodes(firstNode);
            }
            if (listNodes.length > 0 && listSelectedNodes.length == 0) {
                firstNode = new Node[]{listNodes[0]};
                this.listExplorerPanel.getExplorerManager().setSelectedNodes(firstNode);
            }
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
        boolean canRemove = false;
        int i = 0;
        while (i < listSelectedNodes.length) {
            if (!this.containsOriginal((MethodElement)listSelectedNodes[i].getCookie(class$org$openide$src$MethodElement == null ? OverridePanel.class$("org.openide.src.MethodElement") : class$org$openide$src$MethodElement))) {
                canRemove = true;
                break;
            }
            ++i;
        }
        this.removeButton.setEnabled(canRemove);
    }

    private boolean containsOriginal(MethodElement m) {
        MethodElement[] me = this.wizardData.getOriginalClass().getMethods();
        int i = 0;
        while (i < me.length) {
            if (this.elementEquals((MemberElement)m, (MemberElement)me[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean elementEquals(MemberElement e1, MemberElement e2) {
        MethodElement.Key k1 = new MethodElement.Key((MethodElement)e1);
        MethodElement.Key k2 = new MethodElement.Key((MethodElement)e2);
        return k1.equals((Object)k2);
    }

    public void addNotify() {
        super.addNotify();
        if (this.managerListener == null) {
            this.managerListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("selectedNodes".equals(evt.getPropertyName())) {
                        OverridePanel.this.updateButtons();
                    }
                }
            };
        }
        this.treeExplorerPanel.getExplorerManager().addPropertyChangeListener(this.managerListener);
        this.listExplorerPanel.getExplorerManager().addPropertyChangeListener(this.managerListener);
        ((InheritanceChildren.OverridenMethods)this.listExplorerPanel.getExplorerManager().getExploredContext().getChildren()).refreshKeys();
    }

    public void removeNotify() {
        super.removeNotify();
        this.treeExplorerPanel.getExplorerManager().removePropertyChangeListener(this.managerListener);
        this.listExplorerPanel.getExplorerManager().removePropertyChangeListener(this.managerListener);
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.java.wizard.OverrideMethods");
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
    }

    public boolean isValid() {
        return true;
    }

    protected ElementFilter.Method getAvailableMethodsFilter(boolean includeInherited, final boolean filterAbstract) {
        if (includeInherited) {
            return new ElementFilter.Method(){

                public boolean accept(MethodElement m) {
                    boolean ok = OverridePanel.this.wizardData.getInheritance().isOverridable(m);
                    if (filterAbstract) {
                        ok &= Modifier.isAbstract(m.getModifiers());
                    }
                    return ok;
                }
            };
        }
        return new ElementFilter.Method(){

            public boolean accept(MethodElement m) {
                boolean ok = OverridePanel.this.wizardData.getInheritance().isOverridable(m);
                if (filterAbstract) {
                    ok &= Modifier.isAbstract(m.getModifiers());
                }
                return ok;
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MethodComparator
    implements Comparator {
        private MethodComparator() {
        }

        public int compare(Object a, Object b) {
            MethodElement ma = (MethodElement)a;
            MethodElement mb = (MethodElement)b;
            if (ma == mb) {
                return 0;
            }
            int result = ma.getName().getSourceName().compareTo(mb.getName().getSourceName());
            if (result != 0) {
                return result;
            }
            result = ma.getParameters().length - mb.getParameters().length;
            if (result != 0) {
                return result;
            }
            MethodParameter[] paramA = ma.getParameters();
            MethodParameter[] paramB = mb.getParameters();
            int i = 0;
            while (i < paramA.length) {
                result = paramA[i].getFullString().compareTo(paramB[i].getFullString());
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            return 0;
        }

        public boolean equals(Object ob) {
            return ob instanceof MethodComparator;
        }
    }

    private static class ExPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager manager;

        private ExPanel() {
        }

        public ExplorerManager getExplorerManager() {
            if (this.manager == null) {
                this.manager = new ExplorerManager();
            }
            return this.manager;
        }
    }

    private class ClassComparator
    implements Comparator {
        private ClassComparator() {
        }

        public int compare(Object value1, Object value2) {
            ClassElement v1 = (ClassElement)value1;
            ClassElement v2 = (ClassElement)value2;
            if (v1.isClassOrInterface() != v2.isClassOrInterface()) {
                return v1.isClassOrInterface() ? -1 : 1;
            }
            if (v1.isClassOrInterface()) {
                String fqn = v2.getName().getFullName();
                while (v1.getSuperclass() != null) {
                    if (v1.getSuperclass().getFullName().equals(fqn)) {
                        return 1;
                    }
                    v1 = OverridePanel.this.wizardData.getInheritance().getClass(v1.getSuperclass(), true);
                }
                return -1;
            }
            return v1.getName().getFullName().compareTo(v2.getName().getFullName());
        }

        public boolean equals(Object p1) {
            return p1 instanceof ClassComparator;
        }
    }
}

