/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.Lookup;

public final class NbClassPath
implements Serializable {
    static final long serialVersionUID = -8458093409814321744L;
    private Object[] items;
    private String classpath;
    static /* synthetic */ Class class$org$openide$execution$ExecutionEngine;

    public NbClassPath(String[] classpathItems) {
        this.items = classpathItems;
    }

    public NbClassPath(File[] classpathItems) {
        this.items = classpathItems;
    }

    private NbClassPath(Object[] arr) {
        this.items = arr;
    }

    public NbClassPath(String path) {
        this.items = new Exception[0];
        this.classpath = path;
        if (path.indexOf(32) >= 0) {
            if (path.startsWith("\"")) {
                return;
            }
            StringBuffer buff = new StringBuffer(path);
            buff.insert(0, '\"');
            buff.append('\"');
            this.classpath = buff.toString();
        }
    }

    public static NbClassPath createRepositoryPath() {
        return NbClassPath.createRepositoryPath(FileSystemCapability.ALL);
    }

    public static NbClassPath createRepositoryPath(FileSystemCapability cap) {
        LinkedList<EnvironmentNotSupportedException> res = new LinkedList<EnvironmentNotSupportedException>();
        final class Env
        extends FileSystem.Environment {
            private final /* synthetic */ LinkedList val$res;

            Env(LinkedList val$res) {
                this.val$res = val$res;
            }

            public void addClassPath(String element) {
                this.val$res.add(element);
            }
        }
        Env env = new Env(res);
        Enumeration en = cap.fileSystems();
        while (en.hasMoreElements()) {
            try {
                FileSystem fs = (FileSystem)en.nextElement();
                fs.prepareEnvironment((FileSystem.Environment)env);
            }
            catch (EnvironmentNotSupportedException ex) {
                res.add(ex);
            }
        }
        return new NbClassPath(res.toArray());
    }

    public static NbClassPath createLibraryPath() {
        ExecutionEngine ee = (ExecutionEngine)Lookup.getDefault().lookup(class$org$openide$execution$ExecutionEngine == null ? (class$org$openide$execution$ExecutionEngine = NbClassPath.class$("org.openide.execution.ExecutionEngine")) : class$org$openide$execution$ExecutionEngine);
        if (ee != null) {
            return ee.createLibraryPath();
        }
        return new NbClassPath(new File[0]);
    }

    public static NbClassPath createClassPath() {
        String cp = System.getProperty("java.class.path");
        if (cp == null || cp.length() == 0) {
            return new NbClassPath("");
        }
        StringBuffer buf = new StringBuffer(cp.length());
        StringTokenizer tok = new StringTokenizer(cp, File.pathSeparator);
        boolean appended = false;
        while (tok.hasMoreTokens()) {
            String piece = tok.nextToken();
            if (piece.endsWith("openide-compat.jar")) continue;
            if (appended) {
                buf.append(File.pathSeparatorChar);
            } else {
                appended = true;
            }
            buf.append(piece);
        }
        return new NbClassPath(buf.toString());
    }

    public static NbClassPath createBootClassPath() {
        String boot = System.getProperty("sun.boot.class.path");
        StringBuffer sb = boot != null ? new StringBuffer(boot) : new StringBuffer();
        String extensions = System.getProperty("java.ext.dirs");
        if (extensions != null) {
            StringTokenizer st = new StringTokenizer(extensions, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                File[] entries = dir.listFiles();
                if (entries == null) continue;
                int i = 0;
                while (i < entries.length) {
                    String name = entries[i].getName().toLowerCase(Locale.US);
                    if (name.endsWith(".zip") || name.endsWith(".jar")) {
                        if (sb.length() > 0) {
                            sb.append(File.pathSeparatorChar);
                        }
                        sb.append(entries[i].getPath());
                    }
                    ++i;
                }
            }
        }
        return new NbClassPath(sb.toString());
    }

    public static File toFile(FileObject fo) {
        String pne = fo.getPath().replace('/', File.separatorChar);
        final class Env
        extends FileSystem.Environment {
            public File found;
            private final /* synthetic */ String val$pne;

            Env(String val$pne) {
                this.val$pne = val$pne;
            }

            public void addClassPath(String element) {
                if (this.found != null) {
                    return;
                }
                File p = new File(element);
                if (!p.isDirectory()) {
                    return;
                }
                File f = new File(p, this.val$pne);
                if (f.exists()) {
                    this.found = f;
                }
            }
        }
        Env env = new Env(pne);
        try {
            fo.getFileSystem().prepareEnvironment((FileSystem.Environment)env);
            return env.found;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public Exception[] getExceptions() {
        try {
            return (Exception[])this.items;
        }
        catch (ClassCastException classCastException) {
            NbClassPath nbClassPath = this;
            synchronized (nbClassPath) {
                this.getClassPath();
                int first = 0;
                int i = 0;
                while (i < this.items.length) {
                    if (this.items[i] != null) {
                        this.items[first++] = this.items[i];
                    }
                    ++i;
                }
                Exception[] list = new Exception[first];
                System.arraycopy(this.items, 0, list, 0, first);
                this.items = list;
                Exception[] exceptionArray = list;
                return exceptionArray;
            }
        }
    }

    public String getClassPath() {
        if (this.classpath != null) {
            return this.classpath;
        }
        NbClassPath nbClassPath = this;
        synchronized (nbClassPath) {
            if (this.classpath != null) {
                String string = this.classpath;
                return string;
            }
            if (this.items.length == 0) {
                this.classpath = "";
                String string = "";
                return string;
            }
            StringBuffer sb = new StringBuffer();
            boolean haveone = false;
            int i = 0;
            while (i < this.items.length) {
                Object o = this.items[i];
                if (o != null && (o instanceof String || o instanceof File)) {
                    if (haveone) {
                        sb.append(File.pathSeparatorChar);
                    } else {
                        haveone = true;
                    }
                    sb.append(o.toString());
                    this.items[i] = null;
                }
                ++i;
            }
            String clsPth = sb.toString();
            if (clsPth.indexOf(32) >= 0) {
                sb.insert(0, '\"');
                sb.append('\"');
                this.classpath = sb.toString();
            } else {
                this.classpath = clsPth;
            }
            String string = this.classpath;
            return string;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof NbClassPath)) {
            return false;
        }
        NbClassPath him = (NbClassPath)o;
        return this.getClassPath().equals(him.getClassPath());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

