/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class NbProcessDescriptor
implements Serializable {
    private static final long serialVersionUID = -4535211234565221486L;
    private static ErrorManager execLog;
    private String processName;
    private String arguments;
    private String info;

    public NbProcessDescriptor(String processName, String arguments) {
        this(processName, arguments, null);
    }

    public NbProcessDescriptor(String processName, String arguments, String info) {
        this.processName = processName;
        this.arguments = arguments;
        this.info = info;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getInfo() {
        return this.info;
    }

    public Process exec(Format format, String[] envp, File cwd) throws IOException {
        return this.exec(format, envp, false, cwd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Process exec(Format format, String[] envp, boolean appendEnv, File cwd) throws IOException {
        Process process;
        int currentPriority;
        Thread currentThread;
        int os;
        block14: {
            Process process2;
            block13: {
                String stringArgs = format == null ? this.arguments : format.format(this.arguments);
                String[] args = NbProcessDescriptor.parseArguments(stringArgs);
                String[] call = null;
                envp = NbProcessDescriptor.substituteEnv(format, envp);
                if (Utilities.getOperatingSystem() == 8192 && this.isJavaCmd(args)) {
                    call = this.constructVMSCmdLine(format, args);
                } else {
                    call = new String[args.length + 1];
                    call[0] = format == null ? this.processName : format.format(this.processName);
                    System.arraycopy(args, 0, call, 1, args.length);
                }
                NbProcessDescriptor.logArgs(call);
                if (envp != null && appendEnv) {
                    HashMap e = new HashMap(100);
                    Iterator it = ((Hashtable)System.getProperties()).entrySet().iterator();
                    while (true) {
                        if (!it.hasNext()) break;
                        Map.Entry entry = it.next();
                        String prop = (String)entry.getKey();
                        if (!prop.startsWith("Env-")) continue;
                        String evar = prop.substring(4);
                        e.put(evar, entry.getValue());
                    }
                    int i = 0;
                    while (true) {
                        if (i >= envp.length) {
                            envp = new String[e.size()];
                            int i2 = 0;
                            it = e.entrySet().iterator();
                            break;
                        }
                        String nameval = envp[i];
                        int idx = nameval.indexOf(61);
                        if (idx == -1) {
                            throw new IOException("No equal sign in name=value: " + nameval);
                        }
                        e.put(nameval.substring(0, idx), nameval.substring(idx + 1));
                        ++i;
                    }
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        envp[i2++] = (String)entry.getKey() + '=' + (String)entry.getValue();
                    }
                }
                os = Utilities.getOperatingSystem();
                currentThread = null;
                currentPriority = 0;
                try {
                    if (os == 4) {
                        currentThread = Thread.currentThread();
                        currentPriority = currentThread.getPriority();
                        currentThread.setPriority(5);
                    }
                    if (cwd == null) {
                        if (envp == null) {
                            Process process3 = Runtime.getRuntime().exec(call);
                            Object var14_20 = null;
                            if (os != 4) return process3;
                            currentThread.setPriority(currentPriority);
                            return process3;
                        }
                        process2 = Runtime.getRuntime().exec(call, envp);
                        break block13;
                    }
                    process = Runtime.getRuntime().exec(call, envp, cwd);
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var14_23 = null;
                    if (os != 4) throw throwable;
                    currentThread.setPriority(currentPriority);
                    throw throwable;
                }
            }
            Object var14_21 = null;
            if (os != 4) return process2;
            currentThread.setPriority(currentPriority);
            return process2;
        }
        Object var14_22 = null;
        if (os != 4) return process;
        currentThread.setPriority(currentPriority);
        return process;
    }

    private static void logArgs(String[] args) {
        try {
            ResourceBundle rb = NbBundle.getBundle((String)"org.openide.execution.Bundle");
            String exc = rb.getString("CTL_Exec");
            String fmt = rb.getString("FMT_ExecParams");
            MessageFormat msgformat = new MessageFormat(fmt);
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            printer.println(exc);
            int i = 0;
            while (i < args.length) {
                printer.println(msgformat.format(new Object[]{new Integer(i), args[i]}));
                ++i;
            }
            printer.close();
            NbProcessDescriptor.getExecLog().log(1, writer.toString());
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public Process exec(Format format, String[] envp) throws IOException {
        return this.exec(format, envp, null);
    }

    public Process exec(Format format) throws IOException {
        return this.exec(format, null);
    }

    public Process exec() throws IOException {
        return this.exec(null, null);
    }

    public int hashCode() {
        return this.processName.hashCode() + this.arguments.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NbProcessDescriptor)) {
            return false;
        }
        NbProcessDescriptor him = (NbProcessDescriptor)o;
        return this.processName.equals(him.processName) && this.arguments.equals(him.arguments);
    }

    private static String[] parseArguments(String sargs) {
        return Utilities.parseParameters((String)sargs);
    }

    private static ErrorManager getExecLog() {
        if (execLog == null) {
            execLog = ErrorManager.getDefault().getInstance("IDE-Exec");
        }
        return execLog;
    }

    private boolean isJavaCmd(String[] args) {
        return args.length > 0 && (this.processName.endsWith("{/}java") || this.processName.endsWith("{/}javac"));
    }

    private String[] constructVMSCmdLine(Format format, String[] args) throws IOException {
        PrintWriter pWriter = null;
        File switchFile = null;
        String atFileName = null;
        String javacCmd = "{/}javac";
        try {
            switchFile = File.createTempFile("compilerparams", "pms");
            switchFile.deleteOnExit();
            pWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(switchFile)));
            int i = 0;
            while (i < args.length) {
                if (args[i].charAt(0) == '@' && this.processName.endsWith("{/}javac")) {
                    atFileName = args[i];
                } else {
                    pWriter.println(args[i]);
                }
                ++i;
            }
            Object var9_9 = null;
            if (pWriter != null) {
                pWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (pWriter != null) {
                pWriter.close();
            }
            throw throwable;
        }
        String[] call = atFileName != null ? new String[4] : new String[3];
        call[0] = format == null ? this.processName : format.format(this.processName);
        call[1] = "-V";
        call[2] = switchFile.getAbsolutePath();
        if (call.length > 3) {
            call[3] = atFileName;
        }
        return call;
    }

    private static String[] substituteEnv(Format format, String[] envp) {
        if (envp == null || envp.length == 0 || format == null) {
            return envp;
        }
        String[] ret = new String[envp.length];
        StringBuffer adder = new StringBuffer();
        int i = 0;
        while (i < envp.length) {
            int idx;
            ret[i] = envp[i];
            if (ret[i] != null && (idx = ret[i].indexOf(61)) >= 0) {
                String val = ret[i].substring(idx + 1);
                String key = ret[i].substring(0, idx);
                adder.append(key).append('=').append(format.format(val));
                ret[i] = adder.toString();
                adder.setLength(0);
            }
            ++i;
        }
        return ret;
    }
}

