/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.ServiceType;
import org.openide.cookies.ArgumentsCookie;
import org.openide.cookies.ExecCookie;
import org.openide.execution.Executor;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExecutionSupport
implements ExecCookie,
ArgumentsCookie {
    private static final String EA_EXECUTOR = "NetBeansAttrExecutor";
    private static final String EA_ARGUMENTS = "NetBeansAttrArguments";
    public static final String PROP_FILE_PARAMS = "params";
    public static final String PROP_EXECUTION = "execution";
    private MultiDataObject.Entry entry;
    protected static final String READONLY_ATTRIBUTES = "readOnlyAttrs";
    static /* synthetic */ Class class$org$openide$execution$Executor;
    static /* synthetic */ Class class$java$lang$String;

    public ExecutionSupport(MultiDataObject.Entry entry) {
        this.entry = entry;
    }

    protected MultiDataObject.Entry getEntry() {
        return this.entry;
    }

    public void start() {
        Executor exec = ExecutionSupport.getExecutor(this.entry);
        if (exec == null) {
            exec = this.defaultExecutor();
        }
        try {
            exec.execute((DataObject)this.entry.getDataObject());
        }
        catch (IOException ex) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (ExecutionSupport.this.startFailed(ex)) {
                        ExecutionSupport.this.start();
                    }
                }
            });
        }
    }

    protected boolean startFailed(IOException ex) {
        Executor e;
        Executor orig = ExecutionSupport.getExecutor(this.entry);
        if (orig == null) {
            orig = this.defaultExecutor();
        }
        if ((e = (Executor)ExecutionSupport.choose(orig, class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecutionSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor, ex)) == null) {
            return false;
        }
        try {
            ExecutionSupport.setExecutor(this.entry, e);
            return true;
        }
        catch (IOException exc) {
            return false;
        }
    }

    protected Executor defaultExecutor() {
        return Executor.getDefault();
    }

    public static void setExecutor(MultiDataObject.Entry entry, Executor exec) throws IOException {
        entry.getFile().setAttribute(EA_EXECUTOR, (Object)(exec == null ? null : new ServiceType.Handle((ServiceType)exec)));
    }

    public static Executor getExecutor(MultiDataObject.Entry entry) {
        ServiceType exec;
        Object handle = entry.getFile().getAttribute(EA_EXECUTOR);
        if (handle != null && handle instanceof ServiceType.Handle && (exec = ((ServiceType.Handle)handle).getServiceType()) instanceof Executor) {
            return (Executor)exec;
        }
        Lookup l = Environment.find((DataObject)entry.getDataObject());
        Executor et = (Executor)((Object)l.lookup(class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecutionSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor));
        if (et != null) {
            return et;
        }
        return null;
    }

    public void setArguments(String[] args) throws IOException {
        this.entry.getFile().setAttribute(EA_ARGUMENTS, (Object)args);
    }

    public static void setArguments(MultiDataObject.Entry entry, String[] args) throws IOException {
        entry.getFile().setAttribute(EA_ARGUMENTS, (Object)args);
    }

    public String[] getArguments() {
        return ExecutionSupport.getArguments(this.entry);
    }

    public static String[] getArguments(MultiDataObject.Entry entry) {
        Object o = entry.getFile().getAttribute(EA_ARGUMENTS);
        if (o != null && o instanceof String[]) {
            return (String[])o;
        }
        return new String[0];
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createParamsProperty());
        set.put((Node.Property)this.createExecutorProperty());
    }

    private PropertySupport createParamsProperty() {
        return new PropertySupport.ReadWrite(PROP_FILE_PARAMS, class$java$lang$String == null ? (class$java$lang$String = ExecutionSupport.class$("java.lang.String")) : class$java$lang$String, ExecutionSupport.getString("PROP_fileParams"), ExecutionSupport.getString("HINT_fileParams")){

            public Object getValue() {
                String[] args = ExecutionSupport.this.getArguments();
                return Utilities.escapeParameters((String[])args);
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String) {
                    try {
                        ExecutionSupport.this.setArguments(Utilities.parseParameters((String)((String)val)));
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    ExecutionSupport.this.setArguments(null);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public boolean canWrite() {
                Boolean isReadOnly = (Boolean)ExecutionSupport.this.entry.getFile().getAttribute(ExecutionSupport.READONLY_ATTRIBUTES);
                return isReadOnly == null ? false : isReadOnly == false;
            }
        };
    }

    private PropertySupport createExecutorProperty() {
        return new PropertySupport.ReadWrite(PROP_EXECUTION, class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecutionSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor, ExecutionSupport.getString("PROP_execution"), ExecutionSupport.getString("HINT_execution")){

            public Object getValue() {
                Executor e = ExecutionSupport.getExecutor(ExecutionSupport.this.entry);
                if (e == null) {
                    return ExecutionSupport.this.defaultExecutor();
                }
                return e;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    ExecutionSupport.setExecutor(ExecutionSupport.this.entry, (Executor)((Object)val));
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                Boolean isReadOnly = (Boolean)ExecutionSupport.this.entry.getFile().getAttribute(ExecutionSupport.READONLY_ATTRIBUTES);
                return isReadOnly == null ? false : isReadOnly == false;
            }
        };
    }

    static String getString(String s) {
        return NbBundle.getMessage((Class)(class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecutionSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor), (String)s);
    }

    protected static ServiceType choose(ServiceType current, Class clazz, Exception ex) {
        String lm;
        ErrorManager em = ErrorManager.getDefault();
        em.notify(1, (Throwable)ex);
        PropertyEditor ed = PropertyEditorManager.findEditor(clazz);
        if (ed == null) {
            return null;
        }
        ed.setValue(current);
        Component c = ed.getCustomEditor();
        if (c == null) {
            return null;
        }
        String configure = ExecutionSupport.getString("CTL_ServiceConfigure");
        NotifyDescriptor.Message exc = new NotifyDescriptor.Message(null, 0);
        exc.setTitle(ExecutionSupport.getString("CTL_Service_Configuration_Title"));
        String message = null;
        ErrorManager.Annotation[] annots = em.findAnnotations((Throwable)ex);
        if (annots != null) {
            int i = 0;
            while (i < annots.length) {
                String lm2 = annots[i].getLocalizedMessage();
                if (lm2 != null) {
                    message = lm2;
                    break;
                }
                ++i;
            }
        }
        if (message == null && (lm = ex.getLocalizedMessage()) != null && !lm.equals(ex.getMessage())) {
            message = lm;
        }
        if (message == null) {
            message = NbBundle.getMessage((Class)(class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecutionSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor), (String)"LBL_unknown_service_misconfig", (Object)current.getName());
        }
        exc.setMessage(message);
        exc.setOptions(new Object[]{configure, NotifyDescriptor.CANCEL_OPTION});
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)exc);
        if (!configure.equals(res)) {
            return null;
        }
        DialogDescriptor d = new DialogDescriptor((Object)c, ExecutionSupport.getString("MSG_ConfigureService"));
        d.setOptions(new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(d);
        dialog.show();
        if (d.getValue() == NotifyDescriptor.OK_OPTION) {
            return (ServiceType)ed.getValue();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

