/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.Image;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventObject;
import java.util.Iterator;
import java.util.TreeSet;
import org.netbeans.modules.xml.catalog.CatalogEntry;
import org.netbeans.modules.xml.catalog.CatalogEntryNode;
import org.netbeans.modules.xml.catalog.Refreshable;
import org.netbeans.modules.xml.catalog.Util;
import org.netbeans.modules.xml.catalog.settings.CatalogSettings;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListener;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

final class CatalogNode
extends BeanNode
implements Refreshable,
PropertyChangeListener,
Node.Cookie {
    static /* synthetic */ Class class$org$netbeans$modules$xml$catalog$RefreshAction;
    static /* synthetic */ Class class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$modules$xml$catalog$CatalogNode;

    public CatalogNode(CatalogReader catalog) throws IntrospectionException {
        super((Object)catalog, (Children)new CatalogChildren(catalog));
        this.getCookieSet().add((Node.Cookie)this);
        if (catalog instanceof CatalogDescriptor) {
            CatalogDescriptor desc = (CatalogDescriptor)((Object)catalog);
            this.setSynchronizeName(false);
            this.setName(desc.getDisplayName());
            this.setDisplayName(desc.getDisplayName());
            this.setShortDescription(desc.getShortDescription());
            this.fireIconChange();
            desc.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)desc));
        }
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$xml$catalog$RefreshAction == null ? (class$org$netbeans$modules$xml$catalog$RefreshAction = CatalogNode.class$("org.netbeans.modules.xml.catalog.RefreshAction")) : class$org$netbeans$modules$xml$catalog$RefreshAction)), SystemAction.get((Class)(class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction == null ? (class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction = CatalogNode.class$("org.netbeans.modules.xml.catalog.CatalogNode$UnmountAction")) : class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction)), null, SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = CatalogNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public Image getIcon(int type) {
        Image icon;
        if (this.getBean() instanceof CatalogDescriptor && (icon = ((CatalogDescriptor)this.getBean()).getIcon(type)) != null) {
            return icon;
        }
        return super.getIcon(type);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$xml$catalog$CatalogNode == null ? (class$org$netbeans$modules$xml$catalog$CatalogNode = CatalogNode.class$("org.netbeans.modules.xml.catalog.CatalogNode")) : class$org$netbeans$modules$xml$catalog$CatalogNode);
    }

    public void refresh() {
        ((CatalogReader)this.getBean()).refresh();
        ((CatalogChildren)this.getChildren()).reload();
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public void destroy() throws IOException {
        CatalogSettings mounted = CatalogSettings.getDefault();
        mounted.removeCatalog((CatalogReader)this.getBean());
        super.destroy();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug(((EventObject)e).toString());
        }
        if ("ca-name".equals(e.getPropertyName())) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(" Setting name: " + (String)e.getNewValue());
            }
            this.setName((String)e.getNewValue());
            this.setDisplayName((String)e.getNewValue());
        } else if ("ca-desc".equals(e.getPropertyName())) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(" Setting desc: " + (String)e.getNewValue());
            }
            this.setShortDescription((String)e.getNewValue());
        } else if ("ca-icon".equals(e.getPropertyName())) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(" Updating icon");
            }
            this.fireIconChange();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Reading Catalog node " + this);
        }
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Writing " + this);
        }
        out.defaultWriteObject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class UnmountAction
    extends NodeAction {
        private static final long serialVersionUID = 3556006276357785484L;
        static /* synthetic */ Class class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction;
        static /* synthetic */ Class class$org$netbeans$modules$xml$catalog$CatalogNode;

        public String getName() {
            return Util.THIS.getString("LBL_unmount");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction == null ? (class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction = UnmountAction.class$("org.netbeans.modules.xml.catalog.CatalogNode$UnmountAction")) : class$org$netbeans$modules$xml$catalog$CatalogNode$UnmountAction);
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes.length > 0;
        }

        protected void performAction(Node[] activatedNodes) {
            if (!this.enable(activatedNodes)) {
                return;
            }
            int i = 0;
            while (i < activatedNodes.length) {
                try {
                    Node me = activatedNodes[i];
                    CatalogNode self = (CatalogNode)me.getCookie(class$org$netbeans$modules$xml$catalog$CatalogNode == null ? UnmountAction.class$("org.netbeans.modules.xml.catalog.CatalogNode") : class$org$netbeans$modules$xml$catalog$CatalogNode);
                    self.destroy();
                }
                catch (IOException ex) {
                    Util.THIS.debug("Cannot unmount XML entity catalog!", ex);
                }
                ++i;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class CatalogChildren
    extends Children.Keys {
        private CatalogReader peer;
        private CatalogListener catalogListener;
        private final TreeSet keys = new TreeSet();

        public CatalogChildren(CatalogReader catalog) {
            this.peer = catalog;
        }

        public void addNotify() {
            this.catalogListener = new Lis();
            try {
                this.peer.addCatalogListener(this.catalogListener);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.reload();
        }

        public void removeNotify() {
            try {
                this.peer.removeCatalogListener(this.catalogListener);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.keys.clear();
            this.setKeys(this.keys);
        }

        public Node[] createNodes(Object key) {
            try {
                CatalogEntry catalogEntry = new CatalogEntry((String)key, this.peer);
                return new Node[]{new CatalogEntryNode(catalogEntry)};
            }
            catch (IntrospectionException ex) {
                return null;
            }
        }

        public void reload() {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(" Reloading kids of " + this.peer + "...");
            }
            this.keys.clear();
            Iterator it = this.peer.getPublicIDs();
            if (it != null) {
                while (it.hasNext()) {
                    this.keys.add(it.next());
                }
            }
            this.setKeys(this.keys);
        }

        private class Lis
        implements CatalogListener {
            private Lis() {
            }

            public void notifyNew(String publicID) {
                CatalogChildren.this.keys.add(publicID);
                CatalogChildren.super.setKeys(CatalogChildren.this.keys);
            }

            public void notifyRemoved(String publicID) {
                CatalogChildren.this.keys.remove(publicID);
                CatalogChildren.super.setKeys(CatalogChildren.this.keys);
            }

            public void notifyUpdate(String publicID) {
                CatalogChildren.super.refreshKey(publicID);
            }

            public void notifyInvalidate() {
                CatalogChildren.this.reload();
            }
        }
    }
}

