/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.impl;

import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.netbeans.modules.xml.catalog.impl.Util;
import org.netbeans.modules.xml.catalog.lib.FilterIterator;
import org.netbeans.modules.xml.catalog.lib.IteratorIterator;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.openide.util.Utilities;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractCatalog {
    private Map publicMap = new HashMap();
    private Map systemMap = new HashMap();
    private String location;
    private Vector listeners;
    private Map delegate = new HashMap();
    private Vector delegateOrder = new Vector();
    protected Vector extenders = new Vector();
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public synchronized void addCatalogListener(CatalogListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector(2);
        }
        this.listeners.add(l);
    }

    public synchronized void removeCatalogListener(CatalogListener l) {
        if (this.listeners == null) {
            return;
        }
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    protected void notifyInvalidate() {
        CatalogListener[] lis = null;
        AbstractCatalog abstractCatalog = this;
        synchronized (abstractCatalog) {
            if (this.listeners == null || this.listeners.isEmpty()) {
                return;
            }
            lis = this.listeners.toArray(new CatalogListener[0]);
        }
        int i = 0;
        while (i < lis.length) {
            lis[i].notifyInvalidate();
            ++i;
        }
    }

    public void addPublicMapping(String publicId, String systemId) {
        this.publicMap.put(publicId, systemId);
    }

    public void removePublicMapping(System publicId) {
        this.publicMap.remove(publicId);
    }

    public Iterator getPublicMappingKeys() {
        return this.publicMap.keySet().iterator();
    }

    public String getPublicMapping(String publicId) {
        return (String)this.publicMap.get(publicId);
    }

    public void addSystemMapping(String systemId1, String systemId2) {
        this.systemMap.put(systemId1, systemId2);
    }

    public void removeSystemMapping(String systemId) {
        this.systemMap.remove(systemId);
    }

    public Iterator getSystemMappingKeys() {
        return this.systemMap.keySet().iterator();
    }

    protected void clearAll() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractCatalog: clearing maps");
        }
        this.publicMap.clear();
        this.systemMap.clear();
        this.delegate.clear();
        this.delegateOrder.clear();
        this.extenders.clear();
    }

    public String getSystemMapping(String systemId) {
        return (String)this.systemMap.get(systemId);
    }

    public Iterator getPublicIDs() {
        return this.getPublicIDs("");
    }

    private Iterator getPublicIDs(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        IteratorIterator set = new IteratorIterator();
        set.add(this.getPublicMappingKeys());
        Iterator it = ((AbstractList)this.extenders).iterator();
        while (it.hasNext()) {
            set.add(((AbstractCatalog)it.next()).getPublicIDs());
        }
        Enumeration en = this.getDelegateCatalogKeys();
        while (en.hasMoreElements()) {
            String _prefix = (String)en.nextElement();
            AbstractCatalog delegee = (AbstractCatalog)this.delegate.get(_prefix);
            set.add(delegee.getPublicIDs(_prefix));
        }
        return new FilterIterator(set, new PrefixFilter(prefix));
    }

    public String getSystemID(String publicId) {
        return this.getPublicMapping(publicId);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource ret = this.resolvePublicId(publicId);
        if (ret != null) {
            return ret;
        }
        return this.resolveSystemId(systemId);
    }

    protected InputSource resolvePublicId(String publicId) {
        String value;
        if (publicId != null && (value = this.getPublicMapping(publicId)) != null) {
            InputSource input = new InputSource(value);
            input.setPublicId(publicId);
            return input;
        }
        return null;
    }

    protected InputSource resolveSystemId(String systemId) {
        if (systemId != null) {
            String value = this.getSystemMapping(systemId);
            if (value == null) {
                value = systemId;
            }
            return new InputSource(value);
        }
        return null;
    }

    public void addDelegateCatalog(String prefix, AbstractCatalog catalog) {
        Map map = this.delegate;
        synchronized (map) {
            if (!this.delegate.containsKey(prefix)) {
                int size = this.delegateOrder.size();
                boolean found = false;
                int i = 0;
                while (i < size) {
                    String element = (String)this.delegateOrder.elementAt(i);
                    if (prefix.startsWith(element) || prefix.compareTo(element) < 0) {
                        this.delegateOrder.insertElementAt(prefix, i);
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    this.delegateOrder.addElement(prefix);
                }
            }
            this.delegate.put(prefix, catalog);
        }
    }

    public void removeDelegateCatalog(String prefix) {
        Map map = this.delegate;
        synchronized (map) {
            this.delegate.remove(prefix);
            this.delegateOrder.removeElement(prefix);
        }
    }

    public Enumeration getDelegateCatalogKeys() {
        return this.delegateOrder.elements();
    }

    public AbstractCatalog getDelegateCatalog(String prefix) {
        return (AbstractCatalog)this.delegate.get(prefix);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String prop, Object val1, Object val2) {
        this.support.firePropertyChange(prop, val1, val2);
    }

    protected Image getDefaultIcon(int type) {
        try {
            BeanInfo info = Utilities.getBeanInfo(this.getClass());
            return info.getIcon(type);
        }
        catch (IntrospectionException ex) {
            return null;
        }
    }

    protected Image getDefaultErrorIcon(int type) {
        if (this.getDefaultIcon(type) == null) {
            return null;
        }
        return null;
    }

    private class PrefixFilter
    implements FilterIterator.Filter {
        private final String prefix;

        PrefixFilter(String prefix) {
            this.prefix = prefix;
        }

        public boolean accept(Object obj) {
            return ((String)obj).startsWith(this.prefix);
        }
    }
}

