/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.impl.oasis;

import java.util.Stack;
import org.netbeans.modules.xml.catalog.impl.oasis.Catalog;
import org.netbeans.modules.xml.catalog.impl.oasis.CatalogHandler;
import org.netbeans.modules.xml.catalog.impl.oasis.Util;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

class CatalogHandlerImpl
implements CatalogHandler {
    private static final String XML_BASE_ATT = "xml:base";
    private static final String CATALOG_ATT = "catalog";
    private static final String PUBLIC_ID_ATT = "publicId";
    private static final String URI_ATT = "uri";
    private static final String SYSTEM_ID_ATT = "systemId";
    private static final String PREFER_ATT = "prefer";
    private static final String NAME_ATT = "name";
    private Stack groups = new Stack();
    private Catalog target;

    public CatalogHandlerImpl(Catalog target) {
        this.target = target;
    }

    public void handle_system(AttributeList meta) throws SAXException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("handle_system: " + meta);
        }
        String systemId = meta.getValue(SYSTEM_ID_ATT);
        String uri = meta.getValue(URI_ATT);
        this.target.addSystemMapping(systemId, this.resolve(uri));
    }

    public void handle_uri(AttributeList meta) throws SAXException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("handle_uri: " + meta);
        }
        String name = meta.getValue(NAME_ATT);
        String string = meta.getValue(URI_ATT);
    }

    public void handle_public(AttributeList meta) throws SAXException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("handle_public: " + meta);
        }
        String publicId = meta.getValue(PUBLIC_ID_ATT);
        String uri = meta.getValue(URI_ATT);
        this.target.addPublicMapping(publicId, this.resolve(uri));
    }

    public void handle_rewriteSystem(AttributeList meta) throws SAXException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("handle_rewriteSystem: " + meta);
        }
    }

    public void handle_delegateSystem(AttributeList meta) throws SAXException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("handle_delegateSystem: " + meta);
        }
    }

    public void start_catalog(AttributeList meta) throws SAXException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("start_catalog: " + meta);
        }
        String base = meta.getValue(XML_BASE_ATT);
        String prefer = meta.getValue(PREFER_ATT);
        this.groups.push(new Group(base, "public".equals(prefer)));
    }

    public void end_catalog() throws SAXException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("end_catalog()");
        }
        this.groups.pop();
    }

    public void handle_rewriteURI(AttributeList meta) throws SAXException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("handle_rewriteURI: " + meta);
        }
    }

    public void handle_delegatePublic(AttributeList meta) throws SAXException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("handle_delegatePublic: " + meta);
        }
    }

    public void handle_nextCatalog(AttributeList meta) throws SAXException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("handle_nextCatalog: " + meta);
        }
    }

    public void start_group(AttributeList meta) throws SAXException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("start_group: " + meta);
        }
        String base = meta.getValue(XML_BASE_ATT);
        String prefer = meta.getValue(PREFER_ATT);
        this.groups.push(new Group(base, "public".equals(prefer)));
    }

    public void end_group() throws SAXException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("end_group()");
        }
        this.groups.pop();
    }

    public void handle_delegateURI(AttributeList meta) throws SAXException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("handle_delegateURI: " + meta);
        }
    }

    private String resolve(String uri) {
        if (uri == null) {
            return null;
        }
        if (this.currentBase() == null) {
            return uri;
        }
        return uri;
    }

    private String currentBase() {
        return ((Group)this.groups.peek()).base;
    }

    private boolean currentPreference() {
        return ((Group)this.groups.peek()).prefer;
    }

    private class Group {
        String base;
        boolean prefer;

        Group(String base, boolean prefer) {
            this.base = base;
            this.prefer = prefer;
        }
    }
}

