/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties.syntax;

import java.awt.Color;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.TokenCategory;
import org.netbeans.modules.properties.TableViewSettings;
import org.netbeans.modules.properties.syntax.PropertiesOptions;
import org.netbeans.modules.properties.syntax.PropertiesTokenContext;
import org.openide.util.SharedClassObject;

public class EditorSettingsCopy
extends TableViewSettings
implements SettingsChangeListener {
    private static EditorSettingsCopy editorSettingsCopy;
    private Color keyColor;
    private Color keyBackground;
    private Color valueColor;
    private Color valueBackground;
    private Color highlightColor;
    private Color highlightBackground;
    private Color shadowColor;
    private KeyStroke[] keyStrokesFindNext;
    private KeyStroke[] keyStrokesFindPrevious;
    private KeyStroke[] keyStrokesToggleHighlight;
    private final PropertyChangeSupport support = new PropertyChangeSupport((Object)this);
    private boolean prepared = false;
    static /* synthetic */ Class class$org$netbeans$modules$properties$syntax$PropertiesOptions;
    static /* synthetic */ Class class$org$netbeans$modules$properties$syntax$PropertiesKit;

    private EditorSettingsCopy() {
    }

    public Color getKeyColor() {
        this.prepareSettings();
        if (this.keyColor == null) {
            this.keyColor = TableViewSettings.KEY_DEFAULT_COLOR;
        }
        return this.keyColor;
    }

    public Color getKeyBackground() {
        this.prepareSettings();
        if (this.keyBackground == null) {
            this.keyBackground = TableViewSettings.KEY_DEFAULT_BACKGROUND;
        }
        return this.keyBackground;
    }

    public Color getValueColor() {
        this.prepareSettings();
        if (this.valueColor == null) {
            this.valueColor = TableViewSettings.VALUE_DEFAULT_COLOR;
        }
        return this.valueColor;
    }

    public Color getValueBackground() {
        this.prepareSettings();
        if (this.valueBackground == null) {
            this.valueBackground = TableViewSettings.VALUE_DEFAULT_BACKGROUND;
        }
        return this.valueBackground;
    }

    public Color getHighlightColor() {
        this.prepareSettings();
        if (this.highlightColor == null) {
            this.highlightColor = TableViewSettings.HIGHLIGHT_DEFAULT_COLOR;
        }
        return this.highlightColor;
    }

    public Color getHighlightBackground() {
        this.prepareSettings();
        if (this.highlightBackground == null) {
            this.highlightBackground = TableViewSettings.HIGHLIGHT_DEFAULT_BACKGROUND;
        }
        return this.highlightBackground;
    }

    public Color getShadowColor() {
        this.prepareSettings();
        if (this.shadowColor == null) {
            this.shadowColor = TableViewSettings.SHADOW_DEFAULT_COLOR;
        }
        return this.shadowColor;
    }

    public KeyStroke[] getKeyStrokesFindNext() {
        this.prepareSettings();
        if (this.keyStrokesFindNext == null || this.keyStrokesFindNext.length == 0) {
            this.keyStrokesFindNext = TableViewSettings.FIND_NEXT_DEFAULT_KEYSTROKES;
        }
        return this.keyStrokesFindNext;
    }

    public KeyStroke[] getKeyStrokesFindPrevious() {
        this.prepareSettings();
        if (this.keyStrokesFindPrevious == null || this.keyStrokesFindPrevious.length == 0) {
            this.keyStrokesFindPrevious = TableViewSettings.FIND_PREVIOUS_DEFAULT_KEYSTROKES;
        }
        return this.keyStrokesFindPrevious;
    }

    public KeyStroke[] getKeyStrokesToggleHighlight() {
        this.prepareSettings();
        if (this.keyStrokesToggleHighlight == null || this.keyStrokesToggleHighlight.length == 0) {
            this.keyStrokesToggleHighlight = TableViewSettings.TOGGLE_HIGHLIGHT_DEFAULT_KEYSTROKES;
        }
        return this.keyStrokesToggleHighlight;
    }

    public void settingsUpdated() {
        if (this.prepared) {
            this.support.firePropertyChange(new PropertyChangeEvent((Object)this, null, null, null));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public static synchronized EditorSettingsCopy getLayerInstance() {
        if (editorSettingsCopy == null) {
            editorSettingsCopy = new EditorSettingsCopy();
        }
        return editorSettingsCopy;
    }

    private void prepareSettings() {
        if (this.prepared) {
            return;
        }
        Settings.addSettingsChangeListener((SettingsChangeListener)this);
        this.updateSettings();
        this.prepared = true;
    }

    public void settingsChange(SettingsChangeEvent evt) {
        this.updateSettings();
    }

    private void updateSettings() {
        if (this.updateColors()) {
            this.updateKeyStrokes();
        }
    }

    private boolean updateColors() {
        PropertiesOptions propertiesOptions = (PropertiesOptions)SharedClassObject.findObject((Class)(class$org$netbeans$modules$properties$syntax$PropertiesOptions == null ? (class$org$netbeans$modules$properties$syntax$PropertiesOptions = EditorSettingsCopy.class$("org.netbeans.modules.properties.syntax.PropertiesOptions")) : class$org$netbeans$modules$properties$syntax$PropertiesOptions), (boolean)false);
        if (propertiesOptions == null) {
            return false;
        }
        Map map = propertiesOptions.getColoringMap();
        Coloring keyColoring = (Coloring)map.get(PropertiesTokenContext.contextPath.getFullTokenName((TokenCategory)PropertiesTokenContext.KEY));
        this.keyColor = keyColoring.getForeColor();
        this.keyBackground = keyColoring.getBackColor();
        Coloring valueColoring = (Coloring)map.get(PropertiesTokenContext.contextPath.getFullTokenName((TokenCategory)PropertiesTokenContext.VALUE));
        this.valueColor = valueColoring.getForeColor();
        this.valueBackground = valueColoring.getBackColor();
        Coloring highlightColoring = (Coloring)map.get("highlight-search");
        this.highlightColor = highlightColoring.getForeColor();
        this.highlightBackground = highlightColoring.getBackColor();
        this.shadowColor = propertiesOptions.getShadowTableCell();
        Color defaultForeground = ((Coloring)map.get("default")).getForeColor();
        Color defaultBackground = ((Coloring)map.get("default")).getBackColor();
        if (this.keyColor == null) {
            this.keyColor = defaultForeground;
        }
        if (this.keyBackground == null) {
            this.keyBackground = defaultBackground;
        }
        if (this.valueColor == null) {
            this.valueColor = defaultForeground;
        }
        if (this.valueBackground == null) {
            this.valueBackground = defaultBackground;
        }
        if (this.highlightColor == null) {
            this.highlightColor = new Color(SystemColor.textHighlightText.getRGB());
        }
        if (this.highlightBackground == null) {
            this.highlightBackground = new Color(SystemColor.textHighlight.getRGB());
        }
        if (this.shadowColor == null) {
            this.shadowColor = new Color(SystemColor.controlHighlight.getRGB());
        }
        return true;
    }

    private void updateKeyStrokes() {
        Settings.KitAndValue[] kv = Settings.getValueHierarchy((Class)(class$org$netbeans$modules$properties$syntax$PropertiesKit == null ? (class$org$netbeans$modules$properties$syntax$PropertiesKit = EditorSettingsCopy.class$("org.netbeans.modules.properties.syntax.PropertiesKit")) : class$org$netbeans$modules$properties$syntax$PropertiesKit), (String)"key-bindings");
        HashSet<KeyStroke> nextKS = new HashSet<KeyStroke>();
        HashSet<KeyStroke> prevKS = new HashSet<KeyStroke>();
        HashSet<KeyStroke> toggleKS = new HashSet<KeyStroke>();
        int i = kv.length - 1;
        while (i >= 0) {
            List keyList = (List)kv[i].value;
            JTextComponent.KeyBinding[] bindings = new JTextComponent.KeyBinding[keyList.size()];
            keyList.toArray(bindings);
            int j = 0;
            while (j < bindings.length) {
                JTextComponent.KeyBinding binding = bindings[j];
                if (binding != null) {
                    int k;
                    if (binding.actionName.equals("find-next")) {
                        if (binding instanceof MultiKeyBinding && ((MultiKeyBinding)binding).keys != null) {
                            k = 0;
                            while (k < ((MultiKeyBinding)binding).keys.length) {
                                nextKS.add(((MultiKeyBinding)binding).keys[k]);
                                ++k;
                            }
                        } else {
                            nextKS.add(binding.key);
                        }
                    }
                    if (binding.actionName.equals("find-previous")) {
                        if (binding instanceof MultiKeyBinding && ((MultiKeyBinding)binding).keys != null) {
                            k = 0;
                            while (k < ((MultiKeyBinding)binding).keys.length) {
                                prevKS.add(((MultiKeyBinding)binding).keys[k]);
                                ++k;
                            }
                        } else {
                            prevKS.add(binding.key);
                        }
                    }
                    if (binding.actionName.equals("toggle-highlight-search")) {
                        if (binding instanceof MultiKeyBinding && ((MultiKeyBinding)binding).keys != null) {
                            k = 0;
                            while (k < ((MultiKeyBinding)binding).keys.length) {
                                toggleKS.add(((MultiKeyBinding)binding).keys[k]);
                                ++k;
                            }
                        } else {
                            toggleKS.add(binding.key);
                        }
                    }
                }
                ++j;
            }
            --i;
        }
        this.keyStrokesFindNext = new KeyStroke[nextKS.size()];
        ((AbstractCollection)nextKS).toArray(this.keyStrokesFindNext);
        this.keyStrokesFindPrevious = new KeyStroke[prevKS.size()];
        ((AbstractCollection)prevKS).toArray(this.keyStrokesFindPrevious);
        this.keyStrokesToggleHighlight = new KeyStroke[toggleKS.size()];
        ((AbstractCollection)toggleKS).toArray(this.keyStrokesToggleHighlight);
        this.settingsUpdated();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

