/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.Locale;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class HelpAction
extends SystemAction {
    private static final long serialVersionUID = 4658008202517094416L;
    static /* synthetic */ Class class$org$openide$actions$StepOutAction;

    public String getName() {
        return "Help";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("OpenIDE-Transmodal-Action", Boolean.TRUE);
    }

    private static HelpCtx findHelpCtx() {
        Window w = WindowActivatedDetector.getCurrentActivatedWindow();
        Component focused = w != null ? SwingUtilities.findFocusOwner(w) : null;
        HelpCtx help = focused == null ? HelpCtx.DEFAULT_HELP : HelpCtx.findHelp((Component)focused);
        return help;
    }

    public void actionPerformed(ActionEvent ev) {
        HelpCtx help;
        final MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
        if (path != null && path.length > 0 && !(path[0].getComponent() instanceof ComboPopup)) {
            help = HelpCtx.findHelp((Component)path[path.length - 1].getComponent());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MenuElement[] newPath = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (newPath.length != path.length) {
                        return;
                    }
                    int i = 0;
                    while (i < newPath.length) {
                        if (newPath[i] != path[i]) {
                            return;
                        }
                        ++i;
                    }
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            });
        } else {
            help = HelpAction.findHelpCtx();
        }
        TopManager.getDefault().setStatusText(NbBundle.getBundle((String)"org.openide.deprecated.Bundle", (Locale)Locale.getDefault(), (ClassLoader)(class$org$openide$actions$StepOutAction == null ? (class$org$openide$actions$StepOutAction = HelpAction.class$("org.openide.actions.StepOutAction")) : class$org$openide$actions$StepOutAction).getClassLoader()).getString("CTL_OpeningHelp"));
        TopManager.getDefault().showHelp(help);
        TopManager.getDefault().setStatusText("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        WindowActivatedDetector.install();
    }

    private static class WindowActivatedDetector
    implements AWTEventListener {
        private static WeakReference currentWindowRef;
        private static boolean installed;

        private WindowActivatedDetector() {
        }

        static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new WindowActivatedDetector(), 64L);
        }

        static synchronized Window getCurrentActivatedWindow() {
            if (currentWindowRef != null) {
                return (Window)currentWindowRef.get();
            }
            return null;
        }

        private static synchronized void setCurrentActivatedWindow(Window w) {
            currentWindowRef = new WeakReference<Window>(w);
        }

        public void eventDispatched(AWTEvent ev) {
            if (ev.getID() != 205) {
                return;
            }
            WindowActivatedDetector.setCurrentActivatedWindow(((WindowEvent)ev).getWindow());
        }
    }
}

