/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class ChoicePropertyEditor
implements PropertyEditor {
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private int[] constants;
    private String[] names;
    private int index;
    private String name;

    public ChoicePropertyEditor(int[] constants, String[] names) {
        this.constants = constants;
        this.names = names;
    }

    public Object getValue() {
        return new Integer(this.constants[this.index]);
    }

    public void setValue(Object object) {
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        int ii = (Integer)object;
        int k = this.constants.length;
        int i = 0;
        while (i < k) {
            if (this.constants[i] == ii) break;
            ++i;
        }
        if (i == k) {
            throw new IllegalArgumentException();
        }
        this.index = i;
        this.name = this.names[i];
        this.support.firePropertyChange(null, null, null);
    }

    public String getAsText() {
        return this.name;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int k = this.names.length;
        int i = 0;
        while (i < k) {
            if (this.names[i].equals(string)) break;
            ++i;
        }
        if (i == k) {
            throw new IllegalArgumentException();
        }
        this.index = i;
        this.name = this.names[i];
        this.support.firePropertyChange(null, null, null);
    }

    public String getJavaInitializationString() {
        return "" + this.index;
    }

    public String[] getTags() {
        return this.names;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

