/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.compiler.ExternalCompiler;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.propertysheet.editors.ExternalCompiler;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ErrorExpressionPanel
extends JPanel
implements EnhancedCustomPropertyEditor {
    private ExternalCompiler.ErrorExpressionEditor editor;
    static final long serialVersionUID = -2763818133650482979L;
    private JPanel jPanel1;
    private JLabel presetNameLabel;
    private JLabel errorDescriptionLabel;
    private JLabel filePositionLabel;
    private JLabel linePositionLabel;
    private JLabel columnPositionLabel;
    private JLabel descriptionPositionLabel;
    private JLabel errorDescriptionsLabel;
    private JTextField presetNameField;
    private JTextField errorDescriptionField;
    private JTextField filePositionField;
    private JTextField linePositionField;
    private JTextField columnPositionField;
    private JTextField descriptionPositionField;
    private JScrollPane presetsScroll;
    private JList errorDescriptions;
    private JPanel jPanel2;
    private JButton addButton;
    private JButton setButton;
    private JButton removeButton;
    private ExternalCompiler.ErrorExpression descriptions;
    private boolean internalListChange = false;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel;

    public ErrorExpressionPanel(ExternalCompiler.ErrorExpressionEditor ed) {
        this.editor = ed;
        this.descriptions = (ExternalCompiler.ErrorExpression)ed.getValue();
        this.initComponents();
        this.addButton.setText(ErrorExpressionPanel.getString("CTL_AddError"));
        this.addButton.setToolTipText(ErrorExpressionPanel.getString("CTL_AddError_tip"));
        this.removeButton.setText(ErrorExpressionPanel.getString("CTL_RemoveError"));
        this.removeButton.setToolTipText(ErrorExpressionPanel.getString("CTL_RemoveError_tip"));
        this.setButton.setText(ErrorExpressionPanel.getString("CTL_SetError"));
        this.setButton.setToolTipText(ErrorExpressionPanel.getString("CTL_SetError_tip"));
        this.presetNameLabel.setText(ErrorExpressionPanel.getString("CTL_Preset_label"));
        this.errorDescriptionLabel.setText(ErrorExpressionPanel.getString("CTL_Error_label"));
        this.filePositionLabel.setText(ErrorExpressionPanel.getString("CTL_File_label"));
        this.linePositionLabel.setText(ErrorExpressionPanel.getString("CTL_Line_label"));
        this.columnPositionLabel.setText(ErrorExpressionPanel.getString("CTL_Column_label"));
        this.descriptionPositionLabel.setText(ErrorExpressionPanel.getString("CTL_Description_label"));
        this.errorDescriptionsLabel.setText(ErrorExpressionPanel.getString("CTL_Descriptions"));
        this.addButton.setMnemonic(ErrorExpressionPanel.getString("CTL_AddError_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(ErrorExpressionPanel.getString("CTL_RemoveError_Mnemonic").charAt(0));
        this.setButton.setMnemonic(ErrorExpressionPanel.getString("CTL_SetError_Mnemonic").charAt(0));
        this.presetNameLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_Preset_label_Mnemonic").charAt(0));
        this.errorDescriptionLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_Error_label_Mnemonic").charAt(0));
        this.filePositionLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_File_label_Mnemonic").charAt(0));
        this.linePositionLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_Line_label_Mnemonic").charAt(0));
        this.columnPositionLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_Column_label_Mnemonic").charAt(0));
        this.descriptionPositionLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_Description_label_Mnemonic").charAt(0));
        this.errorDescriptionsLabel.setDisplayedMnemonic(ErrorExpressionPanel.getString("CTL_Descriptions_Mnemonic").charAt(0));
        ListSelectionListener l = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                if (ErrorExpressionPanel.this.internalListChange) {
                    return;
                }
                int sel = ErrorExpressionPanel.this.errorDescriptions.getSelectedIndex();
                if (sel < 0) {
                    return;
                }
                ErrorExpressionPanel.this.descriptions = ErrorExpressionPanel.this.editor.getExpressions()[sel];
                ErrorExpressionPanel.this.updateFields();
                ErrorExpressionPanel.this.updateButtons();
            }
        };
        this.errorDescriptions.addListSelectionListener(l);
        this.updateList();
        this.updateFields();
        this.updateButtons();
        HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel == null ? (class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel = ErrorExpressionPanel.class$("org.openide.explorer.propertysheet.editors.ErrorExpressionPanel")) : class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel).getName());
        this.presetNameField.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_PresetField"));
        this.errorDescriptionField.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_ErrorField"));
        this.filePositionField.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_FileField"));
        this.linePositionField.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_LineField"));
        this.columnPositionField.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_ColumnField"));
        this.descriptionPositionField.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_DescriptionField"));
        this.errorDescriptions.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_DescriptionsList"));
        this.getAccessibleContext().setAccessibleDescription(ErrorExpressionPanel.getString("ACSD_ErrorExpressionPanel"));
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.descriptions;
    }

    private void updateList() {
        ExternalCompiler.ErrorExpression[] exprs = this.editor.getExpressions();
        ExternalCompiler.ErrorExpression sel = this.descriptions;
        String[] strings = new String[exprs.length];
        int selIndex = -1;
        int i = 0;
        while (i < exprs.length) {
            strings[i] = exprs[i].getName();
            if (sel != null && exprs[i].getName().equals(sel.getName())) {
                selIndex = i;
            }
            ++i;
        }
        this.internalListChange = true;
        this.errorDescriptions.setListData(strings);
        this.internalListChange = false;
        if (selIndex != -1) {
            this.errorDescriptions.setSelectedIndex(selIndex);
        }
    }

    private void updateFields() {
        ExternalCompiler.ErrorExpression current = this.descriptions;
        if (current == null) {
            return;
        }
        this.presetNameField.setText(current.getName());
        this.errorDescriptionField.setText(current.getErrorExpression());
        this.filePositionField.setText(String.valueOf(current.getFilePos()));
        this.linePositionField.setText(String.valueOf(current.getLinePos()));
        this.columnPositionField.setText(String.valueOf(current.getColumnPos()));
        this.descriptionPositionField.setText(String.valueOf(current.getDescriptionPos()));
    }

    private void updateButtons() {
        boolean enabled;
        boolean bl = enabled = this.errorDescriptions.getSelectedIndex() != -1;
        if (enabled) {
            enabled = !this.isReadOnly(this.descriptions);
        }
        this.removeButton.setEnabled(enabled);
        this.setButton.setEnabled(enabled);
        this.addButton.setEnabled(!"".equals(this.presetNameField.getText()));
    }

    private boolean isReadOnly(ExternalCompiler.ErrorExpression sel) {
        if (sel.equals((Object)ExternalCompiler.JAVAC)) {
            return true;
        }
        if (sel.equals((Object)ExternalCompiler.JVC)) {
            return true;
        }
        return sel.equals((Object)ExternalCompiler.JIKES);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.presetNameLabel = new JLabel();
        this.errorDescriptionLabel = new JLabel();
        this.filePositionLabel = new JLabel();
        this.linePositionLabel = new JLabel();
        this.columnPositionLabel = new JLabel();
        this.descriptionPositionLabel = new JLabel();
        this.errorDescriptionsLabel = new JLabel();
        this.presetNameField = new JTextField();
        this.errorDescriptionField = new JTextField();
        this.filePositionField = new JTextField();
        this.linePositionField = new JTextField();
        this.columnPositionField = new JTextField();
        this.descriptionPositionField = new JTextField();
        this.presetsScroll = new JScrollPane();
        this.errorDescriptions = new JList();
        this.jPanel2 = new JPanel();
        this.addButton = new JButton();
        this.setButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new BorderLayout(11, 0));
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.jPanel1.setLayout(new GridBagLayout());
        this.presetNameLabel.setText("jLabel1");
        this.presetNameLabel.setLabelFor(this.presetNameField);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.presetNameLabel, gridBagConstraints2);
        this.errorDescriptionLabel.setText("jLabel2");
        this.errorDescriptionLabel.setLabelFor(this.errorDescriptionField);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.errorDescriptionLabel, gridBagConstraints2);
        this.filePositionLabel.setText("jLabel3");
        this.filePositionLabel.setLabelFor(this.filePositionField);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.filePositionLabel, gridBagConstraints2);
        this.linePositionLabel.setText("jLabel4");
        this.linePositionLabel.setLabelFor(this.linePositionField);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.linePositionLabel, gridBagConstraints2);
        this.columnPositionLabel.setText("jLabel5");
        this.columnPositionLabel.setLabelFor(this.columnPositionField);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.columnPositionLabel, gridBagConstraints2);
        this.descriptionPositionLabel.setText("jLabel6");
        this.descriptionPositionLabel.setLabelFor(this.descriptionPositionField);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.descriptionPositionLabel, gridBagConstraints2);
        this.errorDescriptionsLabel.setText("jLabel7");
        this.errorDescriptionsLabel.setLabelFor(this.errorDescriptions);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.errorDescriptionsLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.presetNameField, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.errorDescriptionField, gridBagConstraints2);
        this.filePositionField.setHorizontalAlignment(4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.filePositionField, gridBagConstraints2);
        this.linePositionField.setHorizontalAlignment(4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.linePositionField, gridBagConstraints2);
        this.columnPositionField.setHorizontalAlignment(4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.columnPositionField, gridBagConstraints2);
        this.descriptionPositionField.setHorizontalAlignment(4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.descriptionPositionField, gridBagConstraints2);
        this.presetsScroll.setPreferredSize(new Dimension(300, 200));
        this.errorDescriptions.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ErrorExpressionPanel.this.errorDescriptionsMouseClicked(evt);
            }
        });
        this.presetsScroll.setViewportView(this.errorDescriptions);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 7;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.jPanel1.add((Component)this.presetsScroll, gridBagConstraints2);
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new GridBagLayout());
        this.addButton.setText("jButton1");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ErrorExpressionPanel.this.addButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints3.anchor = 11;
        this.jPanel2.add((Component)this.addButton, gridBagConstraints3);
        this.setButton.setText("jButton2");
        this.setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ErrorExpressionPanel.this.setButtonActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints3.anchor = 11;
        this.jPanel2.add((Component)this.setButton, gridBagConstraints3);
        this.removeButton.setText("jButton3");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ErrorExpressionPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 11;
        gridBagConstraints3.weighty = 1.0;
        this.jPanel2.add((Component)this.removeButton, gridBagConstraints3);
        this.add((Component)this.jPanel2, "East");
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        ExternalCompiler.ErrorExpressionEditor errorExpressionEditor = this.editor;
        synchronized (errorExpressionEditor) {
            Collection exprs = this.editor.getExpressionsVector();
            int pos = this.errorDescriptions.getSelectedIndex();
            exprs.remove(this.descriptions);
            if (pos >= exprs.size()) {
                pos = exprs.size() - 1;
            }
            this.descriptions = pos >= 0 ? this.editor.getExpressions()[pos] : null;
            this.updateList();
        }
    }

    private void setButtonActionPerformed(ActionEvent evt) {
        if ("".equals(this.presetNameField.getText())) {
            return;
        }
        ExternalCompiler.ErrorExpression expr = this.descriptions;
        int fPos = 0;
        int lPos = 0;
        int cPos = 0;
        int dPos = 0;
        try {
            fPos = Integer.parseInt(this.filePositionField.getText());
            lPos = Integer.parseInt(this.linePositionField.getText());
            cPos = Integer.parseInt(this.columnPositionField.getText());
            dPos = Integer.parseInt(this.descriptionPositionField.getText());
        }
        catch (NumberFormatException ex) {
            return;
        }
        expr.setName(this.presetNameField.getText());
        expr.setErrorExpression(this.errorDescriptionField.getText());
        expr.setFilePos(fPos);
        expr.setLinePos(lPos);
        expr.setColumnPos(cPos);
        expr.setDescriptionPos(dPos);
        this.updateList();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        if ("".equals(this.presetNameField.getText())) {
            return;
        }
        ExternalCompiler.ErrorExpression[] exprsAr = this.editor.getExpressions();
        int i = 0;
        while (i < exprsAr.length) {
            if (exprsAr[i].getName().equals(this.presetNameField.getText())) {
                return;
            }
            ++i;
        }
        ExternalCompiler.ErrorExpression expr = null;
        try {
            expr = new ExternalCompiler.ErrorExpression(this.presetNameField.getText(), this.errorDescriptionField.getText(), Integer.parseInt(this.filePositionField.getText()), Integer.parseInt(this.linePositionField.getText()), Integer.parseInt(this.columnPositionField.getText()), Integer.parseInt(this.descriptionPositionField.getText()));
        }
        catch (NumberFormatException ex) {
            return;
        }
        ExternalCompiler.ErrorExpressionEditor errorExpressionEditor = this.editor;
        synchronized (errorExpressionEditor) {
            Collection exprs = this.editor.getExpressionsVector();
            int pos = this.errorDescriptions.getSelectedIndex();
            exprs.add(expr);
            this.descriptions = expr;
            this.updateList();
        }
    }

    private void errorDescriptionsMouseClicked(MouseEvent evt) {
    }

    private static String getString(String res) {
        return NbBundle.getBundle((Class)(class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel == null ? (class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel = ErrorExpressionPanel.class$("org.openide.explorer.propertysheet.editors.ErrorExpressionPanel")) : class$org$openide$explorer$propertysheet$editors$ErrorExpressionPanel)).getString(res);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

