/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditorSupport;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import org.openide.explorer.propertysheet.editors.NodePropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class FileEditor
extends PropertyEditorSupport
implements NodePropertyEditor {
    private int mode = 2;
    private Node[] nodes = null;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$FileEditor;

    public FileEditor() {
    }

    public FileEditor(int mode) {
        this.mode = mode;
    }

    public void attach(Node[] nodes) {
        this.nodes = nodes;
    }

    public void setAsText(String s) {
        this.setValue(new File(s));
    }

    public String getAsText() {
        Object obj = this.getValue();
        if (obj instanceof File) {
            return obj.toString();
        }
        return null;
    }

    public boolean supportsCustomEditor() {
        if (this.nodes != null) {
            int i = 0;
            while (i < this.nodes.length) {
                Node.PropertySet[] propsets = this.nodes[i].getPropertySets();
                int j = 0;
                while (j < propsets.length) {
                    Node.Property[] props = propsets[j].getProperties();
                    int k = 0;
                    while (k < props.length) {
                        Node.Property prop;
                        if (!(!(class$java$io$File == null ? FileEditor.class$("java.io.File") : class$java$io$File).equals((prop = props[k]).getValueType()) || prop.canRead() && prop.canWrite())) {
                            return false;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return true;
    }

    public Component getCustomEditor() {
        final JFileChooser chooser = this.createFileChooser();
        final JDialog dialog = new JDialog(WindowManager.getDefault().getMainWindow(), chooser.getDialogTitle(), true);
        dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((Component)dialog).setVisible(false);
                dialog.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 2);
        dialog.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 27) {
                    ((Component)dialog).setVisible(false);
                    dialog.dispose();
                }
            }
        });
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)chooser, "Center");
        chooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if ("ApproveSelection".equals(evt.getActionCommand())) {
                    File f = chooser.getSelectedFile();
                    FileEditor.this.setValue(f);
                    ((Component)dialog).setVisible(false);
                    dialog.dispose();
                } else if ("CancelSelection".equals(evt.getActionCommand())) {
                    ((Component)dialog).setVisible(false);
                    dialog.dispose();
                }
            }
        });
        HelpCtx.setHelpIDString((JComponent)dialog.getRootPane(), (String)this.getHelpCtx().getHelpID());
        return dialog;
    }

    public String getJavaInitializationString() {
        File value = (File)this.getValue();
        if (value == null) {
            return "null";
        }
        return "new java.io.File (\"" + Utilities.replaceString((String)value.getAbsolutePath(), (String)"\\", (String)"\\\\") + "\")";
    }

    protected JFileChooser createFileChooser() {
        File originalFile = (File)this.getValue();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(this.mode);
        if (originalFile != null && originalFile.getParent() != null) {
            chooser.setCurrentDirectory(new File(originalFile.getParent()));
        }
        chooser.setSelectedFile(originalFile);
        chooser.setApproveButtonText(FileEditor.getString("CTL_ApproveSelect"));
        chooser.setApproveButtonToolTipText(FileEditor.getString("CTL_ApproveSelectToolTip"));
        switch (this.mode) {
            case 2: {
                chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFilesAndDirs"));
                break;
            }
            case 0: {
                chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleFiles"));
                break;
            }
            case 1: {
                chooser.setDialogTitle(FileEditor.getString("CTL_DialogTitleDirs"));
            }
        }
        return chooser;
    }

    protected HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$explorer$propertysheet$editors$FileEditor == null ? (class$org$openide$explorer$propertysheet$editors$FileEditor = FileEditor.class$("org.openide.explorer.propertysheet.editors.FileEditor")) : class$org$openide$explorer$propertysheet$editors$FileEditor);
    }

    private static String getString(String key) {
        return NbBundle.getBundle((Class)(class$org$openide$explorer$propertysheet$editors$FileEditor == null ? (class$org$openide$explorer$propertysheet$editors$FileEditor = FileEditor.class$("org.openide.explorer.propertysheet.editors.FileEditor")) : class$org$openide$explorer$propertysheet$editors$FileEditor)).getString(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

