/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.Places;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.propertysheet.editors.IconEditor;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class IconEditor
extends PropertyEditorSupport
implements PropertyEditor,
XMLPropertyEditor,
ExPropertyEditor {
    public static final int TYPE_URL = 1;
    public static final int TYPE_FILE = 2;
    public static final int TYPE_CLASSPATH = 3;
    static final String URL_PREFIX = "URL";
    static final String FILE_PREFIX = "File";
    static final String CLASSPATH_PREFIX = "Classpath";
    private Icon icon;
    private PropertyEnv propertyEnv;
    public static final String XML_IMAGE = "Image";
    public static final String ATTR_TYPE = "iconType";
    public static final String ATTR_NAME = "name";
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$IconEditor;

    private static String getString(String key) {
        return NbBundle.getBundle((Class)(class$org$openide$explorer$propertysheet$editors$IconEditor == null ? (class$org$openide$explorer$propertysheet$editors$IconEditor = IconEditor.class$("org.openide.explorer.propertysheet.editors.IconEditor")) : class$org$openide$explorer$propertysheet$editors$IconEditor)).getString(key);
    }

    public static boolean isImage(String s) {
        return (s = s.toLowerCase()).endsWith(".jpg") || s.endsWith(".gif") || s.endsWith(".jpeg") || s.endsWith(".jpe") || s.equals("jpg") || s.equals("gif") || s.equals("jpeg") || s.equals("jpe");
    }

    static String convert(String s) {
        StringTokenizer st = new StringTokenizer(s, "\\");
        StringBuffer sb = new StringBuffer();
        if (st.hasMoreElements()) {
            sb.append(st.nextElement());
            while (st.hasMoreElements()) {
                sb.append("\\\\").append(st.nextElement());
            }
        }
        return new String(sb);
    }

    public int getSourceType() {
        if (this.getValue() instanceof NbImageIcon) {
            return ((NbImageIcon)this.getValue()).type;
        }
        return 2;
    }

    public String getSourceName() {
        if (this.getValue() instanceof NbImageIcon) {
            return ((NbImageIcon)this.getValue()).name;
        }
        return null;
    }

    public Object getValue() {
        return super.getValue();
    }

    public void setValue(Object object) {
        if (this.propertyEnv != null) {
            if (object == null || object instanceof NbImageIcon && ((NbImageIcon)object).stateValid) {
                this.propertyEnv.setState(PropertyEnv.STATE_VALID);
            } else {
                this.propertyEnv.setState(PropertyEnv.STATE_INVALID);
            }
        }
        this.icon = (Icon)object;
        super.setValue(this.icon);
    }

    public String getAsText() {
        Object val = this.getValue();
        if (val == null) {
            return "null";
        }
        if (val instanceof NbImageIcon) {
            NbImageIcon ii = (NbImageIcon)val;
            switch (ii.type) {
                case 1: {
                    return "URL: " + ii.name;
                }
                case 2: {
                    return "File: " + ii.name;
                }
                case 3: {
                    return "Classpath: " + ii.name;
                }
            }
        }
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(this.iconFromText(string));
    }

    private static URL findResource(String resource) {
        FileObject fo = Repository.getDefault().findResource(resource);
        if (fo == null) {
            return null;
        }
        try {
            return fo.getURL();
        }
        catch (FileStateInvalidException fsie) {
            ErrorManager.getDefault().notify((Throwable)fsie);
            return null;
        }
    }

    private NbImageIcon iconFromText(String string) throws IllegalArgumentException {
        NbImageIcon ii;
        try {
            if (string.startsWith(FILE_PREFIX)) {
                String s = string.substring(FILE_PREFIX.length() + 1).trim();
                ii = new NbImageIcon(s);
                ii.type = 2;
                ii.name = s;
            } else if (string.startsWith(CLASSPATH_PREFIX)) {
                String s = string.substring(CLASSPATH_PREFIX.length() + 1).trim();
                if (s == null || "".equals(s) || "/".equals(s) || "///".equals(s) || s.endsWith("#")) {
                    return null;
                }
                URL u = IconEditor.findResource(s);
                ii = u == null ? new NbImageIcon() : new NbImageIcon(u);
                ii.type = 3;
                ii.name = s;
            } else if (string.startsWith(URL_PREFIX)) {
                String s = string.substring(URL_PREFIX.length() + 1).trim();
                URL url = new URL(s);
                ii = new NbImageIcon(url);
                ii.type = 1;
                ii.name = s;
            } else if (string.equals("null")) {
                ii = null;
            } else {
                ii = new NbImageIcon(string.trim());
                ii.type = 2;
                ii.name = string;
            }
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException();
            ErrorManager.getDefault().annotate((Throwable)iae, (Throwable)e);
            throw iae;
        }
        return ii;
    }

    public String getJavaInitializationString() {
        if (this.getValue() instanceof NbImageIcon) {
            NbImageIcon ii = (NbImageIcon)this.getValue();
            switch (ii.type) {
                case 1: {
                    return "new javax.swing.JLabel() {\n  public javax.swing.Icon getIcon() {\n    try {\n      return new javax.swing.ImageIcon(\n        new java.net.URL(\"" + IconEditor.convert(ii.name) + "\")\n" + "      );\n" + "    } catch (java.net.MalformedURLException e) {\n" + "    }\n" + "    return null;\n" + "  }\n" + "}.getIcon()";
                }
                case 2: {
                    return "new javax.swing.ImageIcon(\"" + IconEditor.convert(ii.name) + "\")";
                }
                case 3: {
                    return "new javax.swing.ImageIcon(getClass().getResource(\"" + IconEditor.convert(ii.name) + "\"))";
                }
            }
        }
        return "null";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new IconPanel();
    }

    public void readFromXML(org.w3c.dom.Node element) throws IOException {
        if (!XML_IMAGE.equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        try {
            int type = Integer.parseInt(attributes.getNamedItem(ATTR_TYPE).getNodeValue());
            String name = attributes.getNamedItem(ATTR_NAME).getNodeValue();
            switch (type) {
                case 0: {
                    this.setValue(null);
                    break;
                }
                case 1: {
                    this.setAsText("URL: " + name);
                    break;
                }
                case 2: {
                    this.setAsText("File: " + name);
                    break;
                }
                case 3: {
                    this.setAsText("Classpath: " + name);
                }
            }
        }
        catch (NullPointerException e) {
            IOException ioe = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)e);
            throw ioe;
        }
    }

    public org.w3c.dom.Node storeToXML(Document doc) {
        Element el = doc.createElement(XML_IMAGE);
        if (this.getValue() instanceof NbImageIcon) {
            NbImageIcon ii = (NbImageIcon)this.getValue();
            el.setAttribute(ATTR_TYPE, Integer.toString(ii.type));
            el.setAttribute(ATTR_NAME, ii.name);
        } else {
            el.setAttribute(ATTR_TYPE, "0");
            el.setAttribute(ATTR_NAME, "null");
        }
        return el;
    }

    public void attachEnv(PropertyEnv env) {
        this.propertyEnv = env;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class IconPanel
    extends JPanel
    implements EnhancedCustomPropertyEditor {
        static final long serialVersionUID = -6904264999063788703L;
        private JPanel jPanel1;
        private JLabel jLabel1;
        private JRadioButton rbUrl;
        private JRadioButton rbFile;
        private JRadioButton rbClasspath;
        private JRadioButton rbNoPicture;
        private JLabel jLabel2;
        private JLabel jLabel3;
        private JLabel jLabel4;
        private JLabel jLabel5;
        private JPanel jPanel2;
        private JLabel lName;
        private JTextField tfName;
        private JButton bSelect;
        private JPanel jPanel3;
        private JLabel jLabel7;
        private JScrollPane spImage;
        private JLabel iconLabel = new JLabel(this){
            private final /* synthetic */ IconPanel this$1;
            {
                this.this$1 = this$1;
            }

            public boolean isFocusTraversable() {
                return true;
            }
        };
        private Icon localIcon;

        public IconPanel() {
            this.iconLabel.setPreferredSize(new Dimension(32, 32));
            this.iconLabel.setHorizontalAlignment(0);
            this.iconLabel.setVerticalAlignment(0);
            this.initComponents();
            this.spImage.setViewportView(this.iconLabel);
            this.jLabel1.setText(IconEditor.getString("CTL_ImageSourceType"));
            this.rbUrl.setText(IconEditor.getString("CTL_URL"));
            this.rbFile.setText(IconEditor.getString("CTL_File"));
            this.rbClasspath.setText(IconEditor.getString("CTL_Classpath"));
            this.rbNoPicture.setText(IconEditor.getString("CTL_NoPicture"));
            this.jLabel2.setText(IconEditor.getString("CTL_URLExample"));
            this.jLabel3.setText(IconEditor.getString("CTL_FileExample"));
            this.jLabel4.setText(IconEditor.getString("CTL_ClasspathExample"));
            this.jLabel5.setText(IconEditor.getString("CTL_Null"));
            this.lName.setText(IconEditor.getString("CTL_ImageSourceName"));
            this.lName.setDisplayedMnemonic(IconEditor.getString("CTL_ImageSourceName_mnemonic").charAt(0));
            this.lName.setLabelFor(this.tfName);
            this.jLabel7.setText(IconEditor.getString("CTL_Preview"));
            this.jLabel7.setDisplayedMnemonic(IconEditor.getString("CTL_Preview_mnemonic").charAt(0));
            this.bSelect.setText(IconEditor.getString("CTL_ButtonSelect"));
            this.bSelect.setMnemonic(IconEditor.getString("CTL_ButtonSelect_mnemonic").charAt(0));
            this.jLabel1.setLabelFor(this.jPanel1);
            this.jLabel2.setLabelFor(this.rbUrl);
            this.jLabel3.setLabelFor(this.rbFile);
            this.jLabel4.setLabelFor(this.rbClasspath);
            this.jLabel5.setLabelFor(this.rbNoPicture);
            this.jLabel7.setLabelFor(this.iconLabel);
            this.rbUrl.setMnemonic(IconEditor.getString("CTL_URL_mnemonic").charAt(0));
            this.rbFile.setMnemonic(IconEditor.getString("CTL_File_mnemonic").charAt(0));
            this.rbClasspath.setMnemonic(IconEditor.getString("CTL_Classpath_mnemonic").charAt(0));
            this.rbNoPicture.setMnemonic(IconEditor.getString("CTL_NoPicture_mnemonic").charAt(0));
            this.tfName.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_CTL_ImageSourceName"));
            this.bSelect.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_CTL_ButtonSelect"));
            this.iconLabel.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_CTL_Preview"));
            this.rbUrl.getAccessibleContext().setAccessibleDescription(this.jLabel2.getText());
            this.rbFile.getAccessibleContext().setAccessibleDescription(this.jLabel3.getText());
            this.rbClasspath.getAccessibleContext().setAccessibleDescription(this.jLabel4.getText());
            this.rbNoPicture.getAccessibleContext().setAccessibleDescription(this.jLabel5.getText());
            this.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_IconCustomEditor"));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbUrl);
            bg.add(this.rbFile);
            bg.add(this.rbClasspath);
            bg.add(this.rbNoPicture);
            this.localIcon = (Icon)IconEditor.this.getValue();
            if (IconEditor.this.propertyEnv != null) {
                IconEditor.this.propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            }
            if (this.localIcon == null || !(this.localIcon instanceof NbImageIcon)) {
                this.rbNoPicture.setSelected(true);
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(false);
                return;
            }
            switch (((NbImageIcon)this.localIcon).type) {
                case 1: {
                    this.rbUrl.setSelected(true);
                    this.bSelect.setEnabled(false);
                    break;
                }
                case 2: {
                    this.rbFile.setSelected(true);
                    this.bSelect.setEnabled(true);
                    break;
                }
                case 3: {
                    this.rbClasspath.setSelected(true);
                    this.bSelect.setEnabled(true);
                }
            }
            this.tfName.setText(((NbImageIcon)this.localIcon).name);
            HelpCtx.setHelpIDString((JComponent)this, (String)"gui.csh.icon");
            this.updateIcon();
        }

        private void initComponents() {
            this.jPanel1 = new JPanel();
            this.jLabel1 = new JLabel();
            this.rbUrl = new JRadioButton();
            this.rbFile = new JRadioButton();
            this.rbClasspath = new JRadioButton();
            this.rbNoPicture = new JRadioButton();
            this.jLabel2 = new JLabel();
            this.jLabel3 = new JLabel();
            this.jLabel4 = new JLabel();
            this.jLabel5 = new JLabel();
            this.jPanel2 = new JPanel();
            this.lName = new JLabel();
            this.tfName = new JTextField();
            this.bSelect = new JButton();
            this.jPanel3 = new JPanel();
            this.jLabel7 = new JLabel();
            this.spImage = new JScrollPane();
            this.setLayout(new GridBagLayout());
            this.jPanel1.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.jLabel1, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.insets = new Insets(12, 24, 0, 0);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.rbUrl, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.rbFile, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 3;
            gridBagConstraints1.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.rbClasspath, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 4;
            gridBagConstraints1.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.rbNoPicture, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.insets = new Insets(12, 5, 0, 12);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.jLabel2, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.insets = new Insets(5, 5, 0, 12);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.jLabel3, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 3;
            gridBagConstraints1.insets = new Insets(5, 5, 0, 12);
            gridBagConstraints1.anchor = 17;
            this.jPanel1.add((Component)this.jLabel4, gridBagConstraints1);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 4;
            gridBagConstraints1.insets = new Insets(5, 5, 0, 12);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            this.jPanel1.add((Component)this.jLabel5, gridBagConstraints1);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            this.add((Component)this.jPanel1, gridBagConstraints2);
            this.jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints3.anchor = 17;
            this.jPanel2.add((Component)this.lName, gridBagConstraints3);
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(12, 5, 0, 0);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.weightx = 1.0;
            this.jPanel2.add((Component)this.tfName, gridBagConstraints3);
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(12, 5, 0, 17);
            gridBagConstraints3.anchor = 17;
            this.jPanel2.add((Component)this.bSelect, gridBagConstraints3);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.fill = 1;
            this.add((Component)this.jPanel2, gridBagConstraints2);
            this.jPanel3.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints4.anchor = 17;
            this.jPanel3.add((Component)this.jLabel7, gridBagConstraints4);
            gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.insets = new Insets(5, 12, 0, 12);
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            this.jPanel3.add((Component)this.spImage, gridBagConstraints4);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            this.add((Component)this.jPanel3, gridBagConstraints2);
            this.tfName.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.setValue();
                }
            });
            this.rbUrl.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    IconPanel.access$300(this.this$1).setEnabled(false);
                    IconPanel.access$400(this.this$1).setEnabled(true);
                    this.this$1.setValue();
                }
            });
            this.rbFile.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    IconPanel.access$300(this.this$1).setEnabled(true);
                    IconPanel.access$400(this.this$1).setEnabled(true);
                    this.this$1.setValue();
                    this.this$1.updateIcon();
                }
            });
            this.rbClasspath.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    IconPanel.access$300(this.this$1).setEnabled(true);
                    IconPanel.access$400(this.this$1).setEnabled(true);
                    this.this$1.setValue();
                }
            });
            this.rbNoPicture.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    IconPanel.access$300(this.this$1).setEnabled(false);
                    IconPanel.access$400(this.this$1).setEnabled(false);
                    IconPanel.access$502(this.this$1, null);
                    this.this$1.updateIcon();
                }
            });
            this.bSelect.addActionListener(new ActionListener(this){
                static /* synthetic */ Class class$org$openide$Places;
                static /* synthetic */ Class class$org$openide$loaders$DataObject;
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    if (IconPanel.access$600(this.this$1).isSelected()) {
                        File f = IconPanel.access$700(this.this$1);
                        if (f == null) {
                            return;
                        }
                        IconPanel.access$400(this.this$1).setText(f.getAbsolutePath());
                        this.this$1.setValue();
                    } else if (IconPanel.access$800(this.this$1).isSelected()) {
                        String name;
                        Places places = (Places)Lookup.getDefault().lookup(class$org$openide$Places == null ? (class$org$openide$Places = 7.class$("org.openide.Places")) : class$org$openide$Places);
                        Node ds = places.nodes().repository(new DataFilter(this){
                            private final /* synthetic */ 7 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public boolean acceptDataObject(DataObject obj) {
                                if (obj instanceof DataFolder) {
                                    return !obj.getPrimaryFile().isReadOnly() || obj.getPrimaryFile().getParent() != null;
                                }
                                return IconEditor.isImage(obj.getPrimaryFile().getExt());
                            }
                        });
                        try {
                            DataObject d = (DataObject)NodeOperation.getDefault().select(IconEditor.access$100("CTL_OpenDialogName"), IconEditor.access$100("CTL_FileSystemName"), ((Places)Lookup.getDefault().lookup(class$org$openide$Places == null ? (class$org$openide$Places = 7.class$("org.openide.Places")) : class$org$openide$Places)).nodes().repository(), new NodeAcceptor(this){
                                static /* synthetic */ Class class$org$openide$loaders$DataFolder;
                                private final /* synthetic */ 7 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                public boolean acceptNodes(Node[] nodes) {
                                    if (nodes == null || nodes.length != 1) {
                                        return false;
                                    }
                                    return nodes[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = 9.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) == null;
                                }

                                static /* synthetic */ Class class$(String x0) {
                                    try {
                                        return Class.forName(x0);
                                    }
                                    catch (ClassNotFoundException x1) {
                                        throw new NoClassDefFoundError(x1.getMessage());
                                    }
                                }
                            }, null)[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = 7.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                            name = d.getPrimaryFile().getPath();
                        }
                        catch (UserCancelException ex) {
                            return;
                        }
                        IconPanel.access$400(this.this$1).setText("/" + name);
                        this.this$1.setValue();
                    }
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
        }

        private File selectFile() {
            File[] ff = new File[1];
            FeatureDescriptor fd = new FeatureDescriptor();
            ExPropertyModel epm = new ExPropertyModel(this, ff, fd){
                static /* synthetic */ Class class$java$io$File;
                private final /* synthetic */ File[] val$ff;
                private final /* synthetic */ FeatureDescriptor val$fd;
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$ff = val$ff;
                    this.val$fd = val$fd;
                }

                public void setValue(Object val) {
                    this.val$ff[0] = (File)val;
                }

                public Object getValue() {
                    return this.val$ff[0];
                }

                public Class getPropertyType() {
                    return class$java$io$File == null ? (class$java$io$File = 10.class$("java.io.File")) : class$java$io$File;
                }

                public Class getPropertyEditorClass() {
                    return null;
                }

                public void addPropertyChangeListener(PropertyChangeListener l) {
                }

                public void removePropertyChangeListener(PropertyChangeListener l) {
                }

                public Object[] getBeans() {
                    return new Object[0];
                }

                public FeatureDescriptor getFeatureDescriptor() {
                    return this.val$fd;
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            };
            FileFilter filter = new FileFilter(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File f) {
                    return IconEditor.isImage(f.getName()) || f.isDirectory();
                }

                public String getDescription() {
                    return IconEditor.access$100("CTL_ImagesExtensionName");
                }
            };
            fd.setValue("directories", Boolean.FALSE);
            fd.setValue("files", Boolean.TRUE);
            fd.setValue("filter", filter);
            PropertyPanel panel = new PropertyPanel((PropertyModel)epm, 2);
            DialogDescriptor dd = new DialogDescriptor((Object)panel, IconEditor.getString("CTL_OpenDialogName"), true, null);
            dd.setHelpCtx(new HelpCtx("csh.openimage"));
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (res == NotifyDescriptor.OK_OPTION) {
                return ff[0];
            }
            return null;
        }

        public Object getPropertyValue() throws IllegalStateException {
            NbImageIcon ii = null;
            String s = this.tfName.getText().trim();
            if (s == null || "".equals(s) || "/".equals(s) || "///".equals(s) || s.endsWith("#")) {
                return null;
            }
            try {
                if (this.rbFile.isSelected()) {
                    ii = new NbImageIcon(s);
                    ii.type = 2;
                    ii.name = s;
                } else if (this.rbClasspath.isSelected()) {
                    URL url = IconEditor.findResource(s);
                    ii = new NbImageIcon(url);
                    ii.type = 3;
                    ii.name = s;
                } else if (this.rbUrl.isSelected()) {
                    URL url = new URL(s);
                    ii = new NbImageIcon(url);
                    ii.type = 1;
                    ii.name = s;
                }
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException(e.toString());
                ErrorManager.getDefault().annotate((Throwable)ise, 256, IconEditor.getString("MSG_IllegalValue"), IconEditor.getString("MSG_IllegalValue"), null, new Date());
                throw ise;
            }
            return ii;
        }

        void updateIcon() {
            IconEditor.this.setValue(this.localIcon);
            this.iconLabel.setIcon(this.localIcon);
            this.iconLabel.setEnabled(this.localIcon != null);
            this.validate();
        }

        void setValue() {
            String val = this.tfName.getText();
            val.trim();
            if ("".equals(val)) {
                this.localIcon = null;
                this.updateIcon();
                return;
            }
            String pref = "";
            if (this.rbUrl.isSelected()) {
                pref = "URL: ";
            } else if (this.rbFile.isSelected()) {
                pref = "File: ";
            } else if (this.rbClasspath.isSelected()) {
                pref = "Classpath: ";
            }
            try {
                this.localIcon = IconEditor.this.iconFromText(pref + val);
            }
            catch (IllegalArgumentException ee) {
                ErrorManager.getDefault().notify(1, (Throwable)ee);
                this.localIcon = null;
            }
            this.updateIcon();
        }

        static /* synthetic */ JButton access$300(IconPanel x0) {
            return x0.bSelect;
        }

        static /* synthetic */ JTextField access$400(IconPanel x0) {
            return x0.tfName;
        }

        static /* synthetic */ Icon access$502(IconPanel x0, Icon x1) {
            x0.localIcon = x1;
            return x0.localIcon;
        }

        static /* synthetic */ JRadioButton access$600(IconPanel x0) {
            return x0.rbFile;
        }

        static /* synthetic */ File access$700(IconPanel x0) {
            return x0.selectFile();
        }

        static /* synthetic */ JRadioButton access$800(IconPanel x0) {
            return x0.rbClasspath;
        }
    }

    public static class NbImageIcon
    extends ImageIcon
    implements Externalizable {
        static final long serialVersionUID = 7018807466471349466L;
        int type;
        String name;
        boolean stateValid;

        public NbImageIcon() {
            super("");
            this.stateValid = false;
        }

        NbImageIcon(URL url) {
            super(url);
            this.type = 1;
            this.stateValid = true;
        }

        NbImageIcon(String file) {
            super(file);
            this.type = 2;
            this.stateValid = true;
        }

        String getName() {
            return this.name;
        }

        public void writeExternal(ObjectOutput oo) throws IOException {
            oo.writeObject(new Integer(this.type));
            oo.writeObject(this.name);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = (Integer)in.readObject();
            this.name = (String)in.readObject();
            ImageIcon ii = null;
            switch (this.type) {
                case 1: {
                    try {
                        ii = new ImageIcon(new URL(this.name));
                        break;
                    }
                    catch (MalformedURLException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                        return;
                    }
                }
                case 2: {
                    ii = new ImageIcon(this.name);
                    break;
                }
                case 3: {
                    ii = new ImageIcon(IconEditor.findResource(this.name));
                }
            }
            this.setImage(ii.getImage());
        }
    }
}

