/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;

abstract class ObjectArrayPanel
extends JPanel {
    static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$openide$explorer$propertysheet$editors$ObjectArrayPanel == null ? (class$org$openide$explorer$propertysheet$editors$ObjectArrayPanel = ObjectArrayPanel.class$("org.openide.explorer.propertysheet.editors.ObjectArrayPanel")) : class$org$openide$explorer$propertysheet$editors$ObjectArrayPanel));
    protected DefaultListModel model;
    private JScrollPane jScrollPane1;
    private JList list;
    private JButton upButton;
    private JButton downButton;
    private JButton addButton;
    private JButton removeButton;
    private JButton changeButton;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$ObjectArrayPanel;

    public ObjectArrayPanel() {
        this.initComponents();
        this.upButton.setMnemonic(bundle.getString("CTL_MoveUp_Mnemonic").charAt(0));
        this.downButton.setMnemonic(bundle.getString("CTL_MoveDown_Mnemonic").charAt(0));
        this.addButton.setMnemonic(bundle.getString("CTL_Add_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(bundle.getString("CTL_Remove_Mnemonic").charAt(0));
        this.changeButton.setMnemonic(bundle.getString("CTL_Change_Mnemonic").charAt(0));
        this.model = new DefaultListModel();
        this.list.setModel(this.model);
        this.updateButtons();
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ObjectArrayPanel"));
        this.list.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ObjectArrayPanel_List"));
        this.list.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ObjectArrayPanel_List"));
        this.upButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_MoveUp"));
        this.downButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_MoveDown"));
        this.addButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Add"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Remove"));
        this.changeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Change"));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.changeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(200, 3));
        this.list.setVisibleRowCount(3);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ObjectArrayPanel.this.listValueChanged(evt);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ObjectArrayPanel.this.listMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridheight = 6;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(12, 12, 0, 11);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints1);
        this.upButton.setText(bundle.getString("CTL_MoveUp"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectArrayPanel.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 5, 11);
        this.add((Component)this.upButton, gridBagConstraints1);
        this.downButton.setText(bundle.getString("CTL_MoveDown"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectArrayPanel.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 0, 11);
        this.add((Component)this.downButton, gridBagConstraints1);
        this.addButton.setText(bundle.getString("CTL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectArrayPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(12, 0, 5, 11);
        this.add((Component)this.addButton, gridBagConstraints1);
        this.removeButton.setText(bundle.getString("CTL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectArrayPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.removeButton, gridBagConstraints1);
        this.changeButton.setText(bundle.getString("CTL_Change"));
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectArrayPanel.this.changeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 0, 5, 11);
        this.add((Component)this.changeButton, gridBagConstraints1);
    }

    private void listMouseClicked(MouseEvent evt) {
        Object newValue;
        int selIndex;
        if (MouseUtils.isDoubleClick((MouseEvent)evt) && (selIndex = this.list.getSelectedIndex()) != -1 && (newValue = this.editValue(this.model.getElementAt(selIndex))) != null) {
            this.model.setElementAt(newValue, selIndex);
            this.modelChanged();
            this.updateButtons();
        }
    }

    private void listValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int selIndex = this.list.getSelectedIndex();
        this.model.set(selIndex + 1, this.model.set(selIndex, this.model.getElementAt(selIndex + 1)));
        this.list.setSelectedIndex(selIndex + 1);
        this.modelChanged();
        this.updateButtons();
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int selIndex = this.list.getSelectedIndex();
        this.model.set(selIndex - 1, this.model.set(selIndex, this.model.getElementAt(selIndex - 1)));
        this.list.setSelectedIndex(selIndex - 1);
        this.modelChanged();
        this.updateButtons();
    }

    private void changeButtonActionPerformed(ActionEvent evt) {
        int selIndex = this.list.getSelectedIndex();
        Object newValue = this.editValue(this.model.getElementAt(selIndex));
        if (newValue != null) {
            this.model.setElementAt(newValue, selIndex);
            this.modelChanged();
            this.updateButtons();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int selIndex = this.list.getSelectedIndex();
        this.model.remove(selIndex);
        int size = this.model.size();
        if (size > 0) {
            selIndex = Math.min(size - 1, selIndex);
            this.list.setSelectedIndex(selIndex);
        }
        this.modelChanged();
        this.updateButtons();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        Object newValue = this.insertNewValue();
        if (newValue != null) {
            this.model.addElement(newValue);
            this.list.setSelectedIndex(this.model.size() - 1);
            this.modelChanged();
            this.updateButtons();
        }
    }

    protected JList getListComponent() {
        return this.list;
    }

    private void updateButtons() {
        boolean isEmpty = this.model.isEmpty();
        int selIndex = this.list.getSelectedIndex();
        boolean isSelected = selIndex != -1;
        this.removeButton.setEnabled(isSelected);
        this.changeButton.setEnabled(isSelected);
        this.upButton.setEnabled(isSelected && selIndex > 0);
        this.downButton.setEnabled(isSelected && selIndex < this.model.size() - 1);
    }

    protected abstract Object insertNewValue();

    protected abstract Object editValue(Object var1);

    protected void modelChanged() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

