/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.openide.cookies.ElementCookie;
import org.openide.cookies.FilterCookie;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.src.SourceElement;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public class DataObjectFilter
extends Children.Keys {
    private static Hashtable doToFilter = new Hashtable();
    private static RequestProcessor processor = new RequestProcessor();
    private Hashtable acceptedDOs = new Hashtable();
    private Hashtable filters = new Hashtable();
    private DataFolder dataFolder;
    private DataFilter filter;
    private PropertyChangeListener folderFerret;
    private PropertyChangeListener folderFerretKeeper;
    private NodeListener ferret;
    private Hashtable noToDo = new Hashtable();
    private boolean nodesInited = false;
    Collection keys;
    private Runnable currentTask;
    private HashSet currentKeys;
    private Runnable currentTask1;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$cookies$ElementCookie;
    static /* synthetic */ Class class$org$openide$cookies$FilterCookie;

    public static void registerFilterClass(Class representationClass, Class filterClass) {
        doToFilter.put(representationClass, filterClass);
    }

    public static Class getFilterClass(Class representationClass) {
        return (Class)doToFilter.get(representationClass);
    }

    public DataObjectFilter(Class[] representationClasses) {
        this.filter = new DataFilter(){

            public boolean acceptDataObject(DataObject obj) {
                Enumeration e = DataObjectFilter.this.acceptedDOs.keys();
                Class<?> c = obj.getClass();
                while (e.hasMoreElements()) {
                    if (!((Class)e.nextElement()).isAssignableFrom(c)) continue;
                    return true;
                }
                return false;
            }
        };
        this.folderFerretKeeper = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                if (DataObjectFilter.this.nodesInited && ev.getPropertyName().equals("children")) {
                    DataObjectFilter.this.refreshAll();
                }
            }
        };
        this.folderFerret = WeakListener.propertyChange((PropertyChangeListener)this.folderFerretKeeper, null);
        this.ferret = new NodeAdapter(){

            public void childrenAdded(NodeMemberEvent ev) {
                DataObjectFilter.this.refresh((DataObject)DataObjectFilter.this.noToDo.get(ev.getSource()));
            }

            public void childrenRemoved(NodeMemberEvent ev) {
                DataObjectFilter.this.refresh((DataObject)DataObjectFilter.this.noToDo.get(ev.getSource()));
            }
        };
        int k = representationClasses.length;
        int i = 0;
        while (i < k) {
            this.acceptedDOs.put(representationClasses[i], representationClasses[i]);
            ++i;
        }
    }

    public DataObjectFilter() {
        this(new Class[0]);
        DataLoader[] loaders = ((DataLoaderPool)Lookup.getDefault().lookup(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = DataObjectFilter.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool)).toArray();
        int k = loaders.length;
        int i = 0;
        while (i < k) {
            Class c;
            if (!(class$org$openide$loaders$DataFolder == null ? DataObjectFilter.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder).isAssignableFrom(c = loaders[i].getRepresentationClass())) {
                this.acceptedDOs.put(c, c);
            }
            ++i;
        }
    }

    public DataObjectFilter(DataFolder dataFolder) {
        this();
        this.dataFolder = dataFolder;
    }

    public void putFilter(Class filterClass, Object filter) {
        Object old = this.filters.get(filterClass);
        if (old == null ? filter == null : filter != null && filter.equals(old)) {
            return;
        }
        if (filter == null) {
            this.filters.remove(filterClass);
        } else {
            this.filters.put(filterClass, filter);
        }
        if (this.nodesInited) {
            this.refreshNodes();
        }
    }

    public void addLoader(Class representationClass) {
        this.acceptedDOs.put(representationClass, representationClass);
        if (this.nodesInited) {
            this.refreshAll();
        }
    }

    public void removeLoader(Class representationClass) {
        Object filter = doToFilter.get(representationClass);
        if (filter != null) {
            this.filters.remove(filter);
        }
        this.acceptedDOs.remove(representationClass);
        if (this.nodesInited) {
            this.refreshAll();
        }
    }

    public synchronized void setDataFolder(DataFolder f) {
        if (this.dataFolder != null && f != null && this.dataFolder.equals(f)) {
            return;
        }
        if (this.dataFolder != null) {
            this.dataFolder.removePropertyChangeListener(this.folderFerret);
            this.cancel();
        }
        this.dataFolder = f;
        this.refreshAll();
        if (this.dataFolder != null) {
            this.dataFolder.addPropertyChangeListener(this.folderFerret);
        }
    }

    public DataFolder getDataFolder() {
        return this.dataFolder;
    }

    protected void addNotify() {
        this.nodesInited = true;
    }

    protected void removeNotify() {
        this.setKeysHelper(Collections.EMPTY_SET);
        this.nodesInited = false;
    }

    protected Node[] createNodes(Object key) {
        Object filter;
        DataObject DO = (DataObject)key;
        if (!this.currentKeys.contains(DO)) {
            return new Node[0];
        }
        ElementCookie ec = (ElementCookie)DO.getCookie(class$org$openide$cookies$ElementCookie == null ? (class$org$openide$cookies$ElementCookie = DataObjectFilter.class$("org.openide.cookies.ElementCookie")) : class$org$openide$cookies$ElementCookie);
        if (ec == null) {
            Node root = DO.getNodeDelegate().cloneNode();
            return new Node[]{root};
        }
        Node root = ec.getElementsParent();
        FilterCookie fc = (FilterCookie)root.getCookie(class$org$openide$cookies$FilterCookie == null ? (class$org$openide$cookies$FilterCookie = DataObjectFilter.class$("org.openide.cookies.FilterCookie")) : class$org$openide$cookies$FilterCookie);
        if (fc != null && (filter = this.filters.get(fc.getFilterClass())) != null) {
            fc.setFilter(filter);
        }
        Node[] n = root.getChildren().getNodes();
        if (this.noToDo.get(root) == null) {
            root.addNodeListener(this.ferret);
            this.noToDo.put(root, key);
        }
        int k = n.length;
        Node[] nn = new Node[k];
        int i = 0;
        while (i < k) {
            nn[i] = n[i].cloneNode();
            ++i;
        }
        return nn;
    }

    void refreshAllKeys() {
        this.setKeys(Collections.EMPTY_SET);
        this.setKeys(this.keys);
    }

    void setKeysHelper(Collection l) {
        this.keys = l;
        this.setKeys(this.keys);
    }

    void refreskKeyHelper(Object l) {
        this.refreshKey(l);
    }

    private synchronized void cancel() {
        this.currentTask = null;
        Enumeration e = this.noToDo.keys();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            n.removeNodeListener(this.ferret);
        }
        this.noToDo = new Hashtable();
    }

    private void refreshAll() {
        if (this.dataFolder == null) {
            this.setKeysHelper(Collections.EMPTY_SET);
            return;
        }
        this.currentKeys = new HashSet();
        this.currentTask = new Runnable(){
            static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

            public void run() {
                if (DataObjectFilter.this.currentTask != this) {
                    return;
                }
                List newDo = DataObjectFilter.this.dataFolder.getChildrenList();
                int i = newDo.size() - 1;
                while (i >= 0) {
                    if (!DataObjectFilter.this.filter.acceptDataObject((DataObject)newDo.get(i))) {
                        newDo.remove(i);
                    }
                    --i;
                }
                if (DataObjectFilter.this.currentTask != this) {
                    return;
                }
                DataObjectFilter.this.currentKeys = new HashSet(newDo);
                LinkedList<DataObject> ll = new LinkedList<DataObject>();
                int k = newDo.size();
                i = 0;
                while (i < k) {
                    DataObject o = (DataObject)newDo.get(i);
                    SourceCookie sc = (SourceCookie)o.getCookie(class$org$openide$cookies$SourceCookie == null ? 4.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
                    if (sc != null) {
                        SourceElement se = sc.getSource();
                        se.prepare().waitFinished();
                        if (DataObjectFilter.this.currentTask != this) {
                            return;
                        }
                    }
                    ll.add(o);
                    DataObjectFilter.this.setKeysHelper(ll);
                    ++i;
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        RequestProcessor.postRequest((Runnable)this.currentTask);
    }

    private void refreshNodes() {
        if (this.dataFolder == null) {
            this.setKeysHelper(Collections.EMPTY_SET);
            return;
        }
        this.currentTask1 = new Runnable(){

            public void run() {
                if (DataObjectFilter.this.dataFolder == null) {
                    return;
                }
                if (this != DataObjectFilter.this.currentTask1) {
                    return;
                }
                DataObjectFilter.this.refreshAllKeys();
            }
        };
        RequestProcessor.postRequest((Runnable)this.currentTask1);
    }

    private void refresh(final DataObject key) {
        if (!this.currentKeys.contains(key)) {
            return;
        }
        if (!this.filter.acceptDataObject(key)) {
            return;
        }
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                if (!DataObjectFilter.this.currentKeys.contains(key)) {
                    return;
                }
                DataObjectFilter.this.refreskKeyHelper(key);
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

