/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.beans.Beans;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import org.openide.ServiceType;
import org.openide.debugger.Debugger;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataLoader;
import org.openide.modules.IllegalModuleException;
import org.openide.modules.ModuleDescription;
import org.openide.nodes.Node;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExClipboard;

public abstract class ManifestSection {
    String name;
    private String className;
    private Object result;
    private ModuleDescription descr;
    static /* synthetic */ Class class$org$openide$util$SharedClassObject;
    static /* synthetic */ Class class$org$openide$modules$ManifestSection;

    ManifestSection(String name, ModuleDescription descr) throws IllegalModuleException {
        this.name = name;
        this.descr = descr;
        this.className = ModuleDescription.createPackageName(name);
    }

    public Class getSectionClass() throws Exception {
        if (this.name.endsWith(".class")) {
            return this.descr.cl.loadClass(this.className);
        }
        return this.getInstance().getClass();
    }

    Object createInstance() throws Exception {
        Object o = null;
        try {
            Class<?> clazz;
            if (this.name.endsWith(".class") && (class$org$openide$util$SharedClassObject == null ? (class$org$openide$util$SharedClassObject = ManifestSection.class$("org.openide.util.SharedClassObject")) : class$org$openide$util$SharedClassObject).isAssignableFrom(clazz = this.descr.cl.loadClass(this.className))) {
                o = SharedClassObject.findObject(clazz, (boolean)true);
            }
            if (o == null) {
                o = Beans.instantiate(this.descr.cl, this.className);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.descr.showLoader();
            throw cnfe;
        }
        if (this.name.endsWith(".class") && o.getClass().getClassLoader() != this.descr.cl) {
            this.descr.badClasses.add(o.getClass());
        }
        return o;
    }

    synchronized Object getInstance() throws Exception {
        if (this.result instanceof Exception) {
            ((Exception)this.result).fillInStackTrace();
            throw (Exception)this.result;
        }
        if (this.result == null) {
            try {
                this.result = this.createInstance();
            }
            catch (Exception ex) {
                this.result = ex;
                throw ex;
            }
            catch (Throwable ex) {
                this.result = new ClassNotFoundException(ManifestSection.exceptionMessage(ex));
                throw (Exception)this.result;
            }
        }
        return this.result;
    }

    void release() {
        this.result = null;
    }

    static String exceptionMessage(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter(sw);
        w.println(ex.getClass().getName());
        ex.printStackTrace(w);
        w.close();
        return sw.toString();
    }

    abstract void invokeIterator(Iterator var1) throws Exception;

    static ManifestSection createSection(String name, Attributes attr, ModuleDescription descr) throws IllegalModuleException {
        String sectionName = attr.getValue(ModuleDescription.TAG_SECTION_CLASS);
        if (sectionName == null) {
            return null;
        }
        if (sectionName.equalsIgnoreCase("Action")) {
            return new ActionSection(name, attr, descr);
        }
        if (sectionName.equalsIgnoreCase("Option")) {
            return new OptionSection(name, attr, descr);
        }
        if (sectionName.equalsIgnoreCase("Loader")) {
            return new LoaderSection(name, attr, descr);
        }
        if (sectionName.equalsIgnoreCase("Filesystem")) {
            return new FileSystemSection(name, attr, descr);
        }
        if (sectionName.equalsIgnoreCase("Node")) {
            return new NodeSection(name, attr, descr);
        }
        if (sectionName.equalsIgnoreCase("Service")) {
            return new ServiceSection(name, attr, descr);
        }
        if (sectionName.equalsIgnoreCase("Debugger")) {
            return new DebuggerSection(name, attr, descr);
        }
        if (sectionName.equalsIgnoreCase("ClipboardConvertor")) {
            return new ClipboardConvertorSection(name, attr, descr);
        }
        throw new IllegalModuleException(NbBundle.getMessage((Class)(class$org$openide$modules$ManifestSection == null ? (class$org$openide$modules$ManifestSection = ManifestSection.class$("org.openide.modules.ManifestSection")) : class$org$openide$modules$ManifestSection), (String)"EXC_IllegalModuleClass", (Object)name, (Object)sectionName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class ClipboardConvertorSection
    extends ManifestSection {
        ClipboardConvertorSection(String name, Attributes attrs, ModuleDescription descr) throws IllegalModuleException {
            super(name, descr);
        }

        public ExClipboard.Convertor getConvertor() throws InstantiationException {
            try {
                return (ExClipboard.Convertor)super.getInstance();
            }
            catch (Exception ex) {
                throw new InstantiationException(ManifestSection.exceptionMessage(ex));
            }
        }

        void invokeIterator(Iterator it) throws Exception {
            it.processClipboardConvertor(this);
        }
    }

    public static final class NodeSection
    extends ManifestSection {
        public static final String TYPE_ROOTS = "roots";
        public static final String TYPE_ENVIRONMENT = "environment";
        public static final String TYPE_SESSION = "session";
        private String type;

        NodeSection(String name, Attributes attrs, ModuleDescription descr) throws IllegalModuleException {
            super(name, descr);
            this.type = attrs.getValue(ModuleDescription.TAG_NODE_TYPE);
        }

        public Node getNode() throws InstantiationException {
            try {
                return (Node)super.getInstance();
            }
            catch (Exception ex) {
                throw new InstantiationException(ManifestSection.exceptionMessage(ex));
            }
        }

        public String getType() {
            return this.type;
        }

        void invokeIterator(Iterator it) throws Exception {
            it.processNode(this);
        }
    }

    public static final class FileSystemSection
    extends ManifestSection {
        private Attributes attr;
        static /* synthetic */ Class class$org$openide$modules$ManifestSection;

        FileSystemSection(String name, Attributes attr, ModuleDescription descr) throws IllegalModuleException {
            super(name, descr);
            this.attr = attr;
        }

        public String getName() {
            String s = NbBundle.getLocalizedValue((Attributes)this.attr, (Attributes.Name)ModuleDescription.TAG_FILESYSTEM_NAME);
            if (s == null) {
                return NbBundle.getMessage((Class)(class$org$openide$modules$ManifestSection == null ? (class$org$openide$modules$ManifestSection = FileSystemSection.class$("org.openide.modules.ManifestSection")) : class$org$openide$modules$ManifestSection), (String)"CTL_Repository_Unknown", (Object)this.name);
            }
            return s;
        }

        public HelpCtx getHelpCtx() {
            String s = this.attr.getValue(ModuleDescription.TAG_FILESYSTEM_HELP);
            return s == null ? HelpCtx.DEFAULT_HELP : new HelpCtx(s);
        }

        public FileSystem createFileSystem() throws InstantiationException {
            try {
                return (FileSystem)super.createInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new InstantiationException(ManifestSection.exceptionMessage(ex));
            }
        }

        void invokeIterator(Iterator it) throws Exception {
            it.processFileSystem(this);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class ServiceSection
    extends ManifestSection {
        private Attributes attr;

        ServiceSection(String name, Attributes attrs, ModuleDescription descr) throws IllegalModuleException {
            super(name, descr);
            this.attr = attrs;
        }

        public boolean isDefault() {
            return Boolean.valueOf(this.attr.getValue(ModuleDescription.TAG_SERVICE_DEFAULT));
        }

        public ServiceType getServiceType() throws InstantiationException {
            try {
                return (ServiceType)super.getInstance();
            }
            catch (Exception ex) {
                throw new InstantiationException(ManifestSection.exceptionMessage(ex));
            }
        }

        public ServiceType createServiceType() throws InstantiationException {
            try {
                return (ServiceType)super.createInstance();
            }
            catch (Exception ex) {
                throw new InstantiationException(ManifestSection.exceptionMessage(ex));
            }
        }

        void invokeIterator(Iterator it) throws Exception {
            it.processService(this);
        }
    }

    public static final class DebuggerSection
    extends ManifestSection {
        DebuggerSection(String name, Attributes attrs, ModuleDescription descr) throws IllegalModuleException {
            super(name, descr);
        }

        public Debugger getDebugger() throws InstantiationException {
            try {
                return (Debugger)super.getInstance();
            }
            catch (Exception ex) {
                throw new InstantiationException(ManifestSection.exceptionMessage(ex));
            }
        }

        void invokeIterator(Iterator it) throws Exception {
            it.processDebugger(this);
        }
    }

    public static final class LoaderSection
    extends ManifestSection {
        private String[] installAfter;
        private String[] installBefore;

        LoaderSection(String name, Attributes attrs, ModuleDescription descr) throws IllegalModuleException {
            super(name, descr);
            String clazz;
            LinkedList<String> res;
            StringTokenizer tok;
            String val = attrs.getValue(ModuleDescription.TAG_INSTALL_AFTER);
            if (val != null) {
                tok = new StringTokenizer(val, ", ");
                res = new LinkedList<String>();
                while (tok.hasMoreTokens()) {
                    clazz = tok.nextToken();
                    if (clazz.equals("")) continue;
                    res.add(clazz);
                }
                this.installAfter = res.toArray(new String[res.size()]);
            } else {
                this.installAfter = null;
            }
            val = attrs.getValue(ModuleDescription.TAG_INSTALL_BEFORE);
            if (val != null) {
                tok = new StringTokenizer(val, ", ");
                res = new LinkedList();
                while (tok.hasMoreTokens()) {
                    clazz = tok.nextToken();
                    if (clazz.equals("")) continue;
                    res.add(clazz);
                }
                this.installBefore = res.toArray(new String[res.size()]);
            } else {
                this.installBefore = null;
            }
        }

        public DataLoader getLoader() throws InstantiationException {
            try {
                return (DataLoader)super.getInstance();
            }
            catch (Exception ex) {
                throw new InstantiationException(ManifestSection.exceptionMessage(ex));
            }
        }

        public String[] getInstallAfter() {
            return this.installAfter;
        }

        public String[] getInstallBefore() {
            return this.installBefore;
        }

        void invokeIterator(Iterator it) throws Exception {
            it.processLoader(this);
        }
    }

    public static final class OptionSection
    extends ManifestSection {
        OptionSection(String name, Attributes attrs, ModuleDescription descr) throws IllegalModuleException {
            super(name, descr);
        }

        public SystemOption getOption() throws InstantiationException {
            try {
                return (SystemOption)super.getInstance();
            }
            catch (Exception ex) {
                throw new InstantiationException(ManifestSection.exceptionMessage(ex));
            }
        }

        void invokeIterator(Iterator it) throws Exception {
            it.processOption(this);
        }
    }

    public static final class ActionSection
    extends ManifestSection {
        ActionSection(String name, Attributes attrs, ModuleDescription descr) throws IllegalModuleException {
            super(name, descr);
        }

        public SystemAction getAction() throws InstantiationException {
            try {
                return (SystemAction)super.getInstance();
            }
            catch (Exception ex) {
                throw new InstantiationException(ManifestSection.exceptionMessage(ex));
            }
        }

        void invokeIterator(Iterator it) throws Exception {
            it.processAction(this);
        }
    }

    public static interface Iterator {
        public void processAction(ActionSection var1) throws InstantiationException;

        public void processOption(OptionSection var1) throws InstantiationException;

        public void processLoader(LoaderSection var1) throws InstantiationException;

        public void processDebugger(DebuggerSection var1) throws InstantiationException;

        public void processService(ServiceSection var1) throws InstantiationException;

        public void processFileSystem(FileSystemSection var1) throws InstantiationException;

        public void processNode(NodeSection var1) throws InstantiationException;

        public void processClipboardConvertor(ClipboardConvertorSection var1) throws InstantiationException;
    }
}

