/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.settings.InstanceProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.Lookup;

public final class Env
implements Environment.Provider {
    public static final String EA_CONVERTOR = "settings.convertor";
    public static final String EA_PROVIDER_PATH = "settings.providerPath";
    public static final String EA_PUBLICID = "hint.originalPublicID";
    public static final String EA_INSTANCE_CLASS_NAME = "settings.instanceClass";
    public static final String EA_INSTANCE_OF = "settings.instanceOf";
    public static final String EA_INSTANCE_CREATE = "settings.instanceCreate";
    private final FileObject providerFO;
    private static String xmlLookupsPrefix = "xml/lookups";
    private static String xmlEntitiesPrefix = "xml/entities";

    public static Environment.Provider create(FileObject fo) {
        return new Env(fo);
    }

    private Env(FileObject fo) {
        this.providerFO = fo;
    }

    public Lookup getEnvironment(DataObject dobj) {
        if (!(dobj instanceof InstanceDataObject)) {
            return Lookup.EMPTY;
        }
        InstanceProvider icp = new InstanceProvider(dobj, this.providerFO);
        return icp.getLookup();
    }

    public static Set parseAttribute(Object attr) {
        if (attr != null && attr instanceof String) {
            StringTokenizer s = new StringTokenizer((String)attr, ",");
            HashSet<String> set = new HashSet<String>(10);
            while (s.hasMoreTokens()) {
                set.add(s.nextToken().trim());
            }
            return set;
        }
        return Collections.EMPTY_SET;
    }

    public static FileObject findProvider(Class clazz) throws IOException {
        String providerPath;
        String prefix = "xml/memory/";
        String name = clazz.getName().replace('.', '/');
        FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
        FileObject memContext = sfs.findResource(prefix);
        if (memContext == null) {
            throw new FileNotFoundException("SFS/xml/memory/");
        }
        String convertorPath = new StringBuffer(200).append(prefix).append(name).toString();
        FileObject fo = sfs.findResource(convertorPath);
        if (fo != null && (providerPath = (String)fo.getAttribute(EA_PROVIDER_PATH)) != null) {
            return sfs.findResource(providerPath);
        }
        return null;
    }

    public static FileObject findEntityRegistration(FileObject provider) {
        String filename = provider.getPackageName('/');
        String resource = xmlEntitiesPrefix + filename.substring(xmlLookupsPrefix.length(), filename.length());
        return Repository.getDefault().getDefaultFileSystem().findResource(resource);
    }
}

