/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings.convertors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.settings.Env;
import org.netbeans.spi.settings.Convertor;
import org.netbeans.spi.settings.Saver;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLPropertiesConvertor
extends Convertor
implements PropertyChangeListener {
    public static final String EA_PREVENT_STORING = "xmlproperties.preventStoring";
    public static final String EA_IGNORE_CHANGES = "xmlproperties.ignoreChanges";
    private FileObject providerFO;
    private Set ignoreProperites;
    private Saver saver;
    private static final String INDENT = "    ";
    private String instanceClass = null;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$util$Properties;

    public static Convertor create(FileObject providerFO) {
        return new XMLPropertiesConvertor(providerFO);
    }

    public XMLPropertiesConvertor(FileObject fo) {
        this.providerFO = fo;
    }

    public Object read(java.io.Reader r) throws IOException, ClassNotFoundException {
        Object def = this.defaultInstanceCreate();
        this.readSetting(r, def);
        return def;
    }

    public void write(Writer w, Object inst) throws IOException {
        Object publicId;
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        w.write("<!DOCTYPE properties PUBLIC \"");
        FileObject foEntity = Env.findEntityRegistration(this.providerFO);
        if (foEntity == null) {
            foEntity = this.providerFO;
        }
        if ((publicId = foEntity.getAttribute("hint.originalPublicID")) == null || !(publicId instanceof String)) {
            throw new IOException("missing or invalid attribute: hint.originalPublicID, provider: " + foEntity);
        }
        w.write((String)publicId);
        w.write("\" \"http://www.netbeans.org/dtds/properties-1_0.dtd\">\n");
        w.write("<properties>\n");
        Properties p = XMLPropertiesConvertor.getProperties(inst);
        if (p != null && !((Hashtable)p).isEmpty()) {
            XMLPropertiesConvertor.writeProperties(w, p);
        }
        w.write("</properties>\n");
    }

    public void registerSaver(Object inst, Saver s) {
        if (this.saver != null) {
            ErrorManager.getDefault().log(4096, "[Warning] Saver already registered");
            return;
        }
        try {
            Method method = inst.getClass().getMethod("addPropertyChangeListener", class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = XMLPropertiesConvertor.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
            method.invoke(inst, this);
            this.saver = s;
        }
        catch (NoSuchMethodException ex) {
            ErrorManager.getDefault().log(1, "ObjectChangesNotifier: NoSuchMethodException: " + inst.getClass().getName() + ".addPropertyChangeListener");
        }
        catch (IllegalAccessException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void unregisterSaver(Object inst, Saver s) {
        if (this.saver == null) {
            return;
        }
        if (this.saver != s) {
            ErrorManager.getDefault().log(4096, "[Warning] trying unregistered unknown Saver");
            return;
        }
        try {
            Method method = inst.getClass().getMethod("removePropertyChangeListener", class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = XMLPropertiesConvertor.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
            method.invoke(inst, this);
            this.saver = null;
        }
        catch (NoSuchMethodException ex) {
            ErrorManager.getDefault().log(1, "ObjectChangesNotifier: NoSuchMethodException: " + inst.getClass().getName() + ".removePropertyChangeListener");
        }
        catch (IllegalAccessException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.saver == null || this.ignoreChange(evt)) {
            return;
        }
        if (this.acceptSave()) {
            try {
                this.saver.requestSave();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
            }
        } else {
            this.saver.markDirty();
        }
    }

    private boolean ignoreChange(PropertyChangeEvent pce) {
        if (pce == null || pce.getPropertyName() == null) {
            return true;
        }
        if (this.ignoreProperites == null) {
            this.ignoreProperites = Env.parseAttribute(this.providerFO.getAttribute(EA_IGNORE_CHANGES));
        }
        if (this.ignoreProperites.contains(pce.getPropertyName())) {
            return true;
        }
        return this.ignoreProperites.contains("all");
    }

    private boolean acceptSave() {
        Object storing = this.providerFO.getAttribute(EA_PREVENT_STORING);
        if (storing == null) {
            return true;
        }
        if (storing instanceof Boolean) {
            return (Boolean)storing == false;
        }
        if (storing instanceof String) {
            return Boolean.valueOf((String)storing) == false;
        }
        return true;
    }

    private Object defaultInstanceCreate() throws IOException, ClassNotFoundException {
        Object instanceCreate = this.providerFO.getAttribute("settings.instanceCreate");
        if (instanceCreate != null) {
            return instanceCreate;
        }
        Class c = this.getInstanceClass();
        try {
            return c.newInstance();
        }
        catch (Exception ex) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Cannot create instance of " + c.getName()), (Throwable)ex);
        }
    }

    private Class getInstanceClass() throws IOException, ClassNotFoundException {
        if (this.instanceClass == null) {
            Object name = this.providerFO.getAttribute("settings.instanceClass");
            if (name == null || !(name instanceof String)) {
                throw new IllegalStateException("missing or invalid ea attribute: settings.instanceClass");
            }
            this.instanceClass = (String)name;
        }
        return ((ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = XMLPropertiesConvertor.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)).loadClass(this.instanceClass);
    }

    private void readSetting(java.io.Reader input, Object inst) throws IOException {
        try {
            Method m = inst.getClass().getDeclaredMethod("readProperties", class$java$util$Properties == null ? (class$java$util$Properties = XMLPropertiesConvertor.class$("java.util.Properties")) : class$java$util$Properties);
            ((AccessibleObject)m).setAccessible(true);
            Reader r = new Reader();
            r.parse(input);
            ((AccessibleObject)m).setAccessible(true);
            m.invoke(inst, r.getProperties());
        }
        catch (NoSuchMethodException ex) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(ex.getLocalizedMessage()), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(ex.getLocalizedMessage()), (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(t.getLocalizedMessage()), t);
        }
    }

    private static void writeProperties(Writer w, Properties p) throws IOException {
        Iterator it = ((Hashtable)p).keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            w.write(INDENT);
            w.write("<property name=\"");
            w.write(key);
            w.write("\" value=\"");
            w.write(p.getProperty(key));
            w.write("\"/>\n");
        }
    }

    private static Properties getProperties(Object inst) throws IOException {
        try {
            Method m = inst.getClass().getDeclaredMethod("writeProperties", class$java$util$Properties == null ? (class$java$util$Properties = XMLPropertiesConvertor.class$("java.util.Properties")) : class$java$util$Properties);
            ((AccessibleObject)m).setAccessible(true);
            Properties prop = new Properties();
            m.invoke(inst, prop);
            return prop;
        }
        catch (NoSuchMethodException ex) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(ex.getLocalizedMessage()), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(ex.getLocalizedMessage()), (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(t.getLocalizedMessage()), t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Reader
    extends DefaultHandler
    implements LexicalHandler {
        private static final String ELM_PROPERTY = "property";
        private static final String ATR_PROPERTY_NAME = "name";
        private static final String ATR_PROPERTY_VALUE = "value";
        private Properties props = new Properties();
        private String publicId;

        Reader() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (this.publicId != null && this.publicId.equals(publicId)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }

        public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
            if (ELM_PROPERTY.equals(qName)) {
                String propertyName = attribs.getValue(ATR_PROPERTY_NAME);
                String propertyValue = attribs.getValue(ATR_PROPERTY_VALUE);
                this.props.setProperty(propertyName, propertyValue);
            }
        }

        public void parse(java.io.Reader src) throws IOException {
            try {
                XMLReader reader = XMLUtil.createXMLReader((boolean)false, (boolean)false);
                reader.setContentHandler(this);
                reader.setEntityResolver(this);
                InputSource is = new InputSource(src);
                try {
                    reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                }
                catch (SAXException sex) {
                    ErrorManager.getDefault().log(4096, "Warning: XML parser does not support lexical-handler feature.");
                }
                reader.parse(is);
            }
            catch (SAXException ex) {
                IOException ioe = new IOException();
                ErrorManager emgr = ErrorManager.getDefault();
                emgr.annotate((Throwable)ioe, (Throwable)ex);
                if (ex.getException() != null) {
                    emgr.annotate((Throwable)ioe, (Throwable)ex.getException());
                }
                throw ioe;
            }
        }

        public Properties getProperties() {
            return this.props;
        }

        public String getPublicID() {
            return this.publicId;
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.publicId = publicId;
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String str) throws SAXException {
        }

        public void endEntity(String str) throws SAXException {
        }

        public void comment(char[] values, int param, int param2) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }
    }
}

