/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.netbeans.modules.web.monitor.client.CurrNode;
import org.netbeans.modules.web.monitor.client.NavigateNode;
import org.netbeans.modules.web.monitor.client.NestedNode;
import org.netbeans.modules.web.monitor.client.SavedNode;
import org.netbeans.modules.web.monitor.client.TransactionNode;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.netbeans.modules.web.monitor.data.DispatchData;
import org.netbeans.modules.web.monitor.data.Dispatches;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.options.SystemOption;
import org.openide.util.HttpServer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class Controller {
    public static final String REPLAY = "netbeans.replay";
    public static final String PORT = "netbeans.replay.port";
    public static final String REPLAYSTATUS = "netbeans.replay.status";
    public static final String REPLAYSESSION = "netbeans.replay.session";
    public static final boolean debug = false;
    private static transient String server = "localhost";
    private static transient int port = 8080;
    private static FileObject monDir = null;
    private static FileObject currDir = null;
    private static FileObject saveDir = null;
    private static FileObject replayDir = null;
    public static final String monDirStr = "HTTPMonitor";
    public static final String currDirStr = "current";
    public static final String saveDirStr = "save";
    public static final String replayDirStr = "replay";
    private transient NavigateNode root = null;
    private Children.SortedArray currTrans = null;
    private Children.SortedArray savedTrans = null;
    private Hashtable currBeans = new Hashtable();
    private Hashtable saveBeans = new Hashtable();
    private transient Comparator comp = null;
    private HtmlBrowser.BrowserComponent browser = null;
    private SettingsListener browserListener = null;
    private SystemOption settings = null;
    private boolean useBrowserCookie = true;
    static /* synthetic */ Class class$org$netbeans$modules$web$monitor$client$Controller;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$awt$HtmlBrowser$Factory;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie$Of;
    static /* synthetic */ Class class$org$openide$options$SystemOption;

    public Controller() {
        this.createNodeStructure();
        this.registerBrowserListener();
    }

    private void createNodeStructure() {
        this.comp = new CompTime(true);
        this.currTrans = new Children.SortedArray();
        this.currTrans.setComparator(this.comp);
        this.savedTrans = new Children.SortedArray();
        this.savedTrans.setComparator(this.comp);
        CurrNode currNode = new CurrNode((Children)this.currTrans);
        SavedNode savedNode = new SavedNode((Children)this.savedTrans);
        Node[] kids = new Node[]{currNode, savedNode};
        Children.Array children = new Children.Array();
        children.add(kids);
        this.root = new NavigateNode((Children)children);
    }

    public void cleanup() {
        this.deleteDirectory(currDirStr);
        this.removeBrowserListener();
    }

    void addTransaction(String id) {
        TransactionNode[] nodes = new TransactionNode[1];
        MonitorData md = this.retrieveMonitorData(id, currDirStr);
        nodes[0] = this.createTransactionNode(md, true);
        this.currTrans.add((Node[])nodes);
    }

    protected NavigateNode getRoot() {
        return this.root;
    }

    protected static FileObject getMonDir() throws FileNotFoundException {
        if (monDir == null || !monDir.isFolder()) {
            Controller.createDirectories();
        }
        return monDir;
    }

    protected static FileObject getCurrDir() throws FileNotFoundException {
        if (currDir == null || !currDir.isFolder()) {
            Controller.createDirectories();
        }
        return currDir;
    }

    protected static FileObject getReplayDir() throws FileNotFoundException {
        if (replayDir == null || !replayDir.isFolder()) {
            Controller.createDirectories();
        }
        return replayDir;
    }

    protected static FileObject getSaveDir() throws FileNotFoundException {
        if (saveDir == null || !saveDir.isFolder()) {
            Controller.createDirectories();
        }
        return saveDir;
    }

    public boolean haveDirectories() {
        if (currDir == null) {
            try {
                currDir = Controller.getCurrDir();
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (saveDir == null) {
            try {
                saveDir = Controller.getSaveDir();
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void createDirectories() throws FileNotFoundException {
        FileObject rootdir = Repository.getDefault().getDefaultFileSystem().getRoot();
        FileLock lock = null;
        if (monDir == null || !monDir.isFolder()) {
            try {
                monDir = rootdir.getFileObject(monDirStr);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (monDir == null || !monDir.isFolder()) {
                block56: {
                    if (monDir != null) {
                        try {
                            try {
                                lock = monDir.lock();
                                monDir.delete(lock);
                            }
                            catch (FileAlreadyLockedException falex) {
                                throw new FileNotFoundException();
                            }
                            catch (IOException ex) {
                                throw new FileNotFoundException();
                            }
                            Object var5_14 = null;
                            if (lock == null) break block56;
                        }
                        catch (Throwable throwable) {
                            Object var5_15 = null;
                            if (lock != null) {
                                lock.releaseLock();
                            }
                            throw throwable;
                        }
                        lock.releaseLock();
                    }
                }
                try {
                    monDir = rootdir.createFolder(monDirStr);
                }
                catch (IOException ioex) {
                    // empty catch block
                }
            }
            if (monDir == null || !monDir.isFolder()) {
                throw new FileNotFoundException();
            }
        }
        if (currDir == null || !currDir.isFolder()) {
            try {
                currDir = monDir.getFileObject(currDirStr);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (currDir == null || !currDir.isFolder()) {
                block57: {
                    lock = null;
                    if (currDir != null) {
                        try {
                            try {
                                lock = currDir.lock();
                                currDir.delete(lock);
                            }
                            catch (FileAlreadyLockedException falex) {
                                throw new FileNotFoundException();
                            }
                            catch (IOException ex) {
                                throw new FileNotFoundException();
                            }
                            Object var7_21 = null;
                            if (lock == null) break block57;
                        }
                        catch (Throwable throwable) {
                            Object var7_22 = null;
                            if (lock != null) {
                                lock.releaseLock();
                            }
                            throw throwable;
                        }
                        lock.releaseLock();
                    }
                }
                try {
                    currDir = monDir.createFolder(currDirStr);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (currDir == null || !currDir.isFolder()) {
                throw new FileNotFoundException();
            }
        }
        if (saveDir == null || !saveDir.isFolder()) {
            try {
                saveDir = monDir.getFileObject(saveDirStr);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (saveDir == null || !saveDir.isFolder()) {
                block58: {
                    if (saveDir != null) {
                        lock = null;
                        try {
                            try {
                                lock = saveDir.lock();
                                saveDir.delete(lock);
                            }
                            catch (FileAlreadyLockedException falex) {
                                throw new FileNotFoundException();
                            }
                            catch (IOException ex) {
                                throw new FileNotFoundException();
                            }
                            Object var9_24 = null;
                            if (lock == null) break block58;
                        }
                        catch (Throwable throwable) {
                            Object var9_25 = null;
                            if (lock != null) {
                                lock.releaseLock();
                            }
                            throw throwable;
                        }
                        lock.releaseLock();
                    }
                }
                try {
                    saveDir = monDir.createFolder(saveDirStr);
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (saveDir == null || !saveDir.isFolder()) {
                throw new FileNotFoundException();
            }
        }
        if (replayDir == null || !replayDir.isFolder()) {
            try {
                replayDir = monDir.getFileObject(replayDirStr);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (replayDir == null || !replayDir.isFolder()) {
                block59: {
                    if (replayDir != null) {
                        lock = null;
                        try {
                            try {
                                lock = replayDir.lock();
                                replayDir.delete(lock);
                            }
                            catch (FileAlreadyLockedException falex) {
                                throw new FileNotFoundException();
                            }
                            catch (IOException ex) {
                                throw new FileNotFoundException();
                            }
                            Object var11_27 = null;
                            if (lock == null) break block59;
                        }
                        catch (Throwable throwable) {
                            Object var11_28 = null;
                            if (lock != null) {
                                lock.releaseLock();
                            }
                            throw throwable;
                        }
                        lock.releaseLock();
                    }
                }
                try {
                    replayDir = monDir.createFolder(replayDirStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (replayDir == null || !replayDir.isFolder()) {
                throw new FileNotFoundException();
            }
        }
    }

    public void replayTransaction(Node node) {
        if (!this.checkServer(true)) {
            return;
        }
        TransactionNode tn = null;
        try {
            tn = (TransactionNode)node;
        }
        catch (ClassCastException cce) {
            return;
        }
        MonitorData md = this.getMonitorData(tn, false, false);
        if (!this.useBrowserCookie) {
            md.getRequestData().setReplaceSessionCookie(true);
        }
        String status = tn.isCurrent() ? currDirStr : saveDirStr;
        try {
            this.replayTransaction(md, status);
        }
        catch (UnknownHostException uhe) {
            Object[] options = new Object[]{NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$Controller == null ? (class$org$netbeans$modules$web$monitor$client$Controller = Controller.class$("org.netbeans.modules.web.monitor.client.Controller")) : class$org$netbeans$modules$web$monitor$client$Controller)).getString("MON_OK")};
            Object[] args = new Object[]{md.getServerName()};
            MessageFormat msgFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$Controller == null ? (class$org$netbeans$modules$web$monitor$client$Controller = Controller.class$("org.netbeans.modules.web.monitor.client.Controller")) : class$org$netbeans$modules$web$monitor$client$Controller)).getString("MON_Exec_server_no_host"));
            NotifyDescriptor noServerDialog = new NotifyDescriptor((Object)msgFormat.format(args), NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$Controller == null ? (class$org$netbeans$modules$web$monitor$client$Controller = Controller.class$("org.netbeans.modules.web.monitor.client.Controller")) : class$org$netbeans$modules$web$monitor$client$Controller)).getString("MON_Exec_server"), -1, 1, options, options[0]);
            DialogDisplayer.getDefault().notify(noServerDialog);
        }
        catch (IOException ioe) {
            Object[] options = new Object[]{NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$Controller == null ? (class$org$netbeans$modules$web$monitor$client$Controller = Controller.class$("org.netbeans.modules.web.monitor.client.Controller")) : class$org$netbeans$modules$web$monitor$client$Controller)).getString("MON_OK")};
            Object[] args = new Object[]{md.getServerAndPort()};
            MessageFormat msgFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$Controller == null ? (class$org$netbeans$modules$web$monitor$client$Controller = Controller.class$("org.netbeans.modules.web.monitor.client.Controller")) : class$org$netbeans$modules$web$monitor$client$Controller)).getString("MON_Exec_server_start"));
            NotifyDescriptor noServerDialog = new NotifyDescriptor((Object)msgFormat.format(args), NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$Controller == null ? (class$org$netbeans$modules$web$monitor$client$Controller = Controller.class$("org.netbeans.modules.web.monitor.client.Controller")) : class$org$netbeans$modules$web$monitor$client$Controller)).getString("MON_Exec_server"), -1, 1, options, options[0]);
            DialogDisplayer.getDefault().notify(noServerDialog);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void replayTransaction(MonitorData md) throws UnknownHostException, IOException {
        block34: {
            block32: {
                lock = null;
                out = null;
                pw = null;
                id = md.getAttributeValue("id");
                try {
                    fo = Controller.getReplayDir().createData(id, "xml");
                }
                catch (IOException ioex) {
                    block31: {
                        try {
                            fo = Controller.getReplayDir().getFileObject(id, "xml");
                        }
                        catch (IllegalArgumentException iaex) {
                            throw new IOException("No replay dir");
                        }
                        if (!fo.isData()) {
                            throw new IOException("Can't create file, giving up");
                        }
                        try {
                            lock = fo.lock();
                        }
                        catch (FileAlreadyLockedException falex) {
                            throw new IOException("Old file exist, islocked");
                        }
                        try {
                            fo.delete(lock);
                            var10_16 = null;
                            ** if (lock == null) goto lbl-1000
                        }
                        catch (Throwable var9_18) {
                            var10_17 = null;
                            if (lock != null) {
                                lock.releaseLock();
                            }
                            throw var9_18;
                        }
lbl-1000:
                        // 1 sources

                        {
                            lock.releaseLock();
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block31;
                            catch (IOException ioex2) {
                                throw new IOException("Couldn't delete old file");
                            }
                        }
                    }
                    fo = Controller.getReplayDir().createData(id, "xml");
                }
                try {
                    lock = fo.lock();
                }
                catch (FileAlreadyLockedException fale) {
                    throw new IOException();
                }
                out = fo.getOutputStream(lock);
                pw = new PrintWriter(out);
                md.write(pw);
                var12_19 = null;
                if (lock == null) break block32;
                lock.releaseLock();
            }
            try {
                pw.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (Throwable t) {}
            break block34;
            {
                catch (IOException ioex) {
                    throw ioex;
                }
            }
            catch (Throwable var11_23) {
                var12_20 = null;
                if (lock != null) {
                    lock.releaseLock();
                }
                try {
                    pw.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw var11_23;
            }
        }
        try {
            this.replayTransaction(md, "replay");
        }
        catch (UnknownHostException uhe) {
            throw uhe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public void replayTransaction(MonitorData md, String status) throws UnknownHostException, IOException {
        URL url = null;
        try {
            String name = md.getServerName();
            int port = md.getServerPort();
            StringBuffer uriBuf = new StringBuffer(128);
            uriBuf.append(md.getRequestData().getAttributeValue("uri"));
            uriBuf.append("?");
            uriBuf.append(REPLAY);
            uriBuf.append("=");
            uriBuf.append(md.getAttributeValue("id"));
            uriBuf.append("&");
            uriBuf.append(REPLAYSTATUS);
            uriBuf.append("=");
            uriBuf.append(status);
            String portS = null;
            try {
                portS = String.valueOf(HttpServer.getRepositoryRoot().getPort());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (portS != null) {
                uriBuf.append("&");
                uriBuf.append(PORT);
                uriBuf.append("=");
                uriBuf.append(portS);
            }
            if (md.getRequestData().getReplaceSessionCookie()) {
                uriBuf.append("&");
                uriBuf.append(REPLAYSESSION);
                uriBuf.append("=");
                uriBuf.append(md.getRequestData().getSessionID());
            }
            url = new URL("http", name, port, uriBuf.toString());
        }
        catch (MalformedURLException me) {
        }
        catch (NumberFormatException ne) {
            // empty catch block
        }
        try {
            this.showReplay(url);
        }
        catch (UnknownHostException uhe) {
            throw uhe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveTransaction(Node[] nodes) {
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return;
        }
        Node[] newNodes = new Node[nodes.length];
        boolean error = false;
        int i = 0;
        while (true) {
            block15: {
                Object var12_12;
                if (i >= nodes.length) {
                    if (!error) {
                        this.currTrans.remove(nodes);
                    }
                    this.savedTrans.add(newNodes);
                    return;
                }
                TransactionNode mvNode = (TransactionNode)nodes[i];
                String id = mvNode.getID();
                if (this.currBeans.containsKey(id)) {
                    this.saveBeans.put(id, this.currBeans.remove(id));
                }
                FileLock lock = null;
                try {
                    try {
                        FileObject fold = currDir.getFileObject(id, "xml");
                        lock = fold.lock();
                        fold.copy(saveDir, id, "xml");
                        fold.delete(lock);
                        mvNode.setCurrent(false);
                        newNodes[i] = mvNode;
                    }
                    catch (FileAlreadyLockedException falex) {
                        error = true;
                        var12_12 = null;
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        break block15;
                    }
                    catch (IOException ioex) {
                        error = true;
                        var12_12 = null;
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        break block15;
                    }
                    catch (Exception ex) {
                        error = true;
                        var12_12 = null;
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        break block15;
                    }
                    var12_12 = null;
                    if (lock == null) break block15;
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    throw throwable;
                }
                lock.releaseLock();
            }
            ++i;
        }
    }

    public void deleteTransaction(Node[] nodes) {
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return;
        }
        if (nodes == null || nodes.length == 0) {
            return;
        }
        TransactionNode n = null;
        int i = 0;
        while (i < nodes.length) {
            n = (TransactionNode)nodes[i];
            if (n.isCurrent()) {
                this.delete(n, this.currTrans, this.currBeans, true);
            } else {
                this.delete(n, this.savedTrans, this.saveBeans, false);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void delete(TransactionNode node, Children.SortedArray transactions, Hashtable beans, boolean current) {
        FileObject fold = null;
        FileLock lock = null;
        try {
            try {
                fold = current ? currDir.getFileObject(node.getID(), "xml") : saveDir.getFileObject(node.getID(), "xml");
                lock = fold.lock();
                fold.delete(lock);
                Node[] nodes = new Node[]{node};
                transactions.remove(nodes);
                beans.remove(node.getID());
            }
            catch (FileAlreadyLockedException ex) {
                Object var10_10 = null;
                if (lock == null) return;
                lock.releaseLock();
                return;
            }
            catch (IOException ex) {
                Object var10_11 = null;
                if (lock == null) return;
                lock.releaseLock();
                return;
            }
            Object var10_9 = null;
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (lock == null) throw throwable;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void deleteDirectory(String dir) {
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return;
        }
        FileObject directory = null;
        if (dir.equals(saveDirStr)) {
            directory = saveDir;
            this.savedTrans.remove(this.savedTrans.getNodes());
            this.saveBeans.clear();
        } else {
            directory = currDir;
            this.currTrans.remove(this.currTrans.getNodes());
            this.currBeans.clear();
        }
        FileLock lock = null;
        Enumeration e = directory.getData(false);
        while (e.hasMoreElements()) {
            Object var9_8;
            FileObject fo = (FileObject)e.nextElement();
            lock = null;
            try {
                try {
                    lock = fo.lock();
                    fo.delete(lock);
                }
                catch (FileAlreadyLockedException falex) {
                    var9_8 = null;
                    if (lock == null) continue;
                    lock.releaseLock();
                    continue;
                }
                catch (IOException IOex) {
                    var9_8 = null;
                    if (lock == null) continue;
                    lock.releaseLock();
                    continue;
                }
                var9_8 = null;
                if (lock == null) continue;
            }
            catch (Throwable throwable) {
                var9_8 = null;
                if (lock != null) {
                    lock.releaseLock();
                }
                throw throwable;
            }
            lock.releaseLock();
        }
        return;
    }

    void deleteTransactions() {
        this.deleteDirectory(saveDirStr);
        this.deleteDirectory(currDirStr);
        this.savedTrans.remove(this.savedTrans.getNodes());
        this.currTrans.remove(this.currTrans.getNodes());
    }

    void getTransactions() {
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return;
        }
        Enumeration e = null;
        Vector<TransactionNode> nodes = new Vector<TransactionNode>();
        int numtns = 0;
        TransactionNode[] tns = null;
        FileObject fo = null;
        String id = null;
        MonitorData md = null;
        this.currTrans.remove(this.currTrans.getNodes());
        e = currDir.getData(false);
        while (e.hasMoreElements()) {
            fo = (FileObject)e.nextElement();
            id = fo.getName();
            md = this.retrieveMonitorData(id, currDir);
            nodes.add(this.createTransactionNode(md, true));
        }
        numtns = nodes.size();
        tns = new TransactionNode[numtns];
        int i = 0;
        while (i < numtns) {
            tns[i] = (TransactionNode)((Object)nodes.elementAt(i));
            ++i;
        }
        this.currTrans.add((Node[])tns);
        this.savedTrans.remove(this.savedTrans.getNodes());
        nodes = new Vector();
        e = saveDir.getData(false);
        while (e.hasMoreElements()) {
            fo = (FileObject)e.nextElement();
            id = fo.getName();
            md = this.retrieveMonitorData(id, saveDir);
            nodes.add(this.createTransactionNode(md, false));
        }
        numtns = nodes.size();
        tns = new TransactionNode[numtns];
        int i2 = 0;
        while (i2 < numtns) {
            tns[i2] = (TransactionNode)((Object)nodes.elementAt(i2));
            ++i2;
        }
        this.savedTrans.add((Node[])tns);
    }

    private TransactionNode createTransactionNode(MonitorData md, boolean current) {
        Dispatches dis = md.getDispatches();
        TransactionNode node = null;
        if (dis == null || dis.sizeDispatchData() == 0) {
            node = new TransactionNode(md.getAttributeValue("id"), md.getAttributeValue("method"), md.getAttributeValue("resource"), current);
        } else {
            int numChildren = dis.sizeDispatchData();
            Children.Array nested = new Children.Array();
            NestedNode[] nds = new NestedNode[numChildren];
            int i = 0;
            while (i < numChildren) {
                nds[i] = this.createNestedNode(dis.getDispatchData(i), md.getAttributeValue("method"), null, i);
                ++i;
            }
            nested.add((Node[])nds);
            node = new TransactionNode(md.getAttributeValue("id"), md.getAttributeValue("method"), md.getAttributeValue("resource"), (Children)nested, current);
        }
        return node;
    }

    private NestedNode createNestedNode(DispatchData dd, String method, int[] locator, int index) {
        Dispatches dis = dd.getDispatches();
        NestedNode node = null;
        int[] newloc = null;
        if (locator != null) {
            newloc = new int[locator.length + 1];
            int j = 0;
            while (j < locator.length) {
                newloc[j] = locator[j];
                ++j;
            }
            newloc[j] = index;
        } else {
            newloc = new int[]{index};
        }
        if (dis == null || dis.sizeDispatchData() == 0) {
            node = new NestedNode(dd.getAttributeValue("resource"), method, newloc);
        } else {
            int numChildren = dis.sizeDispatchData();
            Children.Array nested = new Children.Array();
            NestedNode[] nds = new NestedNode[numChildren];
            int i = 0;
            while (i < numChildren) {
                nds[i] = this.createNestedNode(dis.getDispatchData(i), method, newloc, i);
                ++i;
            }
            nested.add((Node[])nds);
            node = new NestedNode(dd.getAttributeValue("resource"), method, (Children)nested, newloc);
        }
        return node;
    }

    public static void setServer(String loc, int p) {
        port = p;
        server = loc;
    }

    public void setComparator(Comparator comp) {
        this.currTrans.setComparator(comp);
        this.savedTrans.setComparator(comp);
    }

    public void setUseBrowserCookie(boolean value) {
        this.useBrowserCookie = value;
    }

    public boolean getUseBrowserCookie() {
        return this.useBrowserCookie;
    }

    public DataRecord getDataRecord(AbstractNode node) {
        return this.getDataRecord(node, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public DataRecord getDataRecord(AbstractNode anode, boolean fromCache) {
        block3: {
            if (anode instanceof TransactionNode) {
                return this.getMonitorData((TransactionNode)anode, fromCache, true);
            }
            if (!(anode instanceof NestedNode)) break block3;
            node = (NestedNode)anode;
            index = node.getIndex();
            parent = (AbstractNode)node.getParentNode();
            if (parent != null) ** GOTO lbl10
            return null;
lbl-1000:
            // 1 sources

            {
                parent = (AbstractNode)parent.getParentNode();
lbl10:
                // 2 sources

                ** while (parent != null && !(parent instanceof TransactionNode))
            }
lbl11:
            // 1 sources

            dr /* !! */  = this.getMonitorData((TransactionNode)parent, true, true);
            nodeindex = node.getIndex();
            c = 0;
            while (c < nodeindex.length) {
                dis = dr /* !! */ .getDispatches();
                dr /* !! */  = dis.getDispatchData(nodeindex[c]);
                ++c;
            }
            return dr /* !! */ ;
        }
        return null;
    }

    public MonitorData getMonitorData(TransactionNode node, boolean fromCache, boolean cacheIt) {
        String id = node.getID();
        Hashtable ht = null;
        FileObject dir = null;
        if (node.isCurrent()) {
            ht = this.currBeans;
            dir = currDir;
        } else {
            ht = this.saveBeans;
            dir = saveDir;
        }
        if (fromCache && ht.containsKey(id)) {
            return (MonitorData)ht.get(id);
        }
        MonitorData md = this.retrieveMonitorData(id, dir);
        if (cacheIt) {
            ht.put(id, md);
        }
        return md;
    }

    MonitorData retrieveMonitorData(String id, String dirS) {
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return null;
        }
        FileObject dir = null;
        if (dirS.equalsIgnoreCase(currDirStr)) {
            dir = currDir;
        } else if (dirS.equalsIgnoreCase(saveDirStr)) {
            dir = saveDir;
        } else if (dirS.equalsIgnoreCase(replayDirStr)) {
            dir = replayDir;
        }
        return this.retrieveMonitorData(id, dir);
    }

    /*
     * Loose catch block
     */
    MonitorData retrieveMonitorData(String id, FileObject dir) {
        MonitorData md;
        block23: {
            if (!this.haveDirectories()) {
                Controller.log("Couldn't get the directory");
                return null;
            }
            md = null;
            FileObject fo = null;
            FileLock lock = null;
            InputStreamReader in = null;
            fo = dir.getFileObject(id, "xml");
            lock = fo.lock();
            in = new InputStreamReader(fo.getInputStream());
            md = MonitorData.createGraph(in);
            try {
                if (dir == replayDir) {
                    fo.delete(lock);
                }
            }
            catch (IOException ioex2) {
            }
            Object var11_9 = null;
            try {
                in.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (lock != null) {
                lock.releaseLock();
            }
            break block23;
            {
                catch (FileAlreadyLockedException falex) {
                    Object var11_10 = null;
                    try {
                        in.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    break block23;
                }
                catch (IOException ioex) {
                    Object var11_11 = null;
                    try {
                        in.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    break block23;
                }
                catch (Exception ex) {
                    Object var11_12 = null;
                    try {
                        in.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    in.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (lock != null) {
                    lock.releaseLock();
                }
                throw throwable;
            }
        }
        return md;
    }

    private void showReplay(URL url) throws UnknownHostException, IOException {
        ServerCheck sc = new ServerCheck(url.getHost());
        Thread t = new Thread(sc);
        t.start();
        try {
            t.join(2000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        t = null;
        if (!sc.isServerGood()) {
            throw new UnknownHostException();
        }
        try {
            Socket server = new Socket(url.getHost(), url.getPort());
            server.close();
            server = null;
        }
        catch (UnknownHostException uhe) {
            throw uhe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        if (this.browser == null) {
            this.browser = new HtmlBrowser.BrowserComponent(this.getFactory(), true, true);
        }
        if (this.browser != null) {
            this.browser.setURL(url);
            this.browser.open();
            if (!this.browser.isShowing()) {
                this.browser.setVisible(true);
            }
        }
    }

    private HtmlBrowser.Factory getFactory() {
        try {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Services/Browsers");
            DataFolder folder = DataFolder.findFolder((FileObject)fo);
            DataObject[] dobjs = folder.getChildren();
            int i = 0;
            while (i < dobjs.length) {
                Object attr = dobjs[i].getPrimaryFile().getAttribute("DEFAULT_BROWSER");
                if (attr instanceof Boolean && Boolean.TRUE.equals(attr)) {
                    try {
                        Object factory = ((InstanceCookie)dobjs[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = Controller.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie)).instanceCreate();
                        return (HtmlBrowser.Factory)factory;
                    }
                    catch (IOException ex) {
                    }
                    catch (ClassNotFoundException ex) {
                        // empty catch block
                    }
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < dobjs.length) {
                Object attr = dobjs[i2].getPrimaryFile().getAttribute("hidden");
                if (!Boolean.TRUE.equals(attr)) {
                    try {
                        Object factory = ((InstanceCookie)dobjs[i2].getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = Controller.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie)).instanceCreate();
                        return (HtmlBrowser.Factory)factory;
                    }
                    catch (IOException ex) {
                    }
                    catch (ClassNotFoundException ex) {
                        // empty catch block
                    }
                }
                ++i2;
            }
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$awt$HtmlBrowser$Factory == null ? (class$org$openide$awt$HtmlBrowser$Factory = Controller.class$("org.openide.awt.HtmlBrowser$Factory")) : class$org$openide$awt$HtmlBrowser$Factory));
            Iterator it = result.allInstances().iterator();
            if (it.hasNext()) {
                return (HtmlBrowser.Factory)it.next();
            }
            return null;
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return null;
        }
    }

    private void registerBrowserListener() {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Services/org-netbeans-core-IDESettings.settings");
        if (fo != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                InstanceCookie.Of ic = (InstanceCookie.Of)dobj.getCookie(class$org$openide$cookies$InstanceCookie$Of == null ? (class$org$openide$cookies$InstanceCookie$Of = Controller.class$("org.openide.cookies.InstanceCookie$Of")) : class$org$openide$cookies$InstanceCookie$Of);
                if (ic.instanceOf(class$org$openide$options$SystemOption == null ? (class$org$openide$options$SystemOption = Controller.class$("org.openide.options.SystemOption")) : class$org$openide$options$SystemOption)) {
                    try {
                        this.settings = (SystemOption)ic.instanceCreate();
                        this.browserListener = new SettingsListener(this.settings);
                        this.settings.addPropertyChangeListener((PropertyChangeListener)this.browserListener);
                    }
                    catch (IOException ex) {
                    }
                    catch (ClassNotFoundException ex) {}
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    private void removeBrowserListener() {
        if (this.settings == null || this.browserListener == null) {
            return;
        }
        try {
            this.settings.removePropertyChangeListener((PropertyChangeListener)this.browserListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void log(String s) {
        System.out.println("Controller::" + s);
    }

    boolean checkServer(boolean replay) {
        try {
            HttpServer.getRepositoryRoot();
            return true;
        }
        catch (Throwable t) {
            Object[] options = new Object[]{NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$Controller == null ? (class$org$netbeans$modules$web$monitor$client$Controller = Controller.class$("org.netbeans.modules.web.monitor.client.Controller")) : class$org$netbeans$modules$web$monitor$client$Controller)).getString("MON_OK")};
            String msg = null;
            msg = replay ? NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$Controller == null ? (class$org$netbeans$modules$web$monitor$client$Controller = Controller.class$("org.netbeans.modules.web.monitor.client.Controller")) : class$org$netbeans$modules$web$monitor$client$Controller)).getString("MON_CantReplay") : NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$Controller == null ? (class$org$netbeans$modules$web$monitor$client$Controller = Controller.class$("org.netbeans.modules.web.monitor.client.Controller")) : class$org$netbeans$modules$web$monitor$client$Controller)).getString("MON_NoServer");
            NotifyDescriptor noServerDialog = new NotifyDescriptor((Object)msg, NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$Controller == null ? (class$org$netbeans$modules$web$monitor$client$Controller = Controller.class$("org.netbeans.modules.web.monitor.client.Controller")) : class$org$netbeans$modules$web$monitor$client$Controller)).getString("MON_NoServerTitle"), -1, 1, options, options[0]);
            DialogDisplayer.getDefault().notify(noServerDialog);
            return false;
        }
    }

    public void updateNodeNames() {
        TransactionNode tn;
        Node[] nodes = this.currTrans.getNodes();
        int size = nodes.length;
        int i = 0;
        while (i < size) {
            tn = (TransactionNode)nodes[i];
            tn.setNameString();
            ++i;
        }
        nodes = this.savedTrans.getNodes();
        size = nodes.length;
        int i2 = 0;
        while (i2 < size) {
            tn = (TransactionNode)nodes[i2];
            tn.setNameString();
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$000(String x0) {
        Controller.log(x0);
    }

    class CompAlpha
    implements Comparator {
        CompAlpha() {
        }

        public int compare(Object o1, Object o2) {
            TransactionNode n1 = (TransactionNode)((Object)o1);
            TransactionNode n2 = (TransactionNode)((Object)o2);
            int diff = ((FeatureDescriptor)((Object)n1)).getName().compareTo(((FeatureDescriptor)((Object)n2)).getName());
            if (diff == 0) {
                return n1.getID().compareTo(n2.getID());
            }
            return diff;
        }
    }

    class CompTime
    implements Comparator {
        boolean descend = true;

        CompTime(boolean descend) {
            this.descend = descend;
        }

        public int compare(Object o1, Object o2) {
            TransactionNode n1 = (TransactionNode)((Object)o1);
            TransactionNode n2 = (TransactionNode)((Object)o2);
            int result = this.descend ? n1.getID().compareTo(n2.getID()) : n2.getID().compareTo(n1.getID());
            return result;
        }
    }

    class ServerCheck
    implements Runnable {
        boolean serverGood = false;
        String serverName = null;

        public ServerCheck(String name) {
            this.serverName = name;
        }

        public void run() {
            try {
                InetAddress.getByName(this.serverName);
                this.serverGood = true;
            }
            catch (UnknownHostException e) {
                this.serverGood = false;
            }
        }

        public boolean isServerGood() {
            return this.serverGood;
        }
    }

    class SettingsListener
    implements PropertyChangeListener {
        private SystemOption source;

        public SettingsListener(SystemOption source) {
            this.source = source;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("WWWBrowser".equals(evt.getPropertyName())) {
                Controller.this.browser = null;
            }
        }
    }
}

