/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.monitor.client.EditPanelCookies;
import org.netbeans.modules.web.monitor.client.EditPanelHeaders;
import org.netbeans.modules.web.monitor.client.EditPanelQuery;
import org.netbeans.modules.web.monitor.client.EditPanelRequest;
import org.netbeans.modules.web.monitor.client.EditPanelServer;
import org.netbeans.modules.web.monitor.client.MonitorAction;
import org.netbeans.modules.web.monitor.client.TransactionView;
import org.netbeans.modules.web.monitor.client.Util;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.ToolbarToggleButton;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class EditPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final boolean debug = false;
    private int displayType = 0;
    private static final int DISPLAY_TYPE_QUERY = 0;
    private static final int DISPLAY_TYPE_REQUEST = 1;
    private static final int DISPLAY_TYPE_COOKIES = 2;
    private static final int DISPLAY_TYPE_SERVER = 3;
    private static final int DISPLAY_TYPE_HEADERS = 4;
    private transient Dimension tabD = new Dimension(450, 280);
    private EditPanelQuery queryPanel;
    private EditPanelRequest requestPanel;
    private EditPanelCookies cookiesPanel;
    private EditPanelServer serverPanel;
    private EditPanelHeaders headersPanel;
    private MonitorData monitorData = null;
    private Dialog dialog = null;
    private DialogDescriptor editDialog = null;
    private JButton sendButton;
    private JButton okButton;
    private JButton cancelButton;
    private ToolbarToggleButton browserCookieButton;
    private ToolbarToggleButton savedCookieButton;
    private static boolean useBrowserCookie = true;
    public static final String METHOD = "method";
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    static /* synthetic */ Class class$org$netbeans$modules$web$monitor$client$EditPanel;

    public EditPanel(MonitorData md) {
        this.monitorData = md;
        this.createDataPanel(md);
        this.createDialogButtons();
    }

    public void createDataPanel(MonitorData md) {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        if (md.getRequestData().getAttributeValue(METHOD).equals(POST)) {
            Util.removeParametersFromQuery(md.getRequestData());
        }
        this.queryPanel = new EditPanelQuery(md, this);
        this.requestPanel = new EditPanelRequest(md, this);
        this.cookiesPanel = new EditPanelCookies(md, this);
        this.serverPanel = new EditPanelServer(md, this);
        this.headersPanel = new EditPanelHeaders(md, this);
        JTabbedPane tabs = new JTabbedPane();
        tabs.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("ACS_MON_Replay_tabsName"));
        tabs.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("ACS_MON_Replay_tabsDesc"));
        tabs.setPreferredSize(this.tabD);
        tabs.addTab(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Query_Panel_Tab"), this.queryPanel);
        tabs.addTab(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Request_Panel_Tab"), this.requestPanel);
        tabs.addTab(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Cookies_Panel_Tab"), this.cookiesPanel);
        tabs.addTab(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Server_Panel_Tab"), this.serverPanel);
        tabs.addTab(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Headers_Panel_Tab"), this.headersPanel);
        tabs.addChangeListener(this);
        this.add(tabs);
        this.add(Box.createGlue());
        this.add(Box.createVerticalStrut(5));
        this.setMaximumSize(this.getPreferredSize());
    }

    public void setData(MonitorData md) {
        this.monitorData = md;
        this.queryPanel.setData(md);
        this.requestPanel.setData(md);
        this.cookiesPanel.setData(md);
        this.serverPanel.setData(md);
        this.headersPanel.setData(md);
        useBrowserCookie = MonitorAction.getController().getUseBrowserCookie();
    }

    public void showDialog() {
        Object[] options = new Object[]{this.createSessionButtonPanel(), this.sendButton, this.cancelButton};
        this.editDialog = new DialogDescriptor((Object)this, NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_EditReplay"), false, options, options[1], 0, new HelpCtx("monitor_resend"), (ActionListener)this);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.editDialog);
        this.dialog.pack();
        this.dialog.show();
    }

    public void actionPerformed(ActionEvent e) {
        boolean debug = false;
        if (debug) {
            this.log("actionPerformed()");
        }
        String str = new String();
        Object value = this.editDialog.getValue();
        if (value == null) {
            return;
        }
        str = value instanceof JButton ? ((JButton)value).getText() : value.toString();
        if (str.equals(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Send"))) {
            String method;
            if (debug) {
                this.log(" got SEND");
            }
            if ((method = this.monitorData.getRequestData().getAttributeValue(METHOD)).equals(GET)) {
                Util.composeQueryString(this.monitorData.getRequestData());
            }
            if (debug) {
                this.log(" useBrowserCookie is " + String.valueOf(useBrowserCookie));
            }
            if (!useBrowserCookie) {
                this.monitorData.getRequestData().setReplaceSessionCookie(true);
            }
            if (debug) {
                this.log(" md.getRD.getReplace is " + String.valueOf(this.monitorData.getRequestData().getReplaceSessionCookie()));
            }
            try {
                MonitorAction.getController().replayTransaction(this.monitorData);
                this.dialog.dispose();
            }
            catch (UnknownHostException uhe) {
                Object[] options = new Object[]{this.okButton};
                Object[] args = new Object[]{this.monitorData.getServerName()};
                MessageFormat msgFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Exec_server_wrong"));
                NotifyDescriptor noServerDialog = new NotifyDescriptor((Object)msgFormat.format(args), NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Exec_server"), -1, 1, options, options[0]);
                DialogDisplayer.getDefault().notify(noServerDialog);
                this.displayType = 3;
                this.showData();
            }
            catch (IOException ioe) {
                Object[] options = new Object[]{NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_OK")};
                Object[] args = new Object[]{this.monitorData.getServerName(), this.monitorData.getServerPortAsString()};
                MessageFormat msgFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Exec_server_start"));
                NotifyDescriptor noServerDialog = new NotifyDescriptor((Object)msgFormat.format(args), NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Exec_server"), -1, 1, options, options[0]);
                DialogDisplayer.getDefault().notify(noServerDialog);
            }
        } else if (str.equals(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Cancel"))) {
            this.dialog.dispose();
        }
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane p = (JTabbedPane)e.getSource();
        this.displayType = p.getSelectedIndex();
        this.showData();
    }

    void showData() {
        if (this.displayType == 0) {
            this.queryPanel.setData(this.monitorData);
        } else if (this.displayType == 1) {
            this.requestPanel.setData(this.monitorData);
        } else if (this.displayType == 2) {
            this.cookiesPanel.setData(this.monitorData);
        } else if (this.displayType == 3) {
            this.serverPanel.setData(this.monitorData);
        } else if (this.displayType == 4) {
            this.headersPanel.setData(this.monitorData);
        }
    }

    private void createDialogButtons() {
        this.sendButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Send"));
        this.sendButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Send_Mnemonic").charAt(0));
        this.sendButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("ACS_MON_SendA11yDesc"));
        this.okButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_OK"));
        this.okButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_OK_Mnemonic").charAt(0));
        this.okButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("ACS_MON_OKA11yDesc"));
        this.cancelButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Cancel"));
        this.cancelButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Cancel_Mnemonic").charAt(0));
        this.cancelButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("ACS_MON_CancelA11yDesc"));
    }

    private JToolBar createSessionButtonPanel() {
        JToolBar buttonPanel = new JToolBar();
        buttonPanel.setFloatable(false);
        this.browserCookieButton = new ToolbarToggleButton(TransactionView.browserCookieIcon, useBrowserCookie);
        this.browserCookieButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Browser_cookie"));
        this.browserCookieButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditPanel.this.browserCookieButton.setSelected(true);
                EditPanel.this.savedCookieButton.setSelected(false);
                useBrowserCookie = true;
            }
        });
        this.savedCookieButton = new ToolbarToggleButton(TransactionView.savedCookieIcon, !useBrowserCookie);
        this.savedCookieButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$EditPanel == null ? (class$org$netbeans$modules$web$monitor$client$EditPanel = EditPanel.class$("org.netbeans.modules.web.monitor.client.EditPanel")) : class$org$netbeans$modules$web$monitor$client$EditPanel)).getString("MON_Saved_cookie"));
        this.savedCookieButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditPanel.this.savedCookieButton.setSelected(true);
                EditPanel.this.browserCookieButton.setSelected(false);
                useBrowserCookie = false;
            }
        });
        buttonPanel.add((Component)this.browserCookieButton);
        buttonPanel.add((Component)this.savedCookieButton);
        buttonPanel.setSize(buttonPanel.getMinimumSize());
        return buttonPanel;
    }

    private Component createSeparator() {
        JPanel sep = new JPanel(){

            public float getAlignmentX() {
                return 0.0f;
            }

            public float getAlignmentY() {
                return 0.0f;
            }
        };
        sep.setMinimumSize(new Dimension(10, 10));
        return sep;
    }

    private void log(String s) {
        System.out.println("EditPanel::" + s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

