/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.beans.FeatureDescriptor;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.actions.SystemAction;

public class TransactionNode
extends AbstractNode {
    String id;
    String method;
    String uri;
    String name = null;
    String timestamp = null;
    boolean current;
    static boolean showTimeStamp = true;
    static /* synthetic */ Class class$org$netbeans$modules$web$monitor$client$DisplayAction;
    static /* synthetic */ Class class$org$netbeans$modules$web$monitor$client$SaveAction;
    static /* synthetic */ Class class$org$netbeans$modules$web$monitor$client$ReplayAction;
    static /* synthetic */ Class class$org$netbeans$modules$web$monitor$client$EditReplayAction;
    static /* synthetic */ Class class$org$netbeans$modules$web$monitor$client$DeleteAction;

    public TransactionNode(String id, String method, String uri, boolean current) {
        super(Children.LEAF);
        this.id = id;
        this.method = method;
        this.uri = uri;
        this.current = current;
        this.setProperties();
    }

    public TransactionNode(String id, String method, String uri, Children ch, boolean current) {
        super(ch);
        this.id = id;
        this.method = method;
        this.uri = uri;
        this.current = current;
        this.setProperties();
    }

    public String getLongName() {
        StringBuffer buf = new StringBuffer(this.method);
        buf.append(" ");
        buf.append(this.uri);
        if (this.timestamp == null) {
            this.setTimeStamp();
        }
        buf.append(" ");
        buf.append(this.timestamp);
        return buf.toString();
    }

    public String getID() {
        return this.id;
    }

    public String getMethod() {
        return this.method;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean b) {
        this.current = b;
    }

    protected SystemAction[] createActions() {
        if (this.current) {
            return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$DisplayAction == null ? (class$org$netbeans$modules$web$monitor$client$DisplayAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.DisplayAction")) : class$org$netbeans$modules$web$monitor$client$DisplayAction)), SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$SaveAction == null ? (class$org$netbeans$modules$web$monitor$client$SaveAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.SaveAction")) : class$org$netbeans$modules$web$monitor$client$SaveAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$ReplayAction == null ? (class$org$netbeans$modules$web$monitor$client$ReplayAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.ReplayAction")) : class$org$netbeans$modules$web$monitor$client$ReplayAction)), SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$EditReplayAction == null ? (class$org$netbeans$modules$web$monitor$client$EditReplayAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.EditReplayAction")) : class$org$netbeans$modules$web$monitor$client$EditReplayAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$DeleteAction == null ? (class$org$netbeans$modules$web$monitor$client$DeleteAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.DeleteAction")) : class$org$netbeans$modules$web$monitor$client$DeleteAction))};
        }
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$DisplayAction == null ? (class$org$netbeans$modules$web$monitor$client$DisplayAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.DisplayAction")) : class$org$netbeans$modules$web$monitor$client$DisplayAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$ReplayAction == null ? (class$org$netbeans$modules$web$monitor$client$ReplayAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.ReplayAction")) : class$org$netbeans$modules$web$monitor$client$ReplayAction)), SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$EditReplayAction == null ? (class$org$netbeans$modules$web$monitor$client$EditReplayAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.EditReplayAction")) : class$org$netbeans$modules$web$monitor$client$EditReplayAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$DeleteAction == null ? (class$org$netbeans$modules$web$monitor$client$DeleteAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.DeleteAction")) : class$org$netbeans$modules$web$monitor$client$DeleteAction))};
    }

    public SystemAction[] getActions() {
        if (this.current) {
            return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$DisplayAction == null ? (class$org$netbeans$modules$web$monitor$client$DisplayAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.DisplayAction")) : class$org$netbeans$modules$web$monitor$client$DisplayAction)), SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$SaveAction == null ? (class$org$netbeans$modules$web$monitor$client$SaveAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.SaveAction")) : class$org$netbeans$modules$web$monitor$client$SaveAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$ReplayAction == null ? (class$org$netbeans$modules$web$monitor$client$ReplayAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.ReplayAction")) : class$org$netbeans$modules$web$monitor$client$ReplayAction)), SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$EditReplayAction == null ? (class$org$netbeans$modules$web$monitor$client$EditReplayAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.EditReplayAction")) : class$org$netbeans$modules$web$monitor$client$EditReplayAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$DeleteAction == null ? (class$org$netbeans$modules$web$monitor$client$DeleteAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.DeleteAction")) : class$org$netbeans$modules$web$monitor$client$DeleteAction))};
        }
        return new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$DisplayAction == null ? (class$org$netbeans$modules$web$monitor$client$DisplayAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.DisplayAction")) : class$org$netbeans$modules$web$monitor$client$DisplayAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$ReplayAction == null ? (class$org$netbeans$modules$web$monitor$client$ReplayAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.ReplayAction")) : class$org$netbeans$modules$web$monitor$client$ReplayAction)), SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$EditReplayAction == null ? (class$org$netbeans$modules$web$monitor$client$EditReplayAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.EditReplayAction")) : class$org$netbeans$modules$web$monitor$client$EditReplayAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$DeleteAction == null ? (class$org$netbeans$modules$web$monitor$client$DeleteAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.DeleteAction")) : class$org$netbeans$modules$web$monitor$client$DeleteAction))};
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    public static void toggleTimeStamp() {
        showTimeStamp = !showTimeStamp;
    }

    public static boolean showTimeStamp() {
        return showTimeStamp;
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$web$monitor$client$DisplayAction == null ? (class$org$netbeans$modules$web$monitor$client$DisplayAction = TransactionNode.class$("org.netbeans.modules.web.monitor.client.DisplayAction")) : class$org$netbeans$modules$web$monitor$client$DisplayAction));
    }

    private void setProperties() {
        if (this.method.equals("GET")) {
            this.setIconBase("org/netbeans/modules/web/monitor/client/icons/get");
        } else if (this.method.equals("POST")) {
            this.setIconBase("org/netbeans/modules/web/monitor/client/icons/post");
        } else {
            this.setIconBase("org/netbeans/modules/web/monitor/client/icons/other");
        }
        this.setNameString();
        this.setShortDescription(this.uri);
    }

    public void setNameString() {
        String name = null;
        if (this.uri.equals("/")) {
            name = this.uri;
        } else {
            StringTokenizer st = new StringTokenizer(this.uri, "/");
            while (st.hasMoreTokens()) {
                name = st.nextToken();
            }
        }
        StringBuffer buf = new StringBuffer(this.method);
        buf.append(" ");
        buf.append(name);
        if (showTimeStamp) {
            if (this.timestamp == null) {
                this.setTimeStamp();
            }
            buf.append(" ");
            buf.append(this.timestamp);
        }
        this.setName(buf.toString());
    }

    private void setTimeStamp() {
        try {
            long ldate = Long.valueOf(this.id);
            Date date = new Date(ldate);
            StringBuffer buf = new StringBuffer("[");
            DateFormat df = DateFormat.getTimeInstance(3);
            buf.append(df.format(date));
            buf.append(" ");
            df = DateFormat.getDateInstance(3);
            buf.append(df.format(date));
            buf.append("]");
            this.timestamp = buf.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("TransactionNode: ");
        buf.append(((FeatureDescriptor)((Object)this)).getName());
        buf.append("\n");
        buf.append("id=");
        buf.append(this.id);
        buf.append("\n");
        buf.append("method=");
        buf.append(this.method);
        buf.append("\n");
        buf.append("uri=");
        buf.append(this.uri);
        buf.append("\n");
        buf.append("current=");
        buf.append(String.valueOf(this.current));
        buf.append("\n");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

