/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.monitor.client.ClientDisplay;
import org.netbeans.modules.web.monitor.client.ContextDisplay;
import org.netbeans.modules.web.monitor.client.Controller;
import org.netbeans.modules.web.monitor.client.CookieDisplay;
import org.netbeans.modules.web.monitor.client.CurrNode;
import org.netbeans.modules.web.monitor.client.DeleteAction;
import org.netbeans.modules.web.monitor.client.DisplayAction;
import org.netbeans.modules.web.monitor.client.EditPanel;
import org.netbeans.modules.web.monitor.client.EditReplayAction;
import org.netbeans.modules.web.monitor.client.HeaderDisplay;
import org.netbeans.modules.web.monitor.client.NavigateNode;
import org.netbeans.modules.web.monitor.client.NestedNode;
import org.netbeans.modules.web.monitor.client.RequestDisplay;
import org.netbeans.modules.web.monitor.client.SaveAction;
import org.netbeans.modules.web.monitor.client.SavedNode;
import org.netbeans.modules.web.monitor.client.ServletDisplay;
import org.netbeans.modules.web.monitor.client.SessionDisplay;
import org.netbeans.modules.web.monitor.client.TransactionNode;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.openide.awt.ToolbarButton;
import org.openide.awt.ToolbarToggleButton;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.Workspace;

public class TransactionView
extends ExplorerPanel
implements PropertyChangeListener,
ChangeListener {
    private static Controller controller = null;
    private transient JLabel transactionTitle = null;
    private transient ToolbarToggleButton timeAButton;
    private transient ToolbarToggleButton timeDButton;
    private transient ToolbarToggleButton alphaButton;
    private transient ToolbarToggleButton browserCookieButton;
    private transient ToolbarToggleButton savedCookieButton;
    private transient Dimension logD = new Dimension(250, 400);
    private transient Dimension dataD = new Dimension(500, 400);
    private transient Dimension tabD = new Dimension(500, 472);
    private static final transient boolean debug = false;
    private static transient ExplorerManager mgr = null;
    private transient JPanel logPanel = null;
    private transient JPanel dataPanel = null;
    private transient JSplitPane splitPanel = null;
    private transient double dividerPosition = 0.35;
    private transient BeanTreeView tree = null;
    private transient AbstractNode selected = null;
    private transient RequestDisplay requestDisplay = null;
    private transient CookieDisplay cookieDisplay = null;
    private transient SessionDisplay sessionDisplay = null;
    private transient ServletDisplay servletDisplay = null;
    private transient ContextDisplay contextDisplay = null;
    private transient ClientDisplay clientDisplay = null;
    private transient HeaderDisplay headerDisplay = null;
    private transient EditPanel editPanel = null;
    private int displayType = 0;
    protected static Icon updateIcon;
    protected static Icon a2zIcon;
    protected static Icon timesortAIcon;
    protected static Icon timesortDIcon;
    protected static Icon timestampIcon;
    protected static Icon browserCookieIcon;
    protected static Icon savedCookieIcon;
    protected static ImageIcon frameIcon;
    private boolean openedOnceAlready = false;
    static /* synthetic */ Class class$org$netbeans$modules$web$monitor$client$TransactionView;

    public HelpCtx getHelpCtx() {
        String helpID = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Transaction_View_F1_Help_ID");
        return new HelpCtx(helpID);
    }

    public TransactionView(Controller c) {
        this.setIcon(frameIcon.getImage());
        controller = c;
        this.initialize();
        DisplayAction.setTransactionView(this);
        SaveAction.setTransactionView(this);
        EditReplayAction.setTransactionView(this);
        DeleteAction.setTransactionView(this);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("ACS_MON_monitorDesc"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("ACS_MON_monitorName"));
    }

    private void initialize() {
        mgr = this.getExplorerManager();
        mgr.addPropertyChangeListener((PropertyChangeListener)this);
        mgr.setRootContext((Node)controller.getRoot());
        this.tree = new BeanTreeView();
        this.tree.setDefaultActionAllowed(true);
        this.tree.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("ACS_MON_treeName"));
        this.tree.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("ACS_MON_treeDesc"));
        this.createLogPanel();
        this.createDataPanel();
        this.splitPanel = new JSplitPane(1, this.logPanel, this.dataPanel);
        this.splitPanel.setDividerLocation(this.dividerPosition);
        this.splitPanel.setResizeWeight(this.dividerPosition);
        this.splitPanel.setDividerSize(1);
        this.splitPanel.setOneTouchExpandable(true);
        ((Container)((Object)this)).add(this.splitPanel);
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Title"));
    }

    public void openTransactionNodes() {
        OpenTransactionNodesRequest req = new OpenTransactionNodesRequest();
        RequestProcessor.Task task = RequestProcessor.postRequest((Runnable)req, (int)500);
    }

    public void selectNode(Node n) {
        try {
            mgr.setSelectedNodes(new Node[]{n});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void open(Workspace w) {
        if (w == null) {
            super.open();
        }
        super.open(w);
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Title"));
        if (!this.openedOnceAlready) {
            this.openedOnceAlready = true;
            controller.getTransactions();
            this.openTransactionNodes();
            FontMetrics fm = ((JComponent)((Object)this)).getGraphics().getFontMetrics();
            double logWidth = (double)fm.stringWidth(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Transactions_27")) * 1.1;
            if (logWidth > this.logD.getWidth()) {
                double factor = logWidth / this.logD.getWidth();
                this.logD.setSize(logWidth, factor * this.logD.getHeight());
                this.logPanel.setPreferredSize(this.logD);
                this.dataD.setSize(factor * this.dataD.getWidth(), factor * this.dataD.getHeight());
                this.dataPanel.setPreferredSize(this.dataD);
                this.splitPanel.resetToPreferredSizes();
                try {
                    Container o = ((Component)((Object)this)).getParent();
                    while (true) {
                        if (o instanceof JFrame) {
                            JFrame parent = (JFrame)o;
                            parent.pack();
                            break;
                        }
                        o = o.getParent();
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        controller.checkServer(false);
        this.requestFocus();
    }

    protected void updateTitle() {
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Title"));
    }

    public boolean canClose(Workspace w, boolean last) {
        return true;
    }

    public Object writeReplace() throws ObjectStreamException {
        return null;
    }

    private void createLogPanel() {
        JLabel title = new JLabel(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Transactions_27"), 0);
        title.setBorder(new EtchedBorder(1));
        JToolBar buttonPanel = new JToolBar();
        buttonPanel.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(4, 4, 4, 4)));
        buttonPanel.setFloatable(false);
        ToolbarButton updateButton = new ToolbarButton(updateIcon);
        updateButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Reload_all_17"));
        updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                controller.getTransactions();
            }
        });
        this.timeAButton = new ToolbarToggleButton(timesortAIcon, false);
        this.timeAButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Order_transactions_15"));
        this.timeAButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!((ToolbarToggleButton)e.getSource()).isSelected()) {
                    return;
                }
                TransactionView.this.timeDButton.setSelected(false);
                TransactionView.this.alphaButton.setSelected(false);
                controller.setComparator(controller.new Controller.CompTime(false));
            }
        });
        this.timeDButton = new ToolbarToggleButton(timesortDIcon, true);
        this.timeDButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Order_transactions_16"));
        this.timeDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!((ToolbarToggleButton)e.getSource()).isSelected()) {
                    return;
                }
                TransactionView.this.timeAButton.setSelected(false);
                TransactionView.this.alphaButton.setSelected(false);
                controller.setComparator(controller.new Controller.CompTime(true));
            }
        });
        this.alphaButton = new ToolbarToggleButton(a2zIcon, false);
        this.alphaButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Order_transactions_14"));
        this.alphaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!((ToolbarToggleButton)e.getSource()).isSelected()) {
                    return;
                }
                TransactionView.this.timeAButton.setSelected(false);
                TransactionView.this.timeDButton.setSelected(false);
                controller.setComparator(controller.new Controller.CompAlpha());
            }
        });
        this.browserCookieButton = new ToolbarToggleButton(browserCookieIcon, true);
        this.browserCookieButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Browser_cookie"));
        this.browserCookieButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransactionView.this.browserCookieButton.setSelected(true);
                TransactionView.this.savedCookieButton.setSelected(false);
                controller.setUseBrowserCookie(true);
            }
        });
        this.savedCookieButton = new ToolbarToggleButton(savedCookieIcon, false);
        this.savedCookieButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Saved_cookie"));
        this.savedCookieButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransactionView.this.browserCookieButton.setSelected(false);
                TransactionView.this.savedCookieButton.setSelected(true);
                controller.setUseBrowserCookie(false);
            }
        });
        ToolbarToggleButton timestampButton = new ToolbarToggleButton(timestampIcon, TransactionNode.showTimeStamp());
        timestampButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Show_time_25"));
        timestampButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransactionNode.toggleTimeStamp();
                controller.updateNodeNames();
            }
        });
        buttonPanel.add((Component)updateButton);
        JPanel sep = new JPanel(){

            public float getAlignmentX() {
                return 0.0f;
            }

            public float getAlignmentY() {
                return 0.0f;
            }
        };
        sep.setMaximumSize(new Dimension(10, 10));
        buttonPanel.add((Component)this.timeDButton);
        buttonPanel.add((Component)this.timeAButton);
        buttonPanel.add((Component)this.alphaButton);
        sep = new JPanel(){

            public float getAlignmentX() {
                return 0.0f;
            }

            public float getAlignmentY() {
                return 0.0f;
            }
        };
        sep.setMaximumSize(new Dimension(10, 10));
        buttonPanel.add(sep);
        buttonPanel.add((Component)this.browserCookieButton);
        buttonPanel.add((Component)this.savedCookieButton);
        sep = new JPanel(){

            public float getAlignmentX() {
                return 0.0f;
            }

            public float getAlignmentY() {
                return 0.0f;
            }
        };
        sep.setMaximumSize(new Dimension(10, 10));
        buttonPanel.add(sep);
        buttonPanel.add((Component)timestampButton);
        this.logPanel = new JPanel();
        this.logPanel.setLayout(new BorderLayout());
        this.logPanel.add((Component)title, "North");
        JPanel p = new JPanel(new BorderLayout());
        p.add("North", buttonPanel);
        p.add("Center", (Component)this.tree);
        this.logPanel.add("Center", p);
        this.logPanel.setPreferredSize(this.logD);
    }

    private void createDataPanel() {
        this.transactionTitle = new JLabel(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Transaction_data_26"), 0);
        this.transactionTitle.setBorder(new EtchedBorder(1));
        JTabbedPane jtp = new JTabbedPane();
        jtp.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("ACS_MON_Transaction_dataName"));
        jtp.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("ACS_MON_Transaction_dataDesc"));
        jtp.setPreferredSize(this.tabD);
        jtp.setMaximumSize(this.tabD);
        this.requestDisplay = new RequestDisplay();
        JScrollPane p = new JScrollPane(this.requestDisplay);
        jtp.addTab(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Request_19"), p);
        this.cookieDisplay = new CookieDisplay();
        p = new JScrollPane(this.cookieDisplay);
        jtp.addTab(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Cookies_4"), p);
        this.sessionDisplay = new SessionDisplay();
        p = new JScrollPane(this.sessionDisplay);
        jtp.addTab(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Session_24"), p);
        this.servletDisplay = new ServletDisplay();
        p = new JScrollPane(this.servletDisplay);
        jtp.addTab(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Servlet_23"), p);
        this.contextDisplay = new ContextDisplay();
        p = new JScrollPane(this.contextDisplay);
        jtp.addTab(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Context_23"), p);
        this.clientDisplay = new ClientDisplay();
        p = new JScrollPane(this.clientDisplay);
        jtp.addTab(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Client_Server"), p);
        this.headerDisplay = new HeaderDisplay();
        p = new JScrollPane(this.headerDisplay);
        jtp.addTab(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Header_19"), p);
        jtp.addChangeListener(this);
        this.dataPanel = new JPanel();
        this.dataPanel.setLayout(new BorderLayout());
        this.dataPanel.add((Component)this.transactionTitle, "North");
        this.dataPanel.add("Center", jtp);
        this.dataPanel.setPreferredSize(this.dataD);
    }

    public void displayTransaction(Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof TransactionNode || node instanceof NestedNode) {
            try {
                this.selected = (AbstractNode)node;
            }
            catch (ClassCastException ex) {
                this.selected = null;
                this.selectNode(null);
            }
        } else {
            this.selected = null;
            this.selectNode(null);
        }
        this.showData();
    }

    public void saveTransaction(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        controller.saveTransaction(nodes);
        this.selected = null;
        this.selectNode(null);
        this.showData();
    }

    public void editTransaction(Node node) {
        if (!controller.checkServer(true)) {
            return;
        }
        this.selected = (TransactionNode)node;
        this.editData();
    }

    public void stateChanged(ChangeEvent e) {
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Title"));
        JTabbedPane p = (JTabbedPane)e.getSource();
        this.displayType = p.getSelectedIndex();
        this.showData();
    }

    void showData() {
        if (this.selected == null) {
            // empty if block
        }
        DataRecord dr = null;
        try {
            if (this.selected != null) {
                dr = controller.getDataRecord(this.selected);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.displayType == 0) {
            this.requestDisplay.setData(dr);
        } else if (this.displayType == 1) {
            this.cookieDisplay.setData(dr);
        } else if (this.displayType == 2) {
            this.sessionDisplay.setData(dr);
        } else if (this.displayType == 3) {
            this.servletDisplay.setData(dr);
        } else if (this.displayType == 4) {
            this.contextDisplay.setData(dr);
        } else if (this.displayType == 5) {
            this.clientDisplay.setData(dr);
        } else if (this.displayType == 6) {
            this.headerDisplay.setData(dr);
        }
        ((Component)((Object)this)).repaint();
    }

    void editData() {
        if (this.selected == null) {
            return;
        }
        if (!(this.selected instanceof TransactionNode)) {
            return;
        }
        MonitorData md = null;
        try {
            md = controller.getMonitorData((TransactionNode)this.selected, false, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.editPanel == null) {
            this.editPanel = new EditPanel(md);
        }
        this.editPanel.setData(md);
        this.editPanel.showDialog();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView)).getString("MON_Title"));
        if (evt.getPropertyName().equals("selectedNodes") && evt.getNewValue() instanceof Node[]) {
            try {
                Node[] ns = (Node[])evt.getNewValue();
                if (ns.length == 1) {
                    this.displayTransaction(ns[0]);
                }
            }
            catch (Exception e) {
                this.selected = null;
                this.showData();
                return;
            }
        }
    }

    public void blank() {
        this.selected = null;
        this.selectNode(null);
        this.showData();
    }

    private void log(String s) {
        System.out.println("TransactionView::" + s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$000(TransactionView x0, String x1) {
        x0.log(x1);
    }

    static {
        try {
            updateIcon = new ImageIcon((class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView).getResource("/org/netbeans/modules/web/monitor/client/icons/update.gif"));
            a2zIcon = new ImageIcon((class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView).getResource("/org/netbeans/modules/web/monitor/client/icons/a2z.gif"));
            timesortAIcon = new ImageIcon((class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView).getResource("/org/netbeans/modules/web/monitor/client/icons/timesortA.gif"));
            timesortDIcon = new ImageIcon((class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView).getResource("/org/netbeans/modules/web/monitor/client/icons/timesortB.gif"));
            timestampIcon = new ImageIcon((class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView).getResource("/org/netbeans/modules/web/monitor/client/icons/timestamp.gif"));
            browserCookieIcon = new ImageIcon((class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView).getResource("/org/netbeans/modules/web/monitor/client/icons/browsercookie.gif"));
            savedCookieIcon = new ImageIcon((class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView).getResource("/org/netbeans/modules/web/monitor/client/icons/savedcookie.gif"));
            frameIcon = new ImageIcon((class$org$netbeans$modules$web$monitor$client$TransactionView == null ? (class$org$netbeans$modules$web$monitor$client$TransactionView = TransactionView.class$("org.netbeans.modules.web.monitor.client.TransactionView")) : class$org$netbeans$modules$web$monitor$client$TransactionView).getResource("/org/netbeans/modules/web/monitor/client/icons/menuitem.gif"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object o, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            ImageIcon icon = (ImageIcon)o;
            this.setText(icon.getDescription());
            this.setIcon(icon);
            return this;
        }
    }

    class OpenTransactionNodesRequest
    implements Runnable {
        OpenTransactionNodesRequest() {
        }

        public void run() {
            this.openTransactionNodes();
        }

        public void openTransactionNodes() {
            NavigateNode root = controller.getRoot();
            Children ch = root.getChildren();
            Node[] nodes = ch.getNodes();
            CurrNode cn = (CurrNode)nodes[0];
            SavedNode sn = (SavedNode)nodes[1];
            Children currCh = cn.getChildren();
            Node[] currChNodes = currCh.getNodes();
            int numCN = currChNodes.length;
            if (numCN > 0) {
                int selectThisOne = 0;
                if (TransactionView.this.timeAButton.isSelected()) {
                    selectThisOne = numCN - 1;
                }
                TransactionView.this.selectNode(currChNodes[selectThisOne]);
            } else {
                Children savedCh = sn.getChildren();
                Node[] savedChNodes = savedCh.getNodes();
                int numSN = savedChNodes.length;
                if (numSN > 0) {
                    TransactionView.this.selectNode(savedChNodes[0]);
                }
            }
        }
    }
}

