/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpUtils;
import org.netbeans.modules.web.monitor.data.Headers;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.Param;
import org.netbeans.modules.web.monitor.data.RequestData;

public class Util {
    private static final boolean debug = false;

    public static void composeQueryString(RequestData rd) {
        if (rd.sizeParam() == 0) {
            return;
        }
        Param[] params = rd.getParam();
        StringBuffer buf = new StringBuffer(512);
        int i = 0;
        while (i < params.length) {
            block6: {
                String value;
                String name;
                try {
                    name = params[i].getName().trim();
                    value = params[i].getValue();
                }
                catch (Exception ex) {
                    break block6;
                }
                if (!name.equals("")) {
                    value = value != null ? value.trim() : "";
                    if (i > 0) {
                        buf.append('&');
                    }
                    buf.append(name);
                    buf.append('=');
                    buf.append(value);
                }
            }
            ++i;
        }
        rd.setAttributeValue("queryString", buf.toString());
        rd.setParam(new Param[0]);
    }

    static boolean removeParametersFromQuery(RequestData rd) {
        if (rd.sizeParam() == 0) {
            return false;
        }
        String queryString = rd.getAttributeValue("queryString");
        Hashtable ht = null;
        try {
            ht = HttpUtils.parseQueryString((String)queryString);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        if (ht == null || ht.isEmpty()) {
            return false;
        }
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            try {
                String[] value = (String[])ht.get(name);
                int i = 0;
                while (i < value.length) {
                    Param p = Util.findParam(rd.getParam(), name, value[i]);
                    rd.removeParam(p);
                    ++i;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return true;
    }

    static void addParametersToQuery(RequestData rd) {
        Hashtable ht = null;
        String queryString = rd.getAttributeValue("queryString");
        try {
            ht = HttpUtils.parseQueryString((String)queryString);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (ht != null && ht.size() > 0) {
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] value = (String[])ht.get(name);
                int i = 0;
                while (i < value.length) {
                    Param p = new Param(name, value[i]);
                    rd.addParam(p);
                    ++i;
                }
            }
        }
    }

    public static void setSessionCookieHeader(MonitorData md) {
        Headers headers = md.getRequestData().getHeaders();
        int numParams = headers.sizeParam();
        if (numParams == 0) {
            return;
        }
        boolean sessionCookie = false;
        Param[] params = headers.getParam();
        StringBuffer cookiesOut = new StringBuffer("");
        int i = 0;
        while (i < numParams) {
            Param p = params[i];
            if (p.getAttributeValue("name").equals("Cookie")) {
                String cookies = p.getAttributeValue("value");
                StringTokenizer st = new StringTokenizer(cookies, ";");
                while (st.hasMoreTokens()) {
                    String cookie = st.nextToken();
                    if (cookie.startsWith("JSESSIONID")) {
                        sessionCookie = true;
                        String sessionID = null;
                        try {
                            sessionID = md.getSessionData().getAttributeValue("id");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        cookiesOut.append("JSESSIONID=");
                        cookiesOut.append(sessionID);
                        cookiesOut.append(";");
                        continue;
                    }
                    cookiesOut.append(cookie);
                    cookiesOut.append(";");
                }
                if (sessionCookie) {
                    p.setAttributeValue("value", cookiesOut.toString());
                }
            }
            ++i;
        }
    }

    public static Param findParam(Param[] myParams, String name, String value) {
        int i = 0;
        while (i < myParams.length) {
            Param param = myParams[i];
            if (name.equals(param.getName()) && value.equals(param.getValue())) {
                return param;
            }
            ++i;
        }
        return null;
    }
}

