/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.data;

import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.schema2beans.Version;
import org.netbeans.modules.web.monitor.data.Headers;
import org.netbeans.modules.web.monitor.data.Param;
import org.netbeans.modules.web.monitor.data.RequestAttributesIn;
import org.netbeans.modules.web.monitor.data.RequestAttributesOut;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RequestData
extends BaseBean {
    static Vector comparators = new Vector();
    public static final String PARAM = "Param";
    public static final String HEADERS = "Headers";
    public static final String REQUESTATTRIBUTESIN = "RequestAttributesIn";
    public static final String REQUESTATTRIBUTESOUT = "RequestAttributesOut";
    public static final String REQUESTDATA = "RequestData";
    public static final String JSESSIONID = "JSESSIONID";
    public static final String COOKIE = "cookie";
    private static final boolean debug = false;
    static /* synthetic */ Class class$org$netbeans$modules$web$monitor$data$Headers;
    static /* synthetic */ Class class$org$netbeans$modules$web$monitor$data$RequestAttributesIn;
    static /* synthetic */ Class class$org$netbeans$modules$web$monitor$data$RequestAttributesOut;
    static /* synthetic */ Class class$org$netbeans$modules$web$monitor$data$Param;

    public RequestData() {
        this(Common.USE_DEFAULT_VALUES);
    }

    public RequestData(Node doc, int options) {
        this(Common.NO_DEFAULT_VALUES);
        if (doc == null && (doc = GraphManager.createRootElementNode((String)REQUESTDATA)) == null) {
            throw new RuntimeException("failed to create a new DOM root!");
        }
        Node n = GraphManager.getElementNode((String)REQUESTDATA, (Node)doc);
        if (n == null) {
            throw new RuntimeException("doc root not found in the DOM graph!");
        }
        this.graphManager.setXmlDocument(doc);
        this.createBean(n, this.graphManager());
        this.initialize(options);
    }

    public RequestData(int options) {
        super(comparators, new Version(1, 0, 6));
        this.createProperty(HEADERS, HEADERS, 66080, class$org$netbeans$modules$web$monitor$data$Headers == null ? (class$org$netbeans$modules$web$monitor$data$Headers = RequestData.class$("org.netbeans.modules.web.monitor.data.Headers")) : class$org$netbeans$modules$web$monitor$data$Headers);
        this.createProperty(REQUESTATTRIBUTESIN, REQUESTATTRIBUTESIN, 66080, class$org$netbeans$modules$web$monitor$data$RequestAttributesIn == null ? (class$org$netbeans$modules$web$monitor$data$RequestAttributesIn = RequestData.class$("org.netbeans.modules.web.monitor.data.RequestAttributesIn")) : class$org$netbeans$modules$web$monitor$data$RequestAttributesIn);
        this.createProperty(REQUESTATTRIBUTESOUT, REQUESTATTRIBUTESOUT, 66080, class$org$netbeans$modules$web$monitor$data$RequestAttributesOut == null ? (class$org$netbeans$modules$web$monitor$data$RequestAttributesOut = RequestData.class$("org.netbeans.modules.web.monitor.data.RequestAttributesOut")) : class$org$netbeans$modules$web$monitor$data$RequestAttributesOut);
        this.createProperty(PARAM, PARAM, 66096, class$org$netbeans$modules$web$monitor$data$Param == null ? (class$org$netbeans$modules$web$monitor$data$Param = RequestData.class$("org.netbeans.modules.web.monitor.data.Param")) : class$org$netbeans$modules$web$monitor$data$Param);
        this.createAttribute(PARAM, "name", "Name", 257, null, null);
        this.createAttribute(PARAM, "value", "Value", 513, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setHeaders(Headers value) {
        this.setValue(HEADERS, (Object)value);
    }

    public Headers getHeaders() {
        return (Headers)((Object)this.getValue(HEADERS));
    }

    public void setRequestAttributesIn(RequestAttributesIn value) {
        this.setValue(REQUESTATTRIBUTESIN, (Object)value);
    }

    public RequestAttributesIn getRequestAttributesIn() {
        return (RequestAttributesIn)((Object)this.getValue(REQUESTATTRIBUTESIN));
    }

    public void setRequestAttributesOut(RequestAttributesOut value) {
        this.setValue(REQUESTATTRIBUTESOUT, (Object)value);
    }

    public RequestAttributesOut getRequestAttributesOut() {
        return (RequestAttributesOut)((Object)this.getValue(REQUESTATTRIBUTESOUT));
    }

    public void setParam(int index, Param value) {
        this.setValue(PARAM, index, (Object)value);
    }

    public Param getParam(int index) {
        return (Param)((Object)this.getValue(PARAM, index));
    }

    public void setParam(Param[] value) {
        try {
            this.setValue(PARAM, (Object[])value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Param[] getParam() {
        return (Param[])this.getValues(PARAM);
    }

    public int sizeParam() {
        return this.size(PARAM);
    }

    public int addParam(Param value) {
        return this.addValue(PARAM, (Object)value);
    }

    public int removeParam(Param value) {
        return this.removeValue(PARAM, (Object)value);
    }

    public void setReplaceSessionCookie(boolean value) {
        this.setAttributeValue("replace", String.valueOf(value));
    }

    public boolean getReplaceSessionCookie() {
        try {
            if (this.getAttributeValue("replace").equals("true")) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public String getSessionID() {
        return RequestData.findSessionID(this.getCookieString());
    }

    public String getCookieString() {
        Param[] headers = this.getHeaders().getParam();
        StringBuffer cookieStr = new StringBuffer();
        int len = headers.length;
        int j = 0;
        while (j < len) {
            if (headers[j].getName().equalsIgnoreCase(COOKIE)) {
                cookieStr.append(headers[j].getValue());
                cookieStr.append(";");
            }
            ++j;
        }
        return cookieStr.toString();
    }

    public static String findSessionID(String cookieStr) {
        if (cookieStr == null || cookieStr.equals("")) {
            return "";
        }
        StringTokenizer tok = new StringTokenizer(cookieStr, ";", false);
        while (tok.hasMoreTokens()) {
            String name;
            String token = tok.nextToken();
            int i = token.indexOf("=");
            if (i <= -1 || !(name = token.substring(0, i).trim()).equals(JSESSIONID)) continue;
            String value = token.substring(i + 1, token.length()).trim();
            value = RequestData.stripQuote(value);
            return value;
        }
        return "";
    }

    public Param[] getCookiesAsParams() {
        String cookieStr = this.getCookieString();
        if (cookieStr == null || cookieStr.equals("")) {
            return new Param[0];
        }
        Vector<Param> cookies = new Vector<Param>();
        StringTokenizer tok = new StringTokenizer(cookieStr, ";", false);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            int i = token.indexOf("=");
            if (i <= -1) continue;
            String name = token.substring(0, i).trim();
            String value = token.substring(i + 1, token.length()).trim();
            value = RequestData.stripQuote(value);
            cookies.addElement(new Param(name, value));
        }
        int numCookies = cookies.size();
        Param[] params = new Param[numCookies];
        int k = 0;
        while (k < numCookies) {
            params[k] = (Param)((Object)cookies.elementAt(k));
            ++k;
        }
        return params;
    }

    public int addCookie(String ckname, String ckvalue) {
        int len;
        boolean debug = false;
        if (debug) {
            this.log("Adding cookie: " + ckname + " " + ckvalue);
        }
        StringBuffer buf = new StringBuffer();
        Param[] headers = this.getHeaders().getParam();
        if (headers == null) {
            headers = new Param[]{};
        }
        if ((len = headers.length) == 0) {
            if (debug) {
                this.log("We had a cookie header with no value");
            }
            buf.append(ckname);
            buf.append("=");
            buf.append(ckvalue);
            if (debug) {
                this.log("New cookie string is " + buf.toString());
            }
            this.setCookieHeader(buf.toString());
            return 1;
        }
        int i = 0;
        while (i < len) {
            if (headers[i].getName().equalsIgnoreCase(COOKIE)) {
                String oldCookies;
                if (debug) {
                    this.log("Found cookie header");
                }
                if ((oldCookies = headers[i].getValue()) != null && !oldCookies.trim().equals("")) {
                    buf.append(oldCookies.trim());
                    buf.append(";");
                }
                if (debug) {
                    this.log("appended ; to cookie string");
                }
                buf.append(ckname);
                buf.append("=");
                buf.append(ckvalue);
                headers[i].setValue(buf.toString());
                if (debug) {
                    this.log("New cookie string is " + buf.toString());
                }
                return 1;
            }
            ++i;
        }
        if (debug) {
            this.log("We had no cookie header");
        }
        buf.append(ckname);
        buf.append("=");
        buf.append(ckvalue);
        if (debug) {
            this.log("New cookie string is " + buf.toString());
        }
        this.setCookieHeader(buf.toString());
        return 0;
    }

    public int addCookie(String ckstr) {
        int index = ckstr.indexOf("=");
        if (index == -1) {
            return this.addCookie(ckstr, "");
        }
        if (index == ckstr.length() - 1) {
            return this.addCookie(ckstr, "");
        }
        return this.addCookie(ckstr.substring(0, index), ckstr.substring(index + 1));
    }

    public void setCookieHeader(String cookies) {
        Param[] headers = this.getHeaders().getParam();
        if (headers == null) {
            headers = new Param[]{};
        }
        int len = headers.length;
        int i = 0;
        while (i < len) {
            if (headers[i].getName().equalsIgnoreCase(COOKIE)) {
                headers[i].setValue(cookies);
                return;
            }
            ++i;
        }
        Param p = new Param(COOKIE, cookies);
        this.getHeaders().addParam(p);
    }

    public void deleteCookie(String ckname, String ckvalue) {
        Param[] headers = this.getHeaders().getParam();
        boolean noCookie = false;
        if (headers == null || headers.length == 0) {
            return;
        }
        int len = headers.length;
        int i = 0;
        while (i < len) {
            if (headers[i].getName().equalsIgnoreCase(COOKIE)) {
                String oldCookies = headers[i].getValue();
                if (oldCookies == null || oldCookies.trim().equals("")) {
                    return;
                }
                StringBuffer buf = new StringBuffer();
                StringTokenizer tok = new StringTokenizer(headers[i].getValue(), ";", false);
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    int j = token.indexOf("=");
                    if (j <= -1) continue;
                    String name = token.substring(0, j).trim();
                    String value = token.substring(j + 1, token.length()).trim();
                    value = RequestData.stripQuote(value);
                    if (name.equals(ckname) && value.equals(ckvalue)) continue;
                    buf.append(name);
                    buf.append("=");
                    buf.append(value);
                    buf.append(";");
                }
                if (buf.toString().equals("")) {
                    this.getHeaders().removeParam(headers[i]);
                    break;
                }
                headers[i].setValue(buf.toString());
                break;
            }
            ++i;
        }
    }

    public void deleteCookie(String ckname) {
        Param[] headers = this.getHeaders().getParam();
        if (headers == null || headers.length == 0) {
            return;
        }
        int len = headers.length;
        int i = 0;
        while (i < len) {
            if (headers[i].getName().equalsIgnoreCase(COOKIE)) {
                String oldCookies = headers[i].getValue();
                if (oldCookies != null && !oldCookies.trim().equals("")) {
                    return;
                }
                StringBuffer buf = new StringBuffer();
                StringTokenizer tok = new StringTokenizer(headers[i].getValue(), ";", false);
                while (tok.hasMoreTokens()) {
                    String name;
                    String token = tok.nextToken();
                    int j = token.indexOf("=");
                    if (j <= -1 || (name = token.substring(0, j).trim()).equals(ckname)) continue;
                    String value = token.substring(j + 1, token.length()).trim();
                    value = RequestData.stripQuote(value);
                    buf.append(name);
                    buf.append("=");
                    buf.append(value);
                    buf.append(";");
                }
                headers[i].setValue(buf.toString());
                return;
            }
            ++i;
        }
    }

    public static String stripQuote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            try {
                return value.substring(1, value.length() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public boolean verify() {
        return true;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        BeanProp p = this.beanProp();
        if (p != null) {
            p.addPCListener(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        BeanProp p = this.beanProp();
        if (p != null) {
            p.removePCListener(l);
        }
    }

    public void addPropertyChangeListener(String n, PropertyChangeListener l) {
        BeanProp p = this.beanProp(n);
        if (p != null) {
            p.addPCListener(l);
        }
    }

    public void removePropertyChangeListener(String n, PropertyChangeListener l) {
        BeanProp p = this.beanProp(n);
        if (p != null) {
            p.removePCListener(l);
        }
    }

    public void dump(StringBuffer str, String indent) {
        str.append(indent);
        str.append(HEADERS);
        BaseBean n = this.getHeaders();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(HEADERS, 0, str, indent);
        str.append(indent);
        str.append("Param[" + this.sizeParam() + "]");
        int i = 0;
        while (i < this.sizeParam()) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getParam(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(PARAM, i, str, indent);
            ++i;
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("RequestData\n");
        this.dump(str, "\n  ");
        return str.toString();
    }

    public static RequestData createGraph(Node doc) {
        return new RequestData(doc, Common.NO_DEFAULT_VALUES);
    }

    public static RequestData createGraph(InputStream in) {
        return RequestData.createGraph(in, false);
    }

    public static RequestData createGraph(InputStream in, boolean validate) {
        try {
            Document doc = GraphManager.createXmlDocument((InputStream)in, (boolean)validate);
            return RequestData.createGraph(doc);
        }
        catch (Throwable t) {
            throw new RuntimeException("DOM graph creation failed: " + t.getMessage());
        }
    }

    public static RequestData createGraph() {
        return new RequestData();
    }

    public void log(String s) {
        System.out.println("RequestData::" + s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

