/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.RequestData;
import org.netbeans.modules.web.monitor.server.MonitorFilter;

class NotifyUtil {
    private String ideServer = null;
    private Vector otherIDEs = new Vector();
    private static final String putServlet = "/servlet/org.netbeans.modules.web.monitor.client.PutTransaction?";
    private static final String replayServlet = "/servlet/org.netbeans.modules.web.monitor.client.ReplaySendXMLServlet";
    private static final boolean debug = false;

    NotifyUtil() {
    }

    void setIDE(String name, String portS) throws MalformedURLException {
        int port = 0;
        try {
            port = Integer.parseInt(portS);
        }
        catch (NumberFormatException nfe) {
            throw new MalformedURLException("Port number is not an integer");
        }
        if (this.ideServer == null) {
            this.ideServer = new URL("http", name, port, putServlet).toString();
        } else {
            this.otherIDEs.add(new URL("http", name, port, putServlet).toString());
        }
    }

    void setIDE(String server) throws MalformedURLException {
        String host = server.substring(0, server.indexOf(":"));
        String port = server.substring(server.indexOf(":") + 1);
        this.setIDE(host, port);
    }

    void sendRecord(MonitorData monData, String queryStr) {
        if (this.ideServer != null) {
            String urlStr = this.ideServer.concat(queryStr);
            this.sendRecord(urlStr, monData);
        }
        if (this.otherIDEs.isEmpty()) {
            return;
        }
        Enumeration ides = this.otherIDEs.elements();
        while (ides.hasMoreElements()) {
            String base = (String)ides.nextElement();
            if (this.sendRecord(base.concat(queryStr), monData)) continue;
            this.otherIDEs.remove(base);
        }
    }

    private boolean sendRecord(String urlS, MonitorData monData) {
        boolean status = false;
        URL url = null;
        try {
            url = new URL(urlS);
        }
        catch (MalformedURLException mux) {
            return status;
        }
        RecordSender recordSender = new RecordSender(url, monData);
        recordSender.start();
        try {
            recordSender.join(3000L);
            status = recordSender.getStatus();
        }
        catch (InterruptedException ix) {
            // empty catch block
        }
        recordSender = null;
        return status;
    }

    RequestData getRecord(String id, String status, String host, int port) {
        Object rd = null;
        StringBuffer uriBuf = new StringBuffer(replayServlet);
        uriBuf.append("?status=");
        uriBuf.append(status);
        uriBuf.append("&id=");
        uriBuf.append(id);
        URL url = null;
        try {
            url = new URL("http", host, port, uriBuf.toString());
        }
        catch (MalformedURLException mux) {
            // empty catch block
        }
        RecordFetcher recordFetcher = new RecordFetcher(url);
        recordFetcher.start();
        try {
            recordFetcher.join(3000L);
            if (recordFetcher.getStatus()) {
                return recordFetcher.getMonitorData().getRequestData();
            }
            return null;
        }
        catch (InterruptedException ix) {
            recordFetcher = null;
            return null;
        }
    }

    void log(Throwable t) {
        this.log(MonitorFilter.getStackTrace(t));
    }

    void log(String msg) {
        System.out.println("NotifyUtil::" + msg);
    }

    class RecordFetcher
    extends Thread {
        URL url = null;
        boolean gotAck = false;
        String trace = null;
        MonitorData monData = null;

        RecordFetcher(URL url) {
            super("HTTP Monitor, retrieves data from IDE");
            this.url = url;
        }

        MonitorData getMonitorData() {
            return this.monData;
        }

        /*
         * Loose catch block
         */
        public void run() {
            block14: {
                InputStream in = null;
                InputStreamReader urlIn = null;
                in = this.url.openStream();
                urlIn = new InputStreamReader(in);
                this.monData = MonitorData.createGraph(urlIn);
                this.gotAck = true;
                Object var5_3 = null;
                try {
                    urlIn.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    in.close();
                }
                catch (Exception ex) {}
                break block14;
                {
                    catch (Throwable t) {
                        this.gotAck = false;
                        this.trace = MonitorFilter.getStackTrace(t);
                        Object var5_4 = null;
                        try {
                            urlIn.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            in.close();
                        }
                        catch (Exception ex) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        urlIn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        in.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        boolean getStatus() {
            return this.gotAck;
        }

        String getStackTrace() {
            return this.trace;
        }
    }

    class RecordSender
    extends Thread {
        URL url = null;
        boolean gotAck = false;
        boolean triedToRestart = false;
        URLConnection conn = null;
        MonitorData monData = null;

        RecordSender(URL url, MonitorData monData) {
            super("HTTP Monitor, sends data to IDE");
            this.monData = monData;
            this.url = url;
        }

        /*
         * Loose catch block
         */
        public void run() {
            block21: {
                PrintWriter out = null;
                BufferedReader in = null;
                this.conn = this.url.openConnection();
                this.conn.setRequestProperty("\tContent-type", "text/xml");
                this.conn.setDoOutput(true);
                out = new PrintWriter(this.conn.getOutputStream());
                this.monData.write(out);
                out.flush();
                in = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
                String inputLine = null;
                while ((inputLine = in.readLine()) != null) {
                    if (!inputLine.equals("ACK")) continue;
                    this.gotAck = true;
                    break;
                }
                Object var7_5 = null;
                try {
                    in.close();
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (Throwable t2) {}
                break block21;
                {
                    catch (IOException ioe) {
                        NotifyUtil.this.log(ioe);
                        Object var7_6 = null;
                        try {
                            in.close();
                        }
                        catch (Throwable t2) {
                            // empty catch block
                        }
                        try {
                            out.close();
                        }
                        catch (Throwable t2) {}
                        break block21;
                    }
                    catch (NullPointerException npe) {
                        NotifyUtil.this.log(npe);
                        Object var7_7 = null;
                        try {
                            in.close();
                        }
                        catch (Throwable t2) {
                            // empty catch block
                        }
                        try {
                            out.close();
                        }
                        catch (Throwable t2) {}
                        break block21;
                    }
                    catch (Throwable t) {
                        NotifyUtil.this.log(t);
                        Object var7_8 = null;
                        try {
                            in.close();
                        }
                        catch (Throwable t2) {
                            // empty catch block
                        }
                        try {
                            out.close();
                        }
                        catch (Throwable t2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        in.close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }

        boolean getStatus() {
            return this.gotAck;
        }
    }
}

