/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.ImageIcon;
import org.netbeans.modules.image.ImageOpenSupport;
import org.netbeans.modules.image.ImagePrintSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ImageDataObject
extends MultiDataObject
implements CookieSet.Factory {
    static final long serialVersionUID = -6035788991669336965L;
    private static final String IMAGE_ICON_BASE = "org/netbeans/modules/image/imageObject";
    private transient ImageOpenSupport openSupport;
    private transient ImagePrintSupport printSupport;
    private static Method readImage;
    static /* synthetic */ Class class$org$netbeans$modules$image$ImageOpenSupport;
    static /* synthetic */ Class class$org$netbeans$modules$image$ImagePrintSupport;
    static /* synthetic */ Class class$org$netbeans$modules$image$ImageDataObject;
    static /* synthetic */ Class class$java$io$InputStream;

    public ImageDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.getCookieSet().add(class$org$netbeans$modules$image$ImageOpenSupport == null ? (class$org$netbeans$modules$image$ImageOpenSupport = ImageDataObject.class$("org.netbeans.modules.image.ImageOpenSupport")) : class$org$netbeans$modules$image$ImageOpenSupport, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$netbeans$modules$image$ImagePrintSupport == null ? (class$org$netbeans$modules$image$ImagePrintSupport = ImageDataObject.class$("org.netbeans.modules.image.ImagePrintSupport")) : class$org$netbeans$modules$image$ImagePrintSupport, (CookieSet.Factory)this);
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(class$org$netbeans$modules$image$ImageOpenSupport == null ? (class$org$netbeans$modules$image$ImageOpenSupport = ImageDataObject.class$("org.netbeans.modules.image.ImageOpenSupport")) : class$org$netbeans$modules$image$ImageOpenSupport)) {
            return this.getOpenSupport();
        }
        if (clazz.isAssignableFrom(class$org$netbeans$modules$image$ImagePrintSupport == null ? (class$org$netbeans$modules$image$ImagePrintSupport = ImageDataObject.class$("org.netbeans.modules.image.ImagePrintSupport")) : class$org$netbeans$modules$image$ImagePrintSupport)) {
            return this.getPrintSupport();
        }
        return null;
    }

    private ImageOpenSupport getOpenSupport() {
        if (this.openSupport == null) {
            ImageDataObject imageDataObject = this;
            synchronized (imageDataObject) {
                if (this.openSupport == null) {
                    this.openSupport = new ImageOpenSupport(this.getPrimaryEntry());
                }
            }
        }
        return this.openSupport;
    }

    protected ImagePrintSupport getPrintSupport() {
        if (this.printSupport == null) {
            ImageDataObject imageDataObject = this;
            synchronized (imageDataObject) {
                if (this.printSupport == null) {
                    this.printSupport = new ImagePrintSupport(this);
                }
            }
        }
        return this.printSupport;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$image$ImageDataObject == null ? (class$org$netbeans$modules$image$ImageDataObject = ImageDataObject.class$("org.netbeans.modules.image.ImageDataObject")) : class$org$netbeans$modules$image$ImageDataObject);
    }

    URL getImageURL() {
        try {
            return this.getPrimaryFile().getURL();
        }
        catch (FileStateInvalidException ex) {
            return null;
        }
    }

    private byte[] getImageData() {
        try {
            FileObject fo = this.getPrimaryFile();
            byte[] imageData = new byte[(int)fo.getSize()];
            BufferedInputStream in = new BufferedInputStream(fo.getInputStream());
            in.read(imageData, 0, (int)fo.getSize());
            in.close();
            return imageData;
        }
        catch (IOException ioe) {
            return new byte[0];
        }
    }

    public Image getImage() {
        try {
            if (System.getProperty("java.specification.version").equals("1.3")) {
                return new ImageIcon(this.getImageData()).getImage();
            }
            if (readImage == null) {
                Class<?> clazz = Class.forName("javax.imageio.ImageIO");
                readImage = clazz.getMethod("read", class$java$io$InputStream == null ? (class$java$io$InputStream = ImageDataObject.class$("java.io.InputStream")) : class$java$io$InputStream);
            }
            return (Image)readImage.invoke(null, this.getPrimaryFile().getInputStream());
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return null;
        }
    }

    protected Node createNodeDelegate() {
        return new ImageNode(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ImageNode
    extends DataNode {
        static /* synthetic */ Class class$org$openide$actions$OpenAction;

        public ImageNode(ImageDataObject obj) {
            super((DataObject)obj, Children.LEAF);
            this.setIconBase(ImageDataObject.IMAGE_ICON_BASE);
            this.setDefaultAction(SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = ImageNode.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction)));
        }

        protected Sheet createSheet() {
            Sheet s = super.createSheet();
            Sheet.Set ss = s.get("properties");
            if (ss == null) {
                ss = Sheet.createPropertiesSet();
                s.put(ss);
            }
            ss.put((Node.Property)new ThumbnailProperty(this.getDataObject()));
            return s;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private static final class ThumbnailProperty
        extends PropertySupport.ReadOnly {
            private final DataObject obj;
            static /* synthetic */ Class class$javax$swing$Icon;
            static /* synthetic */ Class class$org$netbeans$modules$image$ImageDataObject;

            public ThumbnailProperty(DataObject obj) {
                super("thumbnail", class$javax$swing$Icon == null ? (class$javax$swing$Icon = ThumbnailProperty.class$("javax.swing.Icon")) : class$javax$swing$Icon, NbBundle.getMessage((Class)(class$org$netbeans$modules$image$ImageDataObject == null ? (class$org$netbeans$modules$image$ImageDataObject = ThumbnailProperty.class$("org.netbeans.modules.image.ImageDataObject")) : class$org$netbeans$modules$image$ImageDataObject), (String)"PROP_Thumbnail"), NbBundle.getMessage((Class)(class$org$netbeans$modules$image$ImageDataObject == null ? (class$org$netbeans$modules$image$ImageDataObject = ThumbnailProperty.class$("org.netbeans.modules.image.ImageDataObject")) : class$org$netbeans$modules$image$ImageDataObject), (String)"HINT_Thumbnail"));
                this.obj = obj;
            }

            public Object getValue() throws InvocationTargetException {
                try {
                    return new ImageIcon(this.obj.getPrimaryFile().getURL());
                }
                catch (FileStateInvalidException fsie) {
                    throw new InvocationTargetException(fsie);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new ThumbnailPropertyEditor();
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }

            private final class ThumbnailPropertyEditor
            extends PropertyEditorSupport {
                private ThumbnailPropertyEditor() {
                }

                public boolean isPaintable() {
                    return true;
                }

                public void paintValue(Graphics g, Rectangle r) {
                    ImageIcon icon;
                    block5: {
                        icon = null;
                        try {
                            icon = (ImageIcon)ThumbnailProperty.this.getValue();
                        }
                        catch (InvocationTargetException ioe) {
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block5;
                            ErrorManager.getDefault().notify((Throwable)ioe);
                        }
                    }
                    if (icon != null) {
                        int iconWidth = icon.getIconWidth();
                        int iconHeight = icon.getIconHeight();
                        double scale = (double)iconWidth / (double)iconHeight;
                        if (iconWidth > r.width) {
                            iconWidth = r.width;
                            iconHeight = (int)((double)iconWidth / scale);
                        }
                        if (iconHeight > r.height) {
                            iconHeight = r.height;
                            iconWidth = (int)((double)iconHeight * scale);
                        }
                        int x = iconWidth < r.x ? (r.x - iconWidth) / 2 : 5;
                        int y = iconHeight < r.y ? (r.y - iconHeight) / 2 : 0;
                        Graphics g2 = g.create(r.x, r.y, r.width, r.height);
                        g.drawImage(icon.getImage(), x, y, iconWidth, iconHeight, null);
                    }
                }

                public String getAsText() {
                    return null;
                }
            }
        }
    }
}

