/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import org.netbeans.modules.image.ImageDataObject;
import org.netbeans.modules.image.ImageViewer;
import org.netbeans.modules.image.NBImageIcon;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.OpenSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public class ImageOpenSupport
extends OpenSupport
implements OpenCookie,
CloseCookie {
    private long lastSaveTime;
    private FileChangeListener fileChangeL;
    private RequestProcessor.Task reloadTask;
    static /* synthetic */ Class class$org$netbeans$modules$image$ImageOpenSupport;

    public ImageOpenSupport(MultiDataObject.Entry entry) {
        super(entry, (OpenSupport.Env)new Environment((DataObject)entry.getDataObject()));
    }

    public CloneableTopComponent createCloneableTopComponent() {
        this.prepareViewer();
        return new ImageViewer((ImageDataObject)this.entry.getDataObject());
    }

    void prepareViewer() {
        if (this.fileChangeL == null) {
            this.fileChangeL = new FileChangeAdapter(){

                public void fileChanged(FileEvent evt) {
                    if (((CloneableOpenSupport)ImageOpenSupport.this).allEditors.isEmpty()) {
                        return;
                    }
                    if (evt.getFile().isVirtual()) {
                        ImageOpenSupport.this.entry.getFile().removeFileChangeListener((FileChangeListener)this);
                        ((Environment)((CloneableOpenSupport)ImageOpenSupport.this).env).fileRemoved();
                        ImageOpenSupport.this.entry.getFile().addFileChangeListener((FileChangeListener)this);
                        return;
                    }
                    if (evt.getTime() > ImageOpenSupport.this.lastSaveTime) {
                        ImageOpenSupport.this.lastSaveTime = System.currentTimeMillis();
                        if (ImageOpenSupport.this.reloadTask == null || ImageOpenSupport.this.reloadTask.isFinished()) {
                            ImageOpenSupport.this.reloadTask = RequestProcessor.postRequest((Runnable)new Runnable(this, evt){
                                private final /* synthetic */ FileEvent val$evt;
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$evt = val$evt;
                                }

                                public void run() {
                                    ImageOpenSupport.access$800(1.access$700(this.this$1), this.val$evt);
                                }
                            });
                        }
                    }
                }

                static /* synthetic */ ImageOpenSupport access$700(1 x0) {
                    return x0.ImageOpenSupport.this;
                }
            };
        }
        this.entry.getFile().addFileChangeListener(this.fileChangeL);
        this.lastSaveTime = System.currentTimeMillis();
    }

    private void reload(FileEvent evt) {
        MessageFormat fmt = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageOpenSupport == null ? (class$org$netbeans$modules$image$ImageOpenSupport = ImageOpenSupport.class$("org.netbeans.modules.image.ImageOpenSupport")) : class$org$netbeans$modules$image$ImageOpenSupport)).getString("MSG_ExternalChange"));
        String msg = fmt.format(new Object[]{this.entry.getFile().getPackageNameExt('/', '.')});
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, 0);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (NotifyDescriptor.YES_OPTION.equals(ret)) {
            ImageDataObject imageObj = (ImageDataObject)this.entry.getDataObject();
            CloneableTopComponent.Ref editors = ((CloneableOpenSupport)this).allEditors;
            final NBImageIcon icon = new NBImageIcon(imageObj);
            Enumeration e = editors.getComponents();
            while (e.hasMoreElements()) {
                final Object pane = e.nextElement();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((ImageViewer)((Object)pane)).reloadIcon(icon);
                    }
                });
            }
        }
    }

    static /* synthetic */ void access$800(ImageOpenSupport x0, FileEvent x1) {
        x0.reload(x1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Environment
    extends OpenSupport.Env {
        static final long serialVersionUID = -1934890789745432254L;
        static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

        public Environment(DataObject dataObject) {
            super(dataObject);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = Environment.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
        }

        private void fileRemoved() {
            try {
                this.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

