/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import org.netbeans.modules.image.ImageDataObject;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.PrintCookie;
import org.openide.text.PrintSettings;
import org.openide.util.NbBundle;

public class ImagePrintSupport
implements PrintCookie,
Printable,
ImageObserver {
    protected ImageDataObject dataObject;
    protected RenderedImage image;
    static /* synthetic */ Class class$org$openide$text$PrintSettings;

    public ImagePrintSupport(ImageDataObject ido) {
        this.dataObject = ido;
    }

    protected RenderedImage prepareImage(PageFormat pf) throws IllegalArgumentException {
        try {
            AffineTransform af = new AffineTransform();
            if (pf.getOrientation() != 0) {
                af.translate(pf.getImageableX(), pf.getImageableY());
            }
            this.image = (RenderedImage)((Object)this.dataObject.getImage());
            if (pf.getImageableWidth() - pf.getImageableX() < (double)this.image.getWidth() || pf.getImageableHeight() - pf.getImageableY() < (double)this.image.getHeight()) {
                throw new IllegalArgumentException("Page too small for image");
            }
            AffineTransformOp afo = new AffineTransformOp(af, 1);
            BufferedImage o = (BufferedImage)this.image;
            BufferedImage i = new BufferedImage(o.getWidth() + (int)pf.getImageableX(), o.getHeight() + (int)pf.getImageableY(), o.getType());
            return afo.filter((BufferedImage)this.image, i);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        Book book = new Book();
        PageFormat pf = PrintSettings.getPageFormat((PrinterJob)job);
        book.append(this, pf);
        job.setPageable(book);
        try {
            this.image = this.prepareImage(pf);
            if (job.printDialog()) {
                job.print();
            }
        }
        catch (PrinterAbortException e) {
            final String msg = NbBundle.getMessage((Class)(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = ImagePrintSupport.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings), (String)"CTL_Printer_Abort");
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                }
            });
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int page) throws PrinterException {
        if (page != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        if (this.image == null) {
            graphics.drawImage(this.dataObject.getImage(), (int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), this);
        } else {
            g2.drawRenderedImage(this.image, new AffineTransform());
        }
        return 0;
    }

    public boolean imageUpdate(Image image, int flags, int param2, int param3, int param4, int param5) {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

