/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.modules.image.ImageDataObject;
import org.netbeans.modules.image.ImageOpenSupport;
import org.netbeans.modules.image.NBImageIcon;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class ImageViewer
extends CloneableTopComponent {
    static final long serialVersionUID = 6960127954234034486L;
    private ImageDataObject storedObject;
    private NBImageIcon storedImage;
    private JPanel panel;
    private double scale = 1.0;
    private boolean showGrid = false;
    private final double changeFactor = Math.sqrt(2.0);
    private final Color gridColor = Color.black;
    private PropertyChangeListener nameChangeL;
    static /* synthetic */ Class class$org$netbeans$modules$image$ImageViewer;
    static /* synthetic */ Class class$org$netbeans$modules$image$ZoomOutAction;
    static /* synthetic */ Class class$org$netbeans$modules$image$ZoomInAction;
    static /* synthetic */ Class class$org$netbeans$modules$image$CustomZoomAction;
    static /* synthetic */ Class class$org$openide$text$CloneableEditorSupport;
    static /* synthetic */ Class class$org$netbeans$modules$image$ImageOpenSupport;

    public ImageViewer() {
    }

    public ImageViewer(ImageDataObject obj) {
        super((DataObject)obj);
        this.initialize(obj);
    }

    protected void reloadIcon(NBImageIcon icon) {
        this.storedImage = icon;
        this.resizePanel();
        this.panel.repaint();
    }

    private void initialize(ImageDataObject obj) {
        this.storedObject = obj;
        this.storedImage = new NBImageIcon(this.storedObject);
        this.setCloseOperation(0);
        this.panel = new JPanel(){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(ImageViewer.this.storedImage.getImage(), 0, 0, (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconWidth()), (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconHeight()), 0, 0, ImageViewer.this.storedImage.getIconWidth(), ImageViewer.this.storedImage.getIconHeight(), this);
                if (ImageViewer.this.showGrid) {
                    int x = (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconWidth());
                    int y = (int)(ImageViewer.this.getScale() * (double)ImageViewer.this.storedImage.getIconHeight());
                    double gridDistance = ImageViewer.this.getScale();
                    if (gridDistance < 2.0) {
                        return;
                    }
                    g.setColor(ImageViewer.this.gridColor);
                    double actualDistance = gridDistance;
                    int i = (int)actualDistance;
                    while (i < x) {
                        g.drawLine(i, 0, i, y - 1);
                        i = (int)(actualDistance += gridDistance);
                    }
                    actualDistance = gridDistance;
                    int j = (int)actualDistance;
                    while (j < y) {
                        g.drawLine(0, j, x - 1, j);
                        j = (int)(actualDistance += gridDistance);
                    }
                }
            }
        };
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACS_ImageViewer"));
        this.storedImage.setImageObserver(this.panel);
        this.panel.setPreferredSize(new Dimension(this.storedImage.getIconWidth(), this.storedImage.getIconHeight()));
        JScrollPane scroll = new JScrollPane(this.panel);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        ((Container)((Object)this)).add(scroll, "Center");
        ((Container)((Object)this)).add(this.createToolBar(), "North");
        this.nameChangeL = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("cookie".equals(evt.getPropertyName()) || "name".equals(evt.getPropertyName())) {
                    ImageViewer.this.updateName();
                }
            }
        };
        obj.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.nameChangeL, (Object)((Object)obj)));
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACSN_Toolbar"));
        toolBar.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACSD_Toolbar"));
        JButton outButton = new JButton((Action)SystemAction.get((Class)(class$org$netbeans$modules$image$ZoomOutAction == null ? (class$org$netbeans$modules$image$ZoomOutAction = ImageViewer.class$("org.netbeans.modules.image.ZoomOutAction")) : class$org$netbeans$modules$image$ZoomOutAction)));
        outButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("LBL_ZoomOut"));
        outButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACS_Out_BTN_Mnem").charAt(0));
        outButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACSD_Out_BTN"));
        outButton.setLabel("");
        toolBar.add(outButton);
        toolBar.addSeparator(new Dimension(2, 2));
        JButton inButton = new JButton((Action)SystemAction.get((Class)(class$org$netbeans$modules$image$ZoomInAction == null ? (class$org$netbeans$modules$image$ZoomInAction = ImageViewer.class$("org.netbeans.modules.image.ZoomInAction")) : class$org$netbeans$modules$image$ZoomInAction)));
        inButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("LBL_ZoomIn"));
        inButton.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACS_In_BTN_Mnem").charAt(0));
        inButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACSD_In_BTN"));
        inButton.setLabel("");
        toolBar.add(inButton);
        toolBar.addSeparator(new Dimension(11, 2));
        toolBar.add(this.getZoomButton(1, 1));
        toolBar.addSeparator(new Dimension(11, 2));
        toolBar.add(this.getZoomButton(1, 3));
        toolBar.addSeparator(new Dimension(2, 2));
        toolBar.add(this.getZoomButton(1, 5));
        toolBar.addSeparator(new Dimension(2, 2));
        toolBar.add(this.getZoomButton(1, 7));
        toolBar.addSeparator(new Dimension(11, 2));
        toolBar.add(this.getZoomButton(3, 1));
        toolBar.addSeparator(new Dimension(2, 2));
        toolBar.add(this.getZoomButton(5, 1));
        toolBar.addSeparator(new Dimension(2, 2));
        toolBar.add(this.getZoomButton(7, 1));
        toolBar.addSeparator(new Dimension(11, 2));
        SystemAction sa = SystemAction.get((Class)(class$org$netbeans$modules$image$CustomZoomAction == null ? (class$org$netbeans$modules$image$CustomZoomAction = ImageViewer.class$("org.netbeans.modules.image.CustomZoomAction")) : class$org$netbeans$modules$image$CustomZoomAction));
        sa.putValue("ShortDescription", (Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("LBL_CustomZoom"));
        toolBar.add((Action)sa);
        toolBar.addSeparator(new Dimension(11, 2));
        toolBar.add(this.getGridButton());
        return toolBar;
    }

    private void updateName() {
        String name = this.storedObject.getNodeDelegate().getDisplayName();
        this.setName(name);
        FileObject fo = this.storedObject.getPrimaryFile();
        StringBuffer fullName = new StringBuffer(fo.getPackageName('.'));
        String extension = fo.getExt();
        if (extension.length() > 0) {
            fullName.append(" [");
            fullName.append(extension);
            fullName.append(']');
        }
        this.setToolTipText(fullName.toString());
    }

    public void open(Workspace workspace) {
        if (this.discard()) {
            return;
        }
        Workspace realWorkspace = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace;
        this.dockIfNeeded(realWorkspace);
        boolean modeVisible = false;
        TopComponent[] tcArray = this.editorMode(realWorkspace).getTopComponents();
        int i = 0;
        while (i < tcArray.length) {
            if (tcArray[i].isOpened(realWorkspace)) {
                modeVisible = true;
                break;
            }
            ++i;
        }
        if (!modeVisible) {
            this.openOtherEditors(realWorkspace);
        }
        super.open(workspace);
        this.openOnOtherWorkspaces(realWorkspace);
    }

    private void superOpen(Workspace workspace) {
        super.open(workspace);
    }

    private void openOnOtherWorkspaces(Workspace workspace) {
        Workspace[] workspaces = WindowManager.getDefault().getWorkspaces();
        Mode curEditorMode = null;
        Mode tcMode = null;
        int i = 0;
        while (i < workspaces.length) {
            if (!workspaces[i].equals(workspace)) {
                curEditorMode = workspaces[i].findMode("editor");
                tcMode = workspaces[i].findMode((TopComponent)this);
                if (!this.isOpened(workspaces[i]) && curEditorMode != null && (tcMode == null || tcMode.equals(curEditorMode))) {
                    TopComponent[] tcArray = curEditorMode.getTopComponents();
                    int j = 0;
                    while (j < tcArray.length) {
                        if (tcArray[j].isOpened(workspaces[i])) {
                            this.pureOpen((TopComponent)this, workspaces[i]);
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private void openOtherEditors(Workspace workspace) {
        HashSet<TopComponent> topComps = new HashSet<TopComponent>(15);
        Workspace[] wsArray = WindowManager.getDefault().getWorkspaces();
        Mode curEditorMode = null;
        TopComponent[] tcArray = null;
        int i = 0;
        while (i < wsArray.length) {
            curEditorMode = wsArray[i].findMode("editor");
            if (curEditorMode != null) {
                tcArray = curEditorMode.getTopComponents();
                int j = 0;
                while (j < tcArray.length) {
                    if (tcArray[j].isOpened(wsArray[i])) {
                        topComps.add(tcArray[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Iterator iter = topComps.iterator();
        while (iter.hasNext()) {
            this.pureOpen((TopComponent)iter.next(), workspace);
        }
    }

    private void pureOpen(TopComponent tc, Workspace workspace) {
        if (tc instanceof ImageViewer) {
            ((ImageViewer)tc).dockIfNeeded(workspace);
            ((ImageViewer)tc).superOpen(workspace);
        } else {
            tc.open(workspace);
        }
    }

    private void dockIfNeeded(Workspace workspace) {
        Mode ourMode = workspace.findMode((TopComponent)this);
        if (ourMode == null) {
            this.editorMode(workspace).dockInto((TopComponent)this);
        }
    }

    private Mode editorMode(Workspace workspace) {
        Mode ourMode = workspace.findMode((TopComponent)this);
        if (ourMode == null) {
            ourMode = workspace.createMode("editor", ((Component)((Object)this)).getName(), (class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = ImageViewer.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport).getResource("/org/openide/resources/editorMode.gif"));
        }
        return ourMode;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer);
    }

    private boolean discard() {
        return this.storedObject == null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject((Object)this.storedObject);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.storedObject = (ImageDataObject)((Object)in.readObject());
        ((ImageOpenSupport)this.storedObject.getCookie(class$org$netbeans$modules$image$ImageOpenSupport == null ? (class$org$netbeans$modules$image$ImageOpenSupport = ImageViewer.class$("org.netbeans.modules.image.ImageOpenSupport")) : class$org$netbeans$modules$image$ImageOpenSupport)).prepareViewer();
        this.initialize(this.storedObject);
    }

    protected CloneableTopComponent createClonedObject() {
        return new ImageViewer(this.storedObject);
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] oldValue = super.getSystemActions();
        return SystemAction.linkActions((SystemAction[])new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$image$ZoomInAction == null ? (class$org$netbeans$modules$image$ZoomInAction = ImageViewer.class$("org.netbeans.modules.image.ZoomInAction")) : class$org$netbeans$modules$image$ZoomInAction)), SystemAction.get((Class)(class$org$netbeans$modules$image$ZoomOutAction == null ? (class$org$netbeans$modules$image$ZoomOutAction = ImageViewer.class$("org.netbeans.modules.image.ZoomOutAction")) : class$org$netbeans$modules$image$ZoomOutAction)), SystemAction.get((Class)(class$org$netbeans$modules$image$CustomZoomAction == null ? (class$org$netbeans$modules$image$CustomZoomAction = ImageViewer.class$("org.netbeans.modules.image.CustomZoomAction")) : class$org$netbeans$modules$image$CustomZoomAction)), null}, (SystemAction[])oldValue);
    }

    public Image getIcon() {
        return Utilities.loadImage((String)"org/netbeans/modules/image/imageObject.gif");
    }

    public void zoomIn() {
        this.scaleIn();
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    public void zoomOut() {
        double oldScale = this.scale;
        this.scaleOut();
        if (!this.isNewSizeOK()) {
            this.scale = oldScale;
            return;
        }
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    private void resizePanel() {
        this.panel.setPreferredSize(new Dimension((int)(this.getScale() * (double)this.storedImage.getIconWidth()), (int)(this.getScale() * (double)this.storedImage.getIconHeight())));
        this.panel.revalidate();
    }

    private boolean isNewSizeOK() {
        return this.getScale() * (double)this.storedImage.getIconWidth() > 1.0 && this.getScale() * (double)this.storedImage.getIconWidth() > 1.0;
    }

    public void customZoom(int fx, int fy) {
        double oldScale = this.scale;
        this.scale = (double)fx / (double)fy;
        if (!this.isNewSizeOK()) {
            this.scale = oldScale;
            return;
        }
        this.resizePanel();
        this.panel.repaint(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    private double getScale() {
        return this.scale;
    }

    private void scaleOut() {
        this.scale /= this.changeFactor;
    }

    private void scaleIn() {
        double oldComputedScale = this.getScale();
        this.scale = this.changeFactor * this.scale;
        double newComputedScale = this.getScale();
        if (newComputedScale == oldComputedScale) {
            this.scale = newComputedScale + 1.0;
        }
    }

    private JButton getZoomButton(final int xf, final int yf) {
        JButton button = new JButton("" + xf + ":" + yf);
        if (xf < yf) {
            button.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("LBL_ZoomOut") + " " + xf + " : " + yf);
        } else {
            button.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("LBL_ZoomIn") + " " + xf + " : " + yf);
        }
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACS_Zoom_BTN"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.customZoom(xf, yf);
            }
        });
        return button;
    }

    private JButton getGridButton() {
        JButton button = new JButton(" # ");
        button.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("LBL_ZoomOut"));
        button.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACS_Grid_BTN"));
        button.setMnemonic(NbBundle.getBundle((Class)(class$org$netbeans$modules$image$ImageViewer == null ? (class$org$netbeans$modules$image$ImageViewer = ImageViewer.class$("org.netbeans.modules.image.ImageViewer")) : class$org$netbeans$modules$image$ImageViewer)).getString("ACS_Grid_BTN_Mnem").charAt(0));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageViewer.this.showGrid = !ImageViewer.this.showGrid;
                ImageViewer.this.panel.repaint(0, 0, ImageViewer.this.panel.getWidth(), ImageViewer.this.panel.getHeight());
            }
        });
        return button;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

