/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.UserCancelException;

public class ResourcePanel
extends JPanel {
    public static final String PROP_RESOURCE = "property_resource";
    private I18nString i18nString;
    private JButton newButton;
    private JButton browseButton;
    private JPanel jPanel1;
    private JTextField resourceText;
    private JLabel resourceLabel;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public ResourcePanel() {
        this.initComponents();
        this.initAccessibility();
    }

    public void setI18nString(I18nString i18nString) {
        this.i18nString = i18nString;
        this.updateValues();
    }

    private void updateValues() {
        this.resourceText.setText(this.getResourceName(this.i18nString.getSupport().getResourceHolder().getResource()));
    }

    private void changeResource(DataObject resource) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        DataObject oldValue = this.i18nString.getSupport().getResourceHolder().getResource();
        if (oldValue != null && oldValue.equals(resource)) {
            return;
        }
        this.i18nString.getSupport().getResourceHolder().setResource(resource);
        this.updateValues();
        this.firePropertyChange(PROP_RESOURCE, oldValue, resource);
        I18nUtil.getOptions().setLastResource(resource);
    }

    private void resourceTextActionPerformedDelegate(ActionEvent evt) {
        DataObject resource = this.findResource(this.resourceText.getText());
        if (resource != null) {
            this.changeResource(resource);
        } else {
            this.resourceText.setText(this.getResourceName(this.i18nString.getSupport().getResourceHolder().getResource()));
        }
    }

    private DataObject findResource(String bundleName) {
        try {
            bundleName = bundleName.replace('.', '/');
            String resourceName = bundleName + ".properties";
            FileObject fileObject = null;
            Enumeration en = Repository.getDefault().getFileSystems();
            while (en.hasMoreElements()) {
                fileObject = ((FileSystem)en.nextElement()).findResource(resourceName);
                if (fileObject != null) break;
            }
            if (fileObject == null) {
                return null;
            }
            DataObject dataObject = DataObject.find(fileObject);
            if (this.isResourceClass(dataObject.getClass())) {
                return dataObject;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean isResourceClass(Class clazz) {
        return Arrays.asList(this.i18nString.getSupport().getResourceHolder().getResourceClasses()).contains(clazz);
    }

    private String getResourceName(DataObject resource) {
        if (resource == null) {
            return "";
        }
        return resource.getPrimaryFile().getPackageName('.');
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_ResourcePanel"));
        this.newButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_NewButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_BrowseButton"));
        this.resourceText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_ResourceText"));
    }

    private void initComponents() {
        this.resourceLabel = new JLabel();
        this.resourceText = new JTextField();
        this.jPanel1 = new JPanel();
        this.browseButton = new JButton();
        this.newButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.resourceLabel.setText(I18nUtil.getBundle().getString("LBL_BundleName"));
        this.resourceLabel.setLabelFor(this.resourceText);
        this.resourceLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_BundleName_Mnem").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.resourceLabel, gridBagConstraints);
        this.resourceText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourcePanel.this.resourceTextActionPerformed(evt);
            }
        });
        this.resourceText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ResourcePanel.this.resourceTextFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.resourceText, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(1, 2, 5, 0));
        this.browseButton.setMnemonic(I18nUtil.getBundle().getString("CTL_BrowseButton_Mnem").charAt(0));
        this.browseButton.setText(I18nUtil.getBundle().getString("CTL_BrowseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourcePanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.browseButton);
        this.newButton.setMnemonic(I18nUtil.getBundle().getString("CTL_NewButton_Mnem").charAt(0));
        this.newButton.setText(I18nUtil.getBundle().getString("CTL_NewButton"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourcePanel.this.newButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.newButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 0, 11, 11);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        try {
            DataObject template = this.i18nString.getSupport().getResourceHolder().getTemplate(this.i18nString.getSupport().getResourceHolder().getResourceClasses()[0]);
            DataObject resource = ResourcePanel.instantiateTemplate(template);
            if (resource != null) {
                this.changeResource(resource);
            }
        }
        catch (UserCancelException uce) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                System.err.println("I18N module: User cancelled selection");
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        block3: {
            DataFilter dataFilter = new DataFilter(){

                public boolean acceptDataObject(DataObject dataObject) {
                    return dataObject instanceof DataFolder || ResourcePanel.this.isResourceClass(dataObject.getClass());
                }
            };
            Node repositoryNode = RepositoryNodeFactory.getDefault().repository(dataFilter);
            try {
                DataObject resource = (DataObject)NodeOperation.getDefault().select(I18nUtil.getBundle().getString("CTL_SelectPropDO_Dialog_Title"), I18nUtil.getBundle().getString("CTL_SelectPropDO_Dialog_RootTitle"), repositoryNode, new NodeAcceptor(){
                    static /* synthetic */ Class class$org$openide$loaders$DataObject;

                    public boolean acceptNodes(Node[] nodes) {
                        if (nodes == null || nodes.length != 1) {
                            return false;
                        }
                        Node.Cookie cookie = nodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = 6.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                        if (cookie == null) {
                            return false;
                        }
                        return ResourcePanel.this.isResourceClass(cookie.getClass());
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                })[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ResourcePanel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                if (resource != null) {
                    this.changeResource(resource);
                }
            }
            catch (UserCancelException uce) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                System.err.println("I18N module: User cancelled selection");
            }
        }
    }

    private void resourceTextFocusLost(FocusEvent evt) {
        this.resourceTextActionPerformedDelegate(new ActionEvent(evt.getSource(), evt.getID(), null));
    }

    private void resourceTextActionPerformed(ActionEvent evt) {
        this.resourceTextActionPerformedDelegate(evt);
    }

    public void setResource(DataObject resource) {
        if (this.isResourceClass(resource.getClass())) {
            this.changeResource(resource);
        }
    }

    public static DataObject instantiateTemplate(DataObject template) throws IOException {
        ObjectNameInputPanel panel = new ObjectNameInputPanel();
        DataFilter dataFilter = new DataFilter(){

            public boolean acceptDataObject(DataObject dataObject) {
                return dataObject instanceof DataFolder;
            }
        };
        Node repositoryNode = RepositoryNodeFactory.getDefault().repository(dataFilter);
        DataFolder dataFolder = (DataFolder)NodeOperation.getDefault().select(I18nUtil.getBundle().getString("CTL_Template_Dialog_Title"), I18nUtil.getBundle().getString("CTL_Template_Dialog_RootTitle"), repositoryNode, new NodeAcceptor(){
            static /* synthetic */ Class class$org$openide$loaders$DataFolder;

            public boolean acceptNodes(Node[] nodes) {
                if (nodes == null || nodes.length != 1) {
                    return false;
                }
                DataFolder cookie = (DataFolder)nodes[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = 8.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                return cookie != null && !cookie.getPrimaryFile().isReadOnly();
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }, (Component)panel)[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = ResourcePanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        String name = panel.getText();
        DataObject newObject = name.equals("") ? template.createFromTemplate(dataFolder) : template.createFromTemplate(dataFolder, name);
        try {
            return newObject;
        }
        catch (ClassCastException cce) {
            throw new UserCancelException();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ObjectNameInputPanel
    extends JPanel {
        static final long serialVersionUID = 1980214734060402958L;
        JTextField text;

        public ObjectNameInputPanel() {
            BorderLayout layout = new BorderLayout();
            layout.setVgap(5);
            layout.setHgap(5);
            this.setLayout(layout);
            String labelText = I18nUtil.getBundle().getString("LBL_TemplateName");
            JLabel label = new JLabel(labelText.replace('&', ' '));
            this.text = new JTextField();
            this.text.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_TEXT_ObjectNameInputPanel"));
            label.setDisplayedMnemonic(labelText.charAt(labelText.indexOf(38) + 1));
            label.setLabelFor(this.text);
            this.add("West", label);
            this.add("Center", this.text);
        }

        public void requestFocus() {
            this.text.requestFocus();
        }

        public String getText() {
            return this.text.getText();
        }

        public void setText(String s) {
            this.setText(s);
        }
    }
}

