/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.NbDdeBrowserImpl;
import org.netbeans.modules.extbrowser.UnixBrowserImpl;
import org.netbeans.modules.extbrowser.WinWebBrowser;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExtWebBrowser
implements HtmlBrowser.Factory,
Serializable {
    private static final long serialVersionUID = -3021027901671504127L;
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_BROWSER_EXECUTABLE = "browserExecutable";
    public static final String PROP_START_IF_NOT_RUNNING = "startIfNotRunning";
    private String executable;
    private NbProcessDescriptor browserExecutable;
    private boolean startIfNotRunning = true;
    protected transient PropertyChangeSupport pcs;
    static /* synthetic */ Class class$org$netbeans$modules$extbrowser$ExtWebBrowser;

    public ExtWebBrowser() {
        this.init();
    }

    private void init() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getDescription() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$ExtWebBrowser == null ? (class$org$netbeans$modules$extbrowser$ExtWebBrowser = ExtWebBrowser.class$("org.netbeans.modules.extbrowser.ExtWebBrowser")) : class$org$netbeans$modules$extbrowser$ExtWebBrowser), (String)"CTL_ExternalBrowser");
    }

    public NbProcessDescriptor getBrowserExecutable() {
        if (this.browserExecutable == null || "".equals(this.browserExecutable.getProcessName())) {
            return this.defaultBrowserExecutable();
        }
        return this.browserExecutable;
    }

    public void setBrowserExecutable(NbProcessDescriptor browserExecutable) {
        NbProcessDescriptor old = this.browserExecutable;
        this.browserExecutable = browserExecutable;
        this.pcs.firePropertyChange(PROP_BROWSER_EXECUTABLE, old, browserExecutable);
    }

    public boolean isStartWhenNotRunning() {
        return true;
    }

    public void setStartWhenNotRunning(boolean s) {
        if (s != this.startIfNotRunning) {
            this.startIfNotRunning = s;
            this.pcs.firePropertyChange(PROP_START_IF_NOT_RUNNING, !this.startIfNotRunning, this.startIfNotRunning);
        }
    }

    protected NbProcessDescriptor defaultBrowserExecutable() {
        return new NbProcessDescriptor("netscape", "");
    }

    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        ExtBrowserImpl impl = null;
        if (Utilities.isUnix()) {
            impl = new UnixBrowserImpl(this);
        } else if (Utilities.isWindows()) {
            impl = new NbDdeBrowserImpl(new WinWebBrowser());
        }
        return impl;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.executable != null) {
            if (this.executable.charAt(0) == '\"') {
                int idx = this.executable.indexOf(34, 1);
                this.executable = idx > 0 ? this.executable.substring(1, idx) : this.executable.substring(1);
            }
            this.browserExecutable = new NbProcessDescriptor(this.executable, "");
            this.executable = null;
        }
        this.init();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

