/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.awt.Component;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.extbrowser.URLUtil;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class SimpleExtBrowser
implements HtmlBrowser.Factory,
Serializable {
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_BROWSER_EXECUTABLE = "browserExecutable";
    private NbProcessDescriptor process = Utilities.getOperatingSystem() == 1024 ? new NbProcessDescriptor("Netscape.exe", " {URL}", NbBundle.getBundle((Class)(class$org$netbeans$modules$extbrowser$SimpleExtBrowser == null ? (class$org$netbeans$modules$extbrowser$SimpleExtBrowser = SimpleExtBrowser.class$("org.netbeans.modules.extbrowser.SimpleExtBrowser")) : class$org$netbeans$modules$extbrowser$SimpleExtBrowser)).getString("MSG_BrowserExecutorHint")) : new NbProcessDescriptor("", " {URL}", NbBundle.getBundle((Class)(class$org$netbeans$modules$extbrowser$SimpleExtBrowser == null ? (class$org$netbeans$modules$extbrowser$SimpleExtBrowser = SimpleExtBrowser.class$("org.netbeans.modules.extbrowser.SimpleExtBrowser")) : class$org$netbeans$modules$extbrowser$SimpleExtBrowser)).getString("MSG_BrowserExecutorHint"));
    protected String name;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final long serialVersionUID = -8494345762328555637L;
    static /* synthetic */ Class class$org$netbeans$modules$extbrowser$SimpleExtBrowser;

    public String getDescription() {
        if (this.name == null) {
            try {
                return Introspector.getBeanInfo(this.getClass()).getBeanDescriptor().getDisplayName();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return this.name;
    }

    public void setDescription(String name) {
        if (!name.equals(this.name)) {
            String old = this.name;
            this.name = name;
            this.pcs.firePropertyChange(PROP_DESCRIPTION, old, name);
        }
    }

    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        return new SimpleExtBrowserImpl();
    }

    public NbProcessDescriptor getBrowserExecutable() {
        return this.process;
    }

    public void setBrowserExecutable(NbProcessDescriptor process) {
        NbProcessDescriptor old = this.process;
        this.process = process;
        this.pcs.firePropertyChange(PROP_BROWSER_EXECUTABLE, old, process);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BrowserFormat
    extends MapFormat {
        private static final long serialVersionUID = 5990981835151848381L;
        public static final String TAG_URL = "URL";

        public BrowserFormat(String url) {
            super(new HashMap());
            Map map = this.getMap();
            map.put(TAG_URL, url);
        }
    }

    public class SimpleExtBrowserImpl
    extends HtmlBrowser.Impl {
        PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
        URL url;
        static /* synthetic */ Class class$org$netbeans$modules$extbrowser$SimpleExtBrowser;

        SimpleExtBrowserImpl() {
        }

        public void setURL(URL url) {
            if (url == null) {
                return;
            }
            try {
                if (url.getProtocol().equals("nbfs")) {
                    url = URLUtil.createExternalURL(url);
                }
                SimpleExtBrowser.this.process.exec((Format)((Object)new BrowserFormat(url == null ? "" : url.toString())));
                this.url = url;
            }
            catch (IOException ex) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$extbrowser$SimpleExtBrowser == null ? (class$org$netbeans$modules$extbrowser$SimpleExtBrowser = SimpleExtBrowserImpl.class$("org.netbeans.modules.extbrowser.SimpleExtBrowser")) : class$org$netbeans$modules$extbrowser$SimpleExtBrowser)).getString("EXC_Invalid_Processor"), -1, 2));
            }
        }

        public void reloadDocument() {
            if (this.url != null) {
                this.setURL(this.url);
            }
        }

        public void stopLoading() {
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        public boolean isForward() {
            return false;
        }

        public void forward() {
        }

        public boolean isBackward() {
            return false;
        }

        public void backward() {
        }

        public boolean isHistory() {
            return false;
        }

        public void showHistory() {
        }

        public String getStatusMessage() {
            return "";
        }

        public String getTitle() {
            return "";
        }

        public URL getURL() {
            return this.url;
        }

        public Component getComponent() {
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

