/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;

public class URLUtil {
    private static Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$filesystems$URLMapper == null ? (class$org$openide$filesystems$URLMapper = URLUtil.class$("org.openide.filesystems.URLMapper")) : class$org$openide$filesystems$URLMapper));
    static /* synthetic */ Class class$org$openide$filesystems$URLMapper;

    public static URL createExternalURL(URL url) {
        if (url == null) {
            return null;
        }
        if (URLUtil.isAcceptableProtocol(url.getProtocol().toLowerCase())) {
            return url;
        }
        String anchor = url.getRef();
        String urlString = url.toString();
        int ind = urlString.indexOf(35);
        if (ind >= 0) {
            urlString = urlString.substring(0, ind);
        }
        try {
            URL newUrl;
            FileObject[] fos = URLMapper.findFileObjects((URL)new URL(urlString));
            if (fos != null && fos.length > 0 && (newUrl = URLUtil.getURLOfAppropriateType(fos[0])) != null) {
                urlString = newUrl.toString();
                if (ind >= 0) {
                    urlString = urlString + "#" + anchor;
                }
                return new URL(urlString);
            }
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return url;
    }

    private static URL getURLOfAppropriateType(FileObject fo) {
        URL suitable = null;
        Iterator instances = result.allInstances().iterator();
        while (instances.hasNext()) {
            URLMapper mapper = (URLMapper)instances.next();
            URL retVal = mapper.getURL(fo, 1);
            if (retVal == null || !URLUtil.isAcceptableProtocol(retVal.getProtocol().toLowerCase())) continue;
            if ("file".equals(retVal.getProtocol().toLowerCase())) {
                return retVal;
            }
            suitable = retVal;
        }
        if (suitable != null) {
            return suitable;
        }
        return URLMapper.findURL((FileObject)fo, (int)2);
    }

    private static boolean isAcceptableProtocol(String protocol) {
        return "http".equals(protocol) || "ftp".equals(protocol) || "file".equals(protocol);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

