/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.Format;
import javax.swing.SwingUtilities;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.URLUtil;
import org.netbeans.modules.extbrowser.UnixWebBrowser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class UnixBrowserImpl
extends ExtBrowserImpl {
    private static boolean debug = false;
    private transient int currWinID = -1;
    int nOfProbes = 3;
    int probeDelayLength = 3000;
    private ExtWebBrowser extBrowserFactory;
    static /* synthetic */ Class class$org$netbeans$modules$extbrowser$UnixBrowserImpl;

    public UnixBrowserImpl() {
        this(null);
    }

    public UnixBrowserImpl(ExtWebBrowser extBrowserFactory) {
        this.extBrowserFactory = extBrowserFactory;
    }

    public void backward() {
    }

    public void forward() {
    }

    public boolean isBackward() {
        return false;
    }

    public boolean isForward() {
        return false;
    }

    public boolean isHistory() {
        return false;
    }

    public void reloadDocument() {
        if (this.url != null) {
            this.setURL(this.url);
        }
    }

    public void setURL(URL url) {
        if (SwingUtilities.isEventDispatchThread()) {
            final URL newUrl = url;
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    UnixBrowserImpl.this.setURL(newUrl);
                }
            });
            return;
        }
        NbProcessDescriptor cmd = this.extBrowserFactory.getBrowserExecutable();
        StatusDisplayer sd = StatusDisplayer.getDefault();
        try {
            if (ExtBrowserImpl.isInternalProtocol(url.getProtocol())) {
                url = URLUtil.createExternalURL(url);
            }
            if (this.currWinID != -1 && this.getXProperty(this.currWinID, "WM_NAME") == null) {
                this.currWinID = -1;
            }
            if (this.currWinID == -1) {
                cmd = new NbProcessDescriptor("xwininfo", "-name " + this.getCommand(false));
                Process p = cmd.exec();
                if (p.waitFor() == 0) {
                    cmd = this.extBrowserFactory.getBrowserExecutable();
                    sd.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Running_command", (Object)cmd.getProcessName()));
                    p = cmd.exec((Format)((Object)new UnixWebBrowser.UnixBrowserFormat("-raise -remote openURL(\"" + url.toString() + "\",new-window)")));
                    if (p.waitFor() != 0) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Cant_run_netscape", (Object[])new Object[]{cmd.getProcessName()}), 2));
                        return;
                    }
                } else {
                    cmd = this.extBrowserFactory.getBrowserExecutable();
                    sd.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Running_command", (Object)cmd.getProcessName()));
                    p = cmd.exec((Format)((Object)new UnixWebBrowser.UnixBrowserFormat("\"" + url.toString() + "\"")));
                }
                new Thread(new WindowFinder(url.toString())).start();
            } else {
                cmd = this.extBrowserFactory.getBrowserExecutable();
                sd.setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Running_command", (Object)cmd.getProcessName()));
                Process p = cmd.exec((Format)((Object)new UnixWebBrowser.UnixBrowserFormat("-id 0x" + Integer.toHexString(this.currWinID) + " -raise -remote openURL(\"" + url.toString() + "\")")));
                if (p.waitFor() != 0) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Cant_run_netscape", (Object[])new Object[]{cmd.getProcessName()}), 2));
                    return;
                }
            }
            URL old = this.url;
            this.url = url;
            this.pcs.firePropertyChange("url", old, url);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    StatusDisplayer.getDefault().setStatusText("");
                }
            }, 2000, 1);
        }
        catch (IOException ex) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = UnixBrowserImpl.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_Cant_run_netscape", (Object[])new Object[]{cmd.getProcessName()}), 2));
        }
        catch (InterruptedException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        catch (NumberFormatException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void showHistory() {
    }

    public void stopLoading() {
    }

    private void setWindowID(int winID) {
        if (debug) {
            System.out.println("setWindowID to " + Integer.toHexString(winID));
        }
        this.currWinID = winID;
    }

    private String getXProperty(int winID, String propName) {
        try {
            BufferedReader r;
            String result;
            Process p = Runtime.getRuntime().exec("xprop -id 0x" + Integer.toHexString(winID) + " " + propName);
            if (p.waitFor() == 0 && (result = (r = new BufferedReader(new InputStreamReader(p.getInputStream()))).readLine()) != null && result.startsWith(propName + "(STRING)")) {
                int b = result.indexOf(34);
                int e = result.indexOf(34, b + 1);
                if (b == -1 || e == -1) {
                    return null;
                }
                return result.substring(b + 1, e);
            }
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private String getCommand(boolean wholePath) {
        NbProcessDescriptor process;
        String exec = "netscape";
        if (this.extBrowserFactory != null && (process = this.extBrowserFactory.getBrowserExecutable()) != null) {
            exec = process.getProcessName();
        }
        if (!wholePath) {
            int idx = exec.lastIndexOf(47);
            if (idx == -1 && Utilities.isWindows()) {
                idx = exec.lastIndexOf(92);
            }
            if (idx != -1 && exec.length() > idx) {
                exec = exec.substring(idx + 1);
            }
            if (exec.length() > 0) {
                exec = Character.toUpperCase(exec.charAt(0)) + exec.substring(1);
            }
        }
        return exec;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class WindowFinder
    implements Runnable {
        String url;
        static /* synthetic */ Class class$org$netbeans$modules$extbrowser$UnixBrowserImpl;

        public WindowFinder(String url) {
            this.url = url;
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            try {
                String prop;
                int winID;
                String s;
                String line;
                BufferedReader r;
                int errCode;
                InputStream inp;
                Process p;
                int i = UnixBrowserImpl.this.nOfProbes;
                while (i > 0) {
                    UnixBrowserImpl.this.setStatusMessage(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? WindowFinder.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl") : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_look_for_win"));
                    p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "xwininfo -root -tree|grep " + UnixBrowserImpl.this.getCommand(false)});
                    inp = p.getInputStream();
                    errCode = p.waitFor();
                    if (errCode == 0) {
                        r = new BufferedReader(new InputStreamReader(inp));
                        while ((line = r.readLine()) != null) {
                            void var5_7;
                            s = var5_7.substring(var5_7.indexOf(120) + 1);
                            winID = Integer.parseInt(s = s.substring(0, s.indexOf(32)), 16);
                            prop = UnixBrowserImpl.this.getXProperty(winID, "_MOZILLA_URL");
                            if (prop == null || !prop.equals(this.url)) continue;
                            UnixBrowserImpl.this.setWindowID(winID);
                            UnixBrowserImpl.this.setTitle(UnixBrowserImpl.this.getXProperty(winID, "WM_NAME"));
                            return;
                        }
                    }
                    Thread.sleep(UnixBrowserImpl.this.probeDelayLength);
                    --i;
                }
                UnixBrowserImpl.this.setStatusMessage(NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$UnixBrowserImpl == null ? (class$org$netbeans$modules$extbrowser$UnixBrowserImpl = WindowFinder.class$("org.netbeans.modules.extbrowser.UnixBrowserImpl")) : class$org$netbeans$modules$extbrowser$UnixBrowserImpl), (String)"MSG_look_for_win"));
                p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "xwininfo -root -tree|grep " + UnixBrowserImpl.this.getCommand(false)});
                inp = p.getInputStream();
                errCode = p.waitFor();
                if (errCode == 0) {
                    r = new BufferedReader(new InputStreamReader(inp));
                    while ((line = r.readLine()) != null) {
                        s = line.substring(line.indexOf(120) + 1);
                        winID = Integer.parseInt(s = s.substring(0, s.indexOf(32)), 16);
                        prop = UnixBrowserImpl.this.getXProperty(winID, "WM_NAME");
                        if (prop == null) continue;
                        UnixBrowserImpl.this.setWindowID(winID);
                        return;
                    }
                }
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

