/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.javac.v8.util;

import org.netbeans.lib.javac.v8.util.Name;

public class Convert {
    public static int string2int(String string, int n) throws NumberFormatException {
        if (n == 10) {
            return Integer.parseInt(string, n);
        }
        char[] cArray = string.toCharArray();
        int n2 = Integer.MAX_VALUE / (n / 2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < cArray.length) {
            int n5 = Character.digit(cArray[n4], n);
            if (n3 < 0 || n3 > n2 || n3 * n > Integer.MAX_VALUE - n5) {
                throw new NumberFormatException();
            }
            n3 = n3 * n + n5;
            ++n4;
        }
        return n3;
    }

    public static long string2long(String string, int n) throws NumberFormatException {
        if (n == 10) {
            return Long.parseLong(string, n);
        }
        char[] cArray = string.toCharArray();
        long l = Long.MAX_VALUE / (long)(n / 2);
        long l2 = 0L;
        int n2 = 0;
        while (n2 < cArray.length) {
            int n3 = Character.digit(cArray[n2], n);
            if (l2 < 0L || l2 > l || l2 * (long)n > Long.MAX_VALUE - (long)n3) {
                throw new NumberFormatException();
            }
            l2 = l2 * (long)n + (long)n3;
            ++n2;
        }
        return l2;
    }

    public static int utf2chars(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        int n6 = n + n3;
        while (n4 < n6) {
            int n7;
            if ((n7 = byArray[n4++] & 0xFF) >= 224) {
                n7 = (n7 & 0xF) << 12;
                n7 |= (byArray[n4++] & 0x3F) << 6;
                n7 |= byArray[n4++] & 0x3F;
            } else if (n7 >= 192) {
                n7 = (n7 & 0x1F) << 6;
                n7 |= byArray[n4++] & 0x3F;
            }
            cArray[n5++] = (char)n7;
        }
        return n5;
    }

    public static char[] utf2chars(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = Convert.utf2chars(byArray, n, cArray, 0, n2);
        char[] cArray2 = new char[n3];
        System.arraycopy(cArray, 0, cArray2, 0, n3);
        return cArray2;
    }

    public static char[] utf2chars(byte[] byArray) {
        return Convert.utf2chars(byArray, 0, byArray.length);
    }

    public static String utf2string(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = Convert.utf2chars(byArray, n, cArray, 0, n2);
        return new String(cArray, 0, n3);
    }

    public static String utf2string(byte[] byArray) {
        return Convert.utf2string(byArray, 0, byArray.length);
    }

    public static int chars2utf(char[] cArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n + n3;
        int n6 = n;
        while (n6 < n5) {
            char c = cArray[n6];
            if ('\u0001' <= c && c <= '\u007f') {
                byArray[n4++] = (byte)c;
            } else if (c <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c >> 6);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
            } else {
                byArray[n4++] = (byte)(0xE0 | c >> 12);
                byArray[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
            }
            ++n6;
        }
        return n4;
    }

    public static byte[] chars2utf(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[n2 * 3];
        int n3 = Convert.chars2utf(cArray, n, byArray, 0, n2);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] chars2utf(char[] cArray) {
        return Convert.chars2utf(cArray, 0, cArray.length);
    }

    public static byte[] string2utf(String string) {
        return Convert.chars2utf(string.toCharArray());
    }

    public static String quote(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    if (c < ' ' || '\u0080' <= c && c < '\u00ff') {
                        stringBuffer.append("\\");
                        stringBuffer.append((char)(48 + (c >> 6) % 8));
                        stringBuffer.append((char)(48 + (c >> 3) % 8));
                        stringBuffer.append((char)(48 + c % 8));
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String escapeUnicode(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c > '\u00ff') {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(0, n2));
                while (n2 < n) {
                    c = string.charAt(n2);
                    if (c > '\u00ff') {
                        stringBuffer.append("\\u");
                        Character.forDigit((c >> 12) % 16, 16);
                        Character.forDigit((c >> 8) % 16, 16);
                        Character.forDigit((c >> 4) % 16, 16);
                        Character.forDigit(c % 16, 16);
                    } else {
                        stringBuffer.append(c);
                    }
                    ++n2;
                }
                string = stringBuffer.toString();
                continue;
            }
            ++n2;
        }
        return string;
    }

    public static Name shortName(Name name) {
        return name.subName(name.lastIndexOf((byte)46) + 1, name.len);
    }

    public static Name packagePart(Name name) {
        return name.subName(0, name.lastIndexOf((byte)46));
    }
}

