/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat4;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;
import org.apache.tomcat.util.buf.CharChunk;

public class OutputBuffer
extends Writer
implements ByteChunk.ByteOutputChannel,
CharChunk.CharOutputChannel {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    static final int debug = 0;
    public final int INITIAL_STATE = 0;
    public final int CHAR_STATE = 1;
    public final int BYTE_STATE = 2;
    private ByteChunk bb;
    private CharChunk cb;
    private int state = 0;
    private int bytesWritten = 0;
    private int charsWritten = 0;
    private boolean closed = false;
    private boolean doFlush = false;
    private ByteChunk outputChunk = new ByteChunk();
    private String enc;
    private boolean gotEnc = false;
    protected Hashtable encoders = new Hashtable();
    protected C2BConverter conv;
    private Response coyoteResponse;
    private boolean suspended = false;

    public OutputBuffer() {
        this(8192);
    }

    public OutputBuffer(int size) {
        this.bb = new ByteChunk(size);
        this.bb.setLimit(size);
        this.bb.setByteOutputChannel((ByteChunk.ByteOutputChannel)this);
        this.cb = new CharChunk(size);
        this.cb.setCharOutputChannel((CharChunk.CharOutputChannel)this);
        this.cb.setLimit(size);
    }

    public void setResponse(Response coyoteResponse) {
        this.coyoteResponse = coyoteResponse;
    }

    public Response getResponse() {
        return this.coyoteResponse;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public void recycle() {
        this.state = 0;
        this.bytesWritten = 0;
        this.charsWritten = 0;
        this.cb.recycle();
        this.bb.recycle();
        this.closed = false;
        this.suspended = false;
        if (this.conv != null) {
            this.conv.recycle();
        }
        this.gotEnc = false;
        this.enc = null;
    }

    public void close() throws IOException {
        if (this.suspended) {
            return;
        }
        if (!this.coyoteResponse.isCommitted() && this.coyoteResponse.getContentLength() == -1) {
            if (this.state == 1) {
                this.cb.flushBuffer();
                this.state = 2;
            }
            if (!this.coyoteResponse.isCommitted()) {
                this.coyoteResponse.setContentLength(this.bb.getLength());
            }
        }
        this.flush();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.suspended) {
            return;
        }
        this.doFlush = true;
        if (this.state == 1) {
            this.cb.flushBuffer();
            this.bb.flushBuffer();
            this.state = 2;
        } else if (this.state == 2) {
            this.bb.flushBuffer();
        } else if (this.state == 0) {
            this.realWriteBytes(null, 0, 0);
        }
        this.doFlush = false;
    }

    public void realWriteBytes(byte[] buf, int off, int cnt) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.coyoteResponse == null) {
            return;
        }
        if (cnt > 0) {
            this.outputChunk.setBytes(buf, off, cnt);
            this.coyoteResponse.doWrite(this.outputChunk);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.state == 1) {
            this.cb.flushBuffer();
        }
        this.state = 2;
        this.writeBytes(b, off, len);
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return;
        }
        this.bb.append(b, off, len);
        this.bytesWritten += len;
        if (this.doFlush) {
            this.bb.flushBuffer();
        }
    }

    public void writeByte(int b) throws IOException {
        if (this.suspended) {
            return;
        }
        if (this.state == 1) {
            this.cb.flushBuffer();
        }
        this.state = 2;
        this.bb.append((byte)b);
        ++this.bytesWritten;
    }

    public void write(int c) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        this.cb.append((char)c);
        ++this.charsWritten;
    }

    public void write(char[] c) throws IOException {
        if (this.suspended) {
            return;
        }
        this.write(c, 0, c.length);
    }

    public void write(char[] c, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        this.cb.append(c, off, len);
        this.charsWritten += len;
    }

    public void write(StringBuffer sb) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        int len = sb.length();
        this.charsWritten += len;
        this.cb.append(sb);
    }

    public void write(String s, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        this.charsWritten += len;
        if (s == null) {
            s = "null";
        }
        this.cb.append(s, off, len);
    }

    public void write(String s) throws IOException {
        if (this.suspended) {
            return;
        }
        this.state = 1;
        if (s == null) {
            s = "null";
        }
        this.write(s, 0, s.length());
    }

    public void flushChars() throws IOException {
        this.cb.flushBuffer();
        this.state = 2;
    }

    public boolean flushCharsNeeded() {
        return this.state == 1;
    }

    public void setEncoding(String s) {
        this.enc = s;
    }

    public void realWriteChars(char[] c, int off, int len) throws IOException {
        if (!this.gotEnc) {
            this.setConverter();
        }
        this.conv.convert(c, off, len);
        this.conv.flushBuffer();
    }

    protected void setConverter() {
        block6: {
            if (this.coyoteResponse != null) {
                this.enc = this.coyoteResponse.getCharacterEncoding();
            }
            this.gotEnc = true;
            if (this.enc == null) {
                this.enc = DEFAULT_ENCODING;
            }
            this.conv = (C2BConverter)this.encoders.get(this.enc);
            if (this.conv != null) break block6;
            try {
                this.conv = new C2BConverter(this.bb, this.enc);
                this.encoders.put(this.enc, this.conv);
            }
            catch (IOException e) {
                this.conv = (C2BConverter)this.encoders.get(DEFAULT_ENCODING);
                if (this.conv != null) break block6;
                try {
                    this.conv = new C2BConverter(this.bb, DEFAULT_ENCODING);
                    this.encoders.put(DEFAULT_ENCODING, this.conv);
                }
                catch (IOException ex) {}
            }
        }
    }

    public void flushBytes() throws IOException {
        this.bb.flushBuffer();
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public int getCharsWritten() {
        return this.charsWritten;
    }

    public boolean isNew() {
        return this.bytesWritten == 0 && this.charsWritten == 0;
    }

    public void setBufferSize(int size) {
        if (size > this.bb.getLimit()) {
            this.bb.setLimit(size);
        }
    }

    public void reset() {
        this.bb.recycle();
        this.bytesWritten = 0;
        this.cb.recycle();
        this.charsWritten = 0;
        this.gotEnc = false;
        this.enc = null;
    }

    public int getBufferSize() {
        return this.bb.getLimit();
    }

    protected void log(String s) {
        System.out.println("OutputBuffer: " + s);
    }
}

