/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.compiler;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.core.compiler.CompilerDisplayer;
import org.netbeans.core.compiler.CompilerTaskImpl;
import org.openide.ErrorManager;
import org.openide.compiler.CompilationEngine;
import org.openide.compiler.CompilerGroup;
import org.openide.compiler.CompilerGroupException;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerListener;
import org.openide.compiler.CompilerTask;
import org.openide.compiler.DependencyException;

public class CompilationEngineImpl
extends CompilationEngine {
    private LinkedList queue = new LinkedList();
    private CompilerThread t;
    CompilerDisplayer displayer = new CompilerDisplayer();
    static /* synthetic */ Class class$org$netbeans$core$compiler$CompilationEngineImpl$CompilerThread$GroupCompiler;

    public CompilationEngineImpl() {
        this.t = new CompilerThread(this.queue, this.displayer);
        this.t.start();
    }

    protected CompilerTask start(CompilerJob job) {
        CompilerTaskImpl task = null;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            Thread current;
            Object[] twins = new Object[2];
            twins[0] = job;
            task = new CompilerTaskImpl(job, this, twins);
            twins[1] = task;
            if (!this.t.isAlive()) {
                this.t = new CompilerThread(this.queue, this.displayer);
                this.t.start();
            }
            if ((current = Thread.currentThread()).getClass() == (class$org$netbeans$core$compiler$CompilationEngineImpl$CompilerThread$GroupCompiler == null ? (class$org$netbeans$core$compiler$CompilationEngineImpl$CompilerThread$GroupCompiler = CompilationEngineImpl.class$("org.netbeans.core.compiler.CompilationEngineImpl$CompilerThread$GroupCompiler")) : class$org$netbeans$core$compiler$CompilationEngineImpl$CompilerThread$GroupCompiler)) {
                this.t.runNested(twins);
            } else {
                this.queue.addLast(twins);
                this.queue.notify();
            }
        }
        return task;
    }

    public void stop() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.t.stopIt();
            CompilerThread.GroupCompiler.interruptAll();
            Iterator it = this.queue.iterator();
            while (it.hasNext()) {
                ((CompilerTaskImpl)((Object)((Object[])it.next())[1])).done();
            }
            this.queue.clear();
            this.queue.notify();
            this.t = new CompilerThread(this.queue, this.displayer);
            this.t.start();
        }
    }

    public boolean isCompiling() {
        return CompilerThread.GroupCompiler.all.size() > 0;
    }

    void stopTask(CompilerTaskImpl job) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.queue.remove(job.ref)) {
                return;
            }
            this.stop();
        }
    }

    static List createLevels(CompilerJob job) throws DependencyException {
        return CompilationEngine.createComputationLevels((CompilerJob)job);
    }

    static Collection createGroups(Collection c) throws CompilerGroupException {
        return CompilationEngine.createCompilerGroups((Collection)c);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class CompilerThread
    extends Thread {
        public LinkedList queue;
        public CompilerDisplayer displayer;
        private boolean stop;
        public CompilerJob currentJob;
        public CompilerTaskImpl currentTask;

        public CompilerThread(LinkedList queue, CompilerDisplayer displayer) {
            this.setName("Compilation");
            this.setPriority(2);
            this.setDaemon(true);
            this.queue = queue;
            this.displayer = displayer;
        }

        public void stopIt() {
            this.stop = true;
        }

        private void nextJobAndTask() throws InterruptedException {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                this.currentJob = null;
                while (this.queue.size() == 0) {
                    this.queue.wait();
                }
                Object[] twins = (Object[])this.queue.removeFirst();
                this.currentJob = (CompilerJob)twins[0];
                this.currentTask = (CompilerTaskImpl)((Object)twins[1]);
            }
        }

        public void run() {
            while (!this.stop) {
                Object var5_4;
                boolean uptodate = true;
                try {
                    try {
                        this.nextJobAndTask();
                        this.displayer.compilationStarted(this.currentTask);
                        uptodate = this.processJob();
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify(4096, (Throwable)e);
                        this.currentTask.success = false;
                        var5_4 = null;
                        this.displayer.compilationFinished(this.currentTask, uptodate & this.currentTask.success);
                        this.currentJob = null;
                        this.currentTask = null;
                        continue;
                    }
                    catch (ThreadDeath td) {
                        this.stop = true;
                        var5_4 = null;
                        this.displayer.compilationFinished(this.currentTask, uptodate & this.currentTask.success);
                        this.currentJob = null;
                        this.currentTask = null;
                        continue;
                    }
                    var5_4 = null;
                    this.displayer.compilationFinished(this.currentTask, uptodate & this.currentTask.success);
                    this.currentJob = null;
                    this.currentTask = null;
                }
                catch (Throwable throwable) {
                    var5_4 = null;
                    this.displayer.compilationFinished(this.currentTask, uptodate & this.currentTask.success);
                    this.currentJob = null;
                    this.currentTask = null;
                    throw throwable;
                }
            }
        }

        void runNested(Object[] twins) {
            CompilerJob saveJob = this.currentJob;
            CompilerTaskImpl saveTask = this.currentTask;
            try {
                this.currentJob = (CompilerJob)twins[0];
                this.currentTask = (CompilerTaskImpl)((Object)twins[1]);
                this.processJob();
                Object var5_4 = null;
                this.currentJob = saveJob;
                this.currentTask = saveTask;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.currentJob = saveJob;
                this.currentTask = saveTask;
                throw throwable;
            }
        }

        boolean processJob() {
            boolean uptodate = true;
            try {
                try {
                    ListIterator iterator = CompilationEngineImpl.createLevels(this.currentJob).listIterator();
                    CompilerGroup[] groups = new CompilerGroup[]{};
                    boolean success = true;
                    while (iterator.hasNext() && success) {
                        groups = CompilationEngineImpl.createGroups((Collection)iterator.next()).toArray(groups);
                        GroupCompiler compiler = null;
                        uptodate &= groups.length == 0;
                        int i = 0;
                        while (i < groups.length) {
                            if (groups[i] == null) break;
                            groups[i].addCompilerListener((CompilerListener)this.displayer);
                            compiler = new GroupCompiler(groups[i], compiler);
                            ++i;
                        }
                        if (compiler == null) continue;
                        success &= compiler.stay(this.displayer);
                    }
                    this.currentTask.success = success;
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                    this.currentTask.success = false;
                    Object var8_9 = null;
                    if (this.currentTask != null) {
                        this.currentTask.done();
                    }
                }
                Object var8_8 = null;
                if (this.currentTask != null) {
                    this.currentTask.done();
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (this.currentTask != null) {
                    this.currentTask.done();
                }
                throw throwable;
            }
            return uptodate;
        }

        protected static class GroupCompiler
        extends Thread {
            static Hashtable all = new Hashtable(11);
            public CompilerGroup grp;
            public GroupCompiler parent;
            public boolean status;

            public GroupCompiler(CompilerGroup grp, GroupCompiler parent) {
                this.grp = grp;
                this.parent = parent;
                this.status = true;
                this.start();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean stay(CompilerListener listener) throws InterruptedException {
                boolean bl;
                try {
                    all.put(this, this);
                    this.join();
                    this.grp.removeCompilerListener(listener);
                    if (this.parent != null) {
                        boolean bl2 = this.parent.stay(listener) && this.status;
                        Object var4_4 = null;
                        all.remove(this);
                        return bl2;
                    }
                    bl = this.status;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    all.remove(this);
                    throw throwable;
                }
                Object var4_5 = null;
                all.remove(this);
                return bl;
            }

            public void run() {
                try {
                    this.status = this.grp.start();
                }
                catch (ThreadDeath t) {
                    ErrorManager.getDefault().notify(4096, (Throwable)t);
                    this.status = false;
                }
                catch (RuntimeException re) {
                    ErrorManager.getDefault().notify(4096, (Throwable)re);
                    this.status = false;
                }
            }

            static void interruptAll() {
                Enumeration e = all.keys();
                while (e.hasMoreElements()) {
                    Thread tt = (Thread)e.nextElement();
                    tt.interrupt();
                }
            }
        }
    }
}

