/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.compiler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.compiler.CompilerTaskImpl;
import org.netbeans.core.output.OutputSettings;
import org.netbeans.core.output.OutputTabTerm;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.compiler.CompilerListener;
import org.openide.compiler.ErrorEvent;
import org.openide.compiler.ProgressEvent;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

final class CompilerDisplayer
implements CompilerListener,
ActionListener {
    private InputOutput compilerIO;
    private OutputWriter ow = null;
    private MessageFormat errorMsg;
    private MessageFormat errorDescr;
    private MessageFormat compilingMsg;
    private MessageFormat compSuccess;
    private MessageFormat compUnsuccess;
    private MessageFormat compStarted;
    private static String parsing;
    private static String generating;
    private static String writing;
    private static String cleaning;
    private Timer statusTextTimer;
    private String statusText;
    private ErrorCtl lastError;
    private boolean notSelected = true;
    int dispatcherCounts = 0;
    private long lastTime = 0L;
    static /* synthetic */ Class class$org$netbeans$core$compiler$CompilerDisplayer;
    static /* synthetic */ Class class$org$netbeans$core$output$OutputSettings;

    public CompilerDisplayer() {
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$compiler$CompilerDisplayer == null ? (class$org$netbeans$core$compiler$CompilerDisplayer = CompilerDisplayer.class$("org.netbeans.core.compiler.CompilerDisplayer")) : class$org$netbeans$core$compiler$CompilerDisplayer));
        if (parsing == null) {
            parsing = bundle.getString("MSG_StatusParsing");
            writing = bundle.getString("MSG_StatusWriting");
            generating = bundle.getString("MSG_StatusGenerating");
            cleaning = bundle.getString("MSG_StatusCleaning");
        }
        this.errorMsg = new MessageFormat(bundle.getString("MSG_CompileError"));
        this.errorDescr = new MessageFormat(bundle.getString("MSG_CompileErrorDescr"));
        this.compilingMsg = new MessageFormat(bundle.getString("MSG_Compiling"));
        this.compSuccess = new MessageFormat(bundle.getString("MSG_CompilationSuccessful"));
        this.compUnsuccess = new MessageFormat(bundle.getString("MSG_CompilationUnsuccessful"));
        this.compStarted = new MessageFormat(bundle.getString("MSG_CompilationStarted"));
    }

    public void compilerProgress(ProgressEvent ev) {
        String status = null;
        switch (ev.getTask()) {
            case 1: {
                status = parsing;
                break;
            }
            case 3: {
                status = writing;
                break;
            }
            case 2: {
                status = generating;
                break;
            }
            case 4: {
                status = cleaning;
                break;
            }
            default: {
                status = parsing;
            }
        }
        if (status == null) {
            return;
        }
        Object[] args = new Object[]{status, ev.getFile().getPath()};
        String msg = this.compilingMsg.format(args);
        this.setStatusText(msg);
    }

    public void compilerError(ErrorEvent ev) {
        SwingUtilities.invokeLater(new AWTDispatcher(ev));
    }

    final synchronized void newDispatcher() {
        ++this.dispatcherCounts;
    }

    final synchronized void dispatcherEnd() {
        --this.dispatcherCounts;
        this.notify();
    }

    final synchronized void dispatcherWait() throws InterruptedException {
        while (this.dispatcherCounts > 0) {
            this.wait();
        }
    }

    private static Object[] taskToArgs(CompilerTaskImpl task) {
        return new Object[]{task.getDisplayName(), "".equals(task.getDisplayName()) ? new Integer(0) : new Integer(1)};
    }

    void compilationStarted(CompilerTaskImpl task) {
        this.initialize();
        this.setStatusText(this.compStarted.format(CompilerDisplayer.taskToArgs(task)));
        try {
            this.ow.reset();
            this.notSelected = true;
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        this.lastError = null;
    }

    private void ensureSelect() {
        if (this.notSelected) {
            this.notSelected = false;
            this.compilerIO.select();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compilationFinished(CompilerTaskImpl task, boolean uptodate) {
        boolean always_print = true;
        if (!CompilerDisplayer.alwaysOpenAfterCompile() && task.isSuccessful() && this.compilerIO.isClosed()) {
            always_print = false;
        }
        try {
            block6: {
                try {
                    this.initialize();
                    MessageFormat msg = task.isSuccessful() ? this.compSuccess : this.compUnsuccess;
                    this.dispatcherWait();
                    String fimsg = msg.format(CompilerDisplayer.taskToArgs(task));
                    this.setStatusText(fimsg);
                    if (!always_print) break block6;
                    this.ensureSelect();
                    if (uptodate) {
                        this.println(NbBundle.getBundle((Class)(class$org$netbeans$core$compiler$CompilerDisplayer == null ? (class$org$netbeans$core$compiler$CompilerDisplayer = CompilerDisplayer.class$("org.netbeans.core.compiler.CompilerDisplayer")) : class$org$netbeans$core$compiler$CompilerDisplayer)).getString("MSG_UpToDate"));
                    }
                    this.println(fimsg);
                }
                catch (InterruptedException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                    Object var7_8 = null;
                    AnnotationImpl impl = AnnotationImpl.getAnnotation();
                    impl.detach(null);
                    if (!(this.compilerIO instanceof OutputTabTerm)) return;
                    ((OutputTabTerm)this.compilerIO).setCompilationFinished();
                    return;
                }
            }
            Object var7_7 = null;
            AnnotationImpl impl = AnnotationImpl.getAnnotation();
            impl.detach(null);
            if (!(this.compilerIO instanceof OutputTabTerm)) return;
            ((OutputTabTerm)this.compilerIO).setCompilationFinished();
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            AnnotationImpl impl = AnnotationImpl.getAnnotation();
            impl.detach(null);
            if (!(this.compilerIO instanceof OutputTabTerm)) throw throwable;
            ((OutputTabTerm)this.compilerIO).setCompilationFinished();
            throw throwable;
        }
    }

    private void initialize() {
        if (this.ow == null) {
            CompilerDisplayer compilerDisplayer = this;
            synchronized (compilerDisplayer) {
                this.setOw(NbBundle.getBundle((Class)(class$org$netbeans$core$compiler$CompilerDisplayer == null ? (class$org$netbeans$core$compiler$CompilerDisplayer = CompilerDisplayer.class$("org.netbeans.core.compiler.CompilerDisplayer")) : class$org$netbeans$core$compiler$CompilerDisplayer)).getString("CTL_CompileTab"));
            }
        }
    }

    private void setOw(String name) {
        if (this.ow != null) {
            return;
        }
        this.compilerIO = IOProvider.getDefault().getIO(name, true);
        this.compilerIO.setFocusTaken(false);
        this.ow = this.compilerIO.getOut();
    }

    public void setStatusText(String text) {
        this.statusText = text;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTime > 250L) {
            this.lastTime = this.lastTime;
            this.actionPerformed(null);
        } else {
            this.getStatusTextTimer().restart();
        }
    }

    private Timer getStatusTextTimer() {
        if (this.statusTextTimer == null) {
            this.statusTextTimer = new Timer(250, this);
            this.statusTextTimer.setRepeats(false);
        }
        return this.statusTextTimer;
    }

    public void actionPerformed(ActionEvent p1) {
        if (this.statusText == null) {
            return;
        }
        StatusDisplayer.getDefault().setStatusText(CompilerDisplayer.oneLine(this.statusText));
        this.statusText = null;
        this.lastTime = System.currentTimeMillis();
    }

    private static String oneLine(String txt) {
        StringBuffer sb = new StringBuffer(txt.length());
        boolean lastIsNewline = false;
        int i = 0;
        while (i < txt.length()) {
            char ch = txt.charAt(i);
            if (ch == '\n' || ch == '\r') {
                if (!lastIsNewline) {
                    lastIsNewline = true;
                    sb.append(' ');
                }
            } else {
                sb.append(ch);
                lastIsNewline = false;
            }
            ++i;
        }
        return sb.toString();
    }

    private static boolean alwaysOpenAfterCompile() {
        OutputSettings settings = (OutputSettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$output$OutputSettings == null ? (class$org$netbeans$core$output$OutputSettings = CompilerDisplayer.class$("org.netbeans.core.output.OutputSettings")) : class$org$netbeans$core$output$OutputSettings), (boolean)true);
        if (settings != null) {
            return settings.isAlwaysOpenAfterCompile();
        }
        return true;
    }

    final void println(String msg) {
        if (this.lastError != null) {
            OutputController ctl = new OutputController(this.lastError);
            this.lastError = null;
            try {
                this.println(msg, ctl);
            }
            catch (IOException e) {
                this.println(msg);
            }
        } else {
            this.ow.println(msg);
        }
    }

    final void println(String msg, OutputListener err) throws IOException {
        if (err instanceof ErrorCtl) {
            this.lastError = (ErrorCtl)err;
        }
        this.ow.println(msg, err);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class AnnotationImpl
    extends Annotation
    implements PropertyChangeListener {
        private static AnnotationImpl INSTANCE;
        private String text;
        private ErrorCtl currentCtl;

        AnnotationImpl() {
        }

        public static AnnotationImpl getAnnotation() {
            if (INSTANCE == null) {
                INSTANCE = new AnnotationImpl();
            }
            return INSTANCE;
        }

        public String getAnnotationType() {
            return "org-netbeans-core-compiler-error";
        }

        public String getShortDescription() {
            return this.text;
        }

        public void setShortDescription(String text) {
            this.text = text;
        }

        public void attach(ErrorCtl ctl, Line line) {
            if (this.currentCtl != null) {
                this.detach(this.currentCtl);
            }
            this.currentCtl = ctl;
            this.attach((Annotatable)line);
            line.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void detach(ErrorCtl ectl) {
            if (ectl == this.currentCtl || ectl == null) {
                this.currentCtl = null;
                Annotatable at = this.getAttachedAnnotatable();
                if (at != null) {
                    at.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.detach();
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("text".equals(ev.getPropertyName())) {
                this.detach(null);
            }
        }
    }

    final class ErrorCtl
    implements OutputListener {
        FileObject file;
        Line xline;
        int column;
        private String text;
        private String shortMsg;
        static /* synthetic */ Class class$org$openide$cookies$LineCookie;

        public ErrorCtl(FileObject fo, int line, int column, String text, String shortMsg) throws IOException {
            this.file = fo;
            this.column = column;
            DataObject data = DataObject.find((FileObject)this.file);
            LineCookie cookie = (LineCookie)data.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = ErrorCtl.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
            if (cookie == null) {
                throw new FileNotFoundException();
            }
            this.xline = cookie.getLineSet().getOriginal(line);
            this.text = text;
            this.shortMsg = shortMsg;
        }

        public void outputLineSelected(OutputEvent ev) {
            AnnotationImpl impl = AnnotationImpl.getAnnotation();
            impl.setShortDescription(this.shortMsg);
            CompilerDisplayer.this.setStatusText(this.shortMsg);
            impl.attach(this, this.xline);
            this.xline.show(0, this.column);
        }

        public void outputLineAction(OutputEvent ev) {
            AnnotationImpl impl = AnnotationImpl.getAnnotation();
            impl.setShortDescription(this.shortMsg);
            CompilerDisplayer.this.setStatusText(this.shortMsg);
            impl.attach(this, this.xline);
            this.xline.show(2, this.column);
        }

        public void outputLineCleared(OutputEvent ev) {
            AnnotationImpl impl = AnnotationImpl.getAnnotation();
            impl.detach(this);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    final class OutputController
    implements OutputListener {
        private ErrorCtl ctl;

        OutputController(ErrorCtl ctl) {
            this.ctl = ctl;
        }

        public void outputLineSelected(OutputEvent ev) {
            this.ctl.outputLineSelected(ev);
        }

        public void outputLineAction(OutputEvent ev) {
            this.ctl.outputLineAction(ev);
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    final class AWTDispatcher
    implements Runnable {
        private ErrorEvent ev;

        AWTDispatcher(ErrorEvent ev) {
            this.ev = ev;
            CompilerDisplayer.this.newDispatcher();
        }

        public void run() {
            CompilerDisplayer.this.initialize();
            CompilerDisplayer.this.ensureSelect();
            if (this.ev.getFile() == null) {
                String msg = this.ev.getMessage();
                if (!msg.equals("")) {
                    if (msg.startsWith("\n")) {
                        msg = msg.substring(1);
                    }
                    CompilerDisplayer.this.println(msg);
                    CompilerDisplayer.this.ow.flush();
                }
                CompilerDisplayer.this.dispatcherEnd();
                return;
            }
            Object[] args = new Object[]{this.ev.getFile().getPath(), new Integer(this.ev.getLine()), new Integer(this.ev.getColumn()), this.ev.getMessage()};
            String text = CompilerDisplayer.this.errorMsg.format(args);
            try {
                int line = Math.max(this.ev.getLine() - 1, 0);
                Integer lineCov = new Integer(line);
                ErrorCtl ec = new ErrorCtl(this.ev.getFile(), line, Math.max(this.ev.getColumn() - 1, 0), text, this.ev.getMessage());
                CompilerDisplayer.this.println(text, ec);
            }
            catch (IOException ex) {
                CompilerDisplayer.this.println(text);
            }
            String refText = this.ev.getReferenceText();
            if (refText != null && !refText.equals("")) {
                if (refText.startsWith("\n")) {
                    refText = refText.substring(1);
                }
                CompilerDisplayer.this.println(CompilerDisplayer.this.errorDescr.format(new Object[]{refText}));
            }
            CompilerDisplayer.this.dispatcherEnd();
        }
    }
}

