/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ResourceBundle;

public class Main {
    static final int DEFAULT_PORT = 7318;
    private static final int TIME_OUT = 3500;

    public static void main(String[] args) {
        try {
            int port = 7318;
            int lineNumber = -1;
            InetAddress host = InetAddress.getLocalHost();
            boolean canon = true;
            boolean wait = false;
            DatagramSocket s = new DatagramSocket();
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.equals("-host")) {
                    host = InetAddress.getByName(args[++i]);
                } else if (arg.equals("-port")) {
                    port = Integer.parseInt(args[++i]);
                } else if (arg.equals("-canon")) {
                    canon = true;
                } else if (arg.equals("-nocanon")) {
                    canon = false;
                } else if (arg.equals("-wait")) {
                    wait = true;
                } else if (arg.equals("-nowait")) {
                    wait = false;
                } else if (arg.equals("-help")) {
                    System.err.println(ResourceBundle.getBundle("org.netbeans.modules.openfile.Bundle").getString("TXT_launcherHelp"));
                } else if (arg.equals("-line")) {
                    lineNumber = Integer.parseInt(args[++i]);
                } else {
                    File f = new File(arg);
                    if (canon) {
                        f = f.getCanonicalFile();
                    }
                    String toSend = (wait ? "Y" : "N") + f.toString();
                    if (lineNumber != -1) {
                        toSend = toSend + "@" + lineNumber;
                        lineNumber = -1;
                    }
                    byte[] arr = toSend.getBytes();
                    DatagramPacket p = new DatagramPacket(arr, 0, arr.length, host, port);
                    s.send(p);
                    p.setLength(1);
                    if (!wait) {
                        s.setSoTimeout(3500);
                    }
                    s.receive(p);
                    if (p.getData()[0] != 0) {
                        System.exit(p.getData()[0]);
                    }
                }
                ++i;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(2);
        }
        System.exit(0);
    }
}

