/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.openfile.PackagePanel;
import org.netbeans.modules.openfile.Server;
import org.netbeans.modules.openfile.SettingsBeanInfo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class OpenFile {
    static final String JAVA_EXT = ".JAVA";
    static final String TXT_EXT = ".TXT";
    private static final String ZIP_EXT = ".ZIP";
    private static final String JAR_EXT = ".JAR";
    private static final String PACKAGE = "package";
    private static final ErrorManager em = ErrorManager.getDefault().getInstance("org.netbeans.modules.openfile");
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;
    static /* synthetic */ Class class$org$openide$cookies$ViewCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$loaders$DataLoaderPool;
    static /* synthetic */ Class class$org$netbeans$modules$openfile$OpenFile;

    public static void open(String fileName) {
        em.log("OpenFile.open: " + fileName);
        final File f = new File(fileName);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                OpenFile.open(f, false, null, -1, -1);
            }
        }, 10000);
    }

    static void open(File file, boolean wait, InetAddress address, int port, int line) {
        block26: {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException exc) {
                em.log(exc.getMessage());
            }
            em.log("    file: " + file);
            em.log("    file.exists: " + file.exists());
            em.log("    file.isFile: " + file.isFile());
            if (!file.exists() || !file.isFile()) {
                final String fileName = file.toString();
                new Thread(new Runnable(){

                    public void run() {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SettingsBeanInfo.getString("MSG_fileNotFound", fileName)));
                    }
                }).start();
                return;
            }
            FileObject fileObject = OpenFile.find(file);
            if (fileObject == null) {
                return;
            }
            try {
                Action defaultAction;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = line != -1 ? (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = OpenFile.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie) : null;
                OpenCookie openCookie = (OpenCookie)dataObject.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = OpenFile.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                ViewCookie viewCookie = (ViewCookie)dataObject.getCookie(class$org$openide$cookies$ViewCookie == null ? (class$org$openide$cookies$ViewCookie = OpenFile.class$("org.openide.cookies.ViewCookie")) : class$org$openide$cookies$ViewCookie);
                if (openCookie != null || viewCookie != null || editorCookie != null) {
                    StatusDisplayer.getDefault().setStatusText(SettingsBeanInfo.getString(wait ? "MSG_openingAndWaiting" : "MSG_opening", file.toString()));
                    if (editorCookie != null) {
                        editorCookie.open();
                        StyledDocument doc = editorCookie.openDocument();
                        JEditorPane[] panes = editorCookie.getOpenedPanes();
                        if (panes.length > 0) {
                            panes[0].setCaretPosition(NbDocument.findLineOffset((StyledDocument)doc, (int)line));
                        } else {
                            StatusDisplayer.getDefault().setStatusText(SettingsBeanInfo.getString("MSG_couldNotOpenAt"));
                        }
                    } else if (openCookie != null) {
                        openCookie.open();
                    } else {
                        viewCookie.view();
                    }
                    StatusDisplayer.getDefault().setStatusText("");
                    if (wait) {
                        Server.waitFor(dataObject, address, port);
                    }
                    break block26;
                }
                try {
                    if (fileObject.getFileSystem() instanceof JarFileSystem) {
                        return;
                    }
                }
                catch (FileStateInvalidException fse) {
                    ErrorManager.getDefault().notify(1, (Throwable)fse);
                }
                Node node = dataObject.getNodeDelegate();
                if (fileObject.isRoot()) {
                    FileSystem fs = fileObject.getFileSystem();
                    Node reponode = RepositoryNodeFactory.getDefault().repository(DataFilter.ALL);
                    Children repokids = reponode.getChildren();
                    Enumeration fsenum = repokids.nodes();
                    while (fsenum.hasMoreElements()) {
                        Node fsnode = (Node)fsenum.nextElement();
                        DataFolder df = (DataFolder)fsnode.getCookie(class$org$openide$loaders$DataFolder == null ? OpenFile.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
                        if (df == null || !df.getPrimaryFile().getFileSystem().equals(fs)) continue;
                        node = fsnode;
                        break;
                    }
                }
                Enumeration loaders = ((DataLoaderPool)Lookup.getDefault().lookup(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = OpenFile.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool)).allLoaders();
                DataLoader DDOLoader = null;
                while (loaders.hasMoreElements()) {
                    DDOLoader = (DataLoader)loaders.nextElement();
                }
                boolean opened = false;
                if (DDOLoader != null && dataObject.getClass().getName().equals(DDOLoader.getRepresentationClass().getName()) && (defaultAction = node.getPreferredAction()) != null && !(defaultAction instanceof FileSystemAction)) {
                    defaultAction.actionPerformed(new ActionEvent(node, 0, null));
                    fileObject.refresh();
                    try {
                        DataObject newDataObject = DataObject.find((FileObject)fileObject);
                        OpenCookie newOpenCookie = (OpenCookie)newDataObject.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = OpenFile.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                        if (newOpenCookie != null) {
                            newOpenCookie.open();
                            opened = true;
                        }
                    }
                    catch (DataObjectNotFoundException dnfe) {
                        ErrorManager.getDefault().notify(1, (Throwable)dnfe);
                    }
                }
                if (!opened) {
                    NodeOperation.getDefault().explore(node);
                }
                if (wait) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SettingsBeanInfo.getString("MSG_cannotOpenWillClose", file)));
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }

    private static FileObject handleZipJar(File file) {
        JarFileSystem jarFileSystem = new JarFileSystem();
        try {
            jarFileSystem.setJarFile(file);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return null;
        }
        catch (PropertyVetoException pve) {
            ErrorManager.getDefault().notify((Throwable)pve);
            return null;
        }
        Repository repository = Repository.getDefault();
        FileSystem existing = repository.findFileSystem(jarFileSystem.getSystemName());
        if (existing == null) {
            repository.addFileSystem((FileSystem)jarFileSystem);
            existing = jarFileSystem;
        }
        return existing.getRoot();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String findJavaPackage(File file) {
        pkg = "";
        packageKnown = false;
        rd = null;
        try {
            rd = new BufferedReader(new SourceReader(new FileInputStream(file)));
            rd.mark(2);
            cbuf = new char[2];
            rd.read(cbuf, 0, 2);
            if (cbuf[0] == '\u00ff' && cbuf[1] == '\u00fe') {
                rd.close();
                rd = new BufferedReader(new SourceReader((InputStream)new FileInputStream(file), "Unicode"));
            } else {
                rd.reset();
            }
            while (!packageKnown) {
                block24: {
                    line = rd.readLine();
                    if (line != null) break block24;
                    packageKnown = true;
                    var7_8 = pkg;
                    var15_15 = null;
                    ** GOTO lbl96
                }
                pckgPos = line.indexOf("package");
                if (pckgPos == -1) continue;
                tok = new StringTokenizer(line, " \t;");
                gotPackage = false;
                while (tok.hasMoreTokens()) {
                    theTok = tok.nextToken();
                    if (gotPackage) {
                        ptok = new StringTokenizer(theTok, ".");
                        ok = ptok.hasMoreTokens();
                        block13: while (ptok.hasMoreTokens()) {
                            component = ptok.nextToken();
                            if (component.length() == 0) {
                                ok = false;
                                break;
                            }
                            if (!Character.isJavaIdentifierStart(component.charAt(0))) {
                                ok = false;
                                break;
                            }
                            pos = 1;
                            while (pos < component.length()) {
                                if (!Character.isJavaIdentifierPart(component.charAt(pos))) {
                                    ok = false;
                                    continue block13;
                                }
                                ++pos;
                            }
                        }
                        if (ok) {
                            pkg = theTok;
                            packageKnown = true;
                            var12_13 = pkg;
                            var15_16 = null;
                            try {
                                if (rd == null) return var12_13;
                                rd.close();
                                return var12_13;
                            }
                            catch (IOException e2) {
                                ErrorManager.getDefault().notify((Throwable)e2);
                            }
                            return var12_13;
                        }
                        gotPackage = false;
                        continue;
                    }
                    if (theTok.equals("package")) {
                        gotPackage = true;
                        continue;
                    }
                    if (!theTok.equals("{")) continue;
                    packageKnown = true;
                    var10_11 = pkg;
                    ** GOTO lbl103
                }
            }
            ** GOTO lbl111
        }
        catch (IOException e1) {
            ErrorManager.getDefault().notify((Throwable)e1);
            var15_19 = null;
            try {}
            catch (IOException e2) {
                ErrorManager.getDefault().notify((Throwable)e2);
                return null;
            }
            if (rd == null) return null;
            rd.close();
            return null;
        }
        {
            catch (Throwable var14_27) {
                var15_20 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 393->404)] { 
lbl90:
                // 1 sources

                if (rd == null) throw var14_27;
                rd.close();
                throw var14_27;
lbl93:
                // 1 sources

                catch (IOException e2) {
                    ErrorManager.getDefault().notify((Throwable)e2);
                }
                throw var14_27;
            }
lbl96:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [2 : 393->404)] { 
lbl97:
            // 1 sources

            if (rd == null) return var7_8;
            rd.close();
            return var7_8;
lbl100:
            // 1 sources

            catch (IOException e2) {
                ErrorManager.getDefault().notify((Throwable)e2);
            }
            return var7_8;
lbl103:
            // 1 sources

            var15_17 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 393->404)] { 
lbl105:
            // 1 sources

            if (rd == null) return var10_11;
            rd.close();
            return var10_11;
lbl108:
            // 1 sources

            catch (IOException e2) {
                ErrorManager.getDefault().notify((Throwable)e2);
            }
            return var10_11;
lbl111:
            // 1 sources

            var15_18 = null;
            try {}
            catch (IOException e2) {}
            ErrorManager.getDefault().notify((Throwable)e2);
            return null;
            if (rd == null) return null;
            rd.close();
            return null;
        }
    }

    private static synchronized FileObject find(File f) {
        String fileName = f.toString();
        String fileNameUpper = fileName.toUpperCase();
        if (fileNameUpper.endsWith(ZIP_EXT) || fileNameUpper.endsWith(JAR_EXT)) {
            return OpenFile.handleZipJar(f);
        }
        FileObject[] fObjects = FileUtil.fromFile((File)f);
        if (fObjects.length > 0) {
            FileObject fileObj = fObjects[0];
            if (fObjects.length > 1) {
                if (fileNameUpper.endsWith(JAVA_EXT)) {
                    String pkg = OpenFile.findJavaPackage(f);
                    int i = 0;
                    while (i < fObjects.length) {
                        String pkg_i = "";
                        if (!fObjects[i].isRoot()) {
                            FileObject parent = fObjects[i].getParent();
                            pkg_i = parent.getPackageName('.');
                        }
                        if (pkg.equals(pkg_i)) {
                            fileObj = fObjects[i];
                            break;
                        }
                        ++i;
                    }
                } else {
                    String shortName = fileObj.getPackageName('.');
                    int i = 1;
                    while (i < fObjects.length) {
                        String name_i = fObjects[i].getPackageName('.');
                        if (name_i.length() < shortName.length()) {
                            fileObj = fObjects[i];
                            shortName = name_i;
                        }
                        ++i;
                    }
                }
            }
            return fileObj;
        }
        String pkg = null;
        boolean packageKnown = false;
        if (fileNameUpper.endsWith(JAVA_EXT)) {
            pkg = OpenFile.findJavaPackage(f);
        }
        if (pkg == null) {
            pkg = "";
            packageKnown = false;
        } else {
            packageKnown = true;
        }
        String prefix = pkg.replace('.', File.separatorChar);
        String pkgtouse = "";
        for (File dir = f.getParentFile(); !pkg.equals("") && dir != null; dir = dir.getParentFile()) {
            String trypart;
            String trypkg;
            int lastdot = pkg.lastIndexOf(46);
            if (lastdot == -1) {
                trypkg = "";
                trypart = pkg;
            } else {
                trypkg = pkg.substring(0, lastdot);
                trypart = pkg.substring(lastdot + 1);
            }
            if (dir.getName().equals(trypart) && dir.getParentFile() != null) {
                pkg = trypkg;
                if (pkgtouse.equals("")) {
                    pkgtouse = trypart;
                    continue;
                }
                pkgtouse = trypart + "." + pkgtouse;
                continue;
            }
            packageKnown = false;
            break;
        }
        File[] dirToMount = new File[]{null};
        String[] mountPackage = new String[]{null};
        int pkgLevel = 0;
        if (!pkgtouse.equals("")) {
            int pos = -1;
            do {
                pos = pkgtouse.indexOf(46, pos + 1);
                ++pkgLevel;
            } while (pos != -1);
        }
        if (!packageKnown) {
            pkgLevel = -1;
        }
        if (!fileNameUpper.endsWith(JAVA_EXT)) {
            dirToMount[0] = f.getParentFile();
            mountPackage[0] = "";
        } else {
            OpenFile.askForMountPoint(f, pkgLevel, dirToMount, mountPackage);
        }
        if (dirToMount[0] == null) {
            return null;
        }
        LocalFileSystem fs = new LocalFileSystem();
        try {
            fs.setRootDirectory(dirToMount[0]);
        }
        catch (PropertyVetoException e3) {
            ErrorManager.getDefault().notify((Throwable)e3);
            return null;
        }
        catch (IOException e4) {
            ErrorManager.getDefault().notify((Throwable)e4);
            return null;
        }
        Repository repo = Repository.getDefault();
        if (repo.findFileSystem(fs.getSystemName()) != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$openfile$OpenFile == null ? (class$org$netbeans$modules$openfile$OpenFile = OpenFile.class$("org.netbeans.modules.openfile.OpenFile")) : class$org$netbeans$modules$openfile$OpenFile)).getString("MSG_wasAlreadyMounted"), fs.getSystemName())));
            return null;
        }
        repo.addFileSystem((FileSystem)fs);
        return fs.findResource(mountPackage[0].replace('.', '/') + (mountPackage[0].equals("") ? "" : "/") + f.getName());
    }

    private static void askForMountPoint(File f, int pkgLevel, final File[] dirToMount, final String[] mountPackage) {
        final Vector<File> dirs = new Vector<File>();
        final Vector<String> pkgs = new Vector<String>();
        String pkg = "";
        File dir = f.getParentFile();
        while (dir != null) {
            dirs.add(dir);
            pkgs.add(pkg);
            if (!pkg.equals("")) {
                pkg = "." + pkg;
            }
            pkg = dir.getName() + pkg;
            dir = dir.getParentFile();
        }
        if (pkgLevel != -1) {
            String guessed = (String)pkgs.get(pkgLevel);
            dirToMount[0] = (File)dirs.get(pkgLevel);
            mountPackage[0] = guessed;
            return;
        }
        PackagePanel panel = new PackagePanel(f, pkgLevel, dirs, pkgs);
        final Dialog[] dialog = new Dialog[1];
        final JButton okButton = panel.getOKButton();
        JButton cancelButton = panel.getCancelButton();
        final JList list = panel.getList();
        dialog[0] = DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)panel, SettingsBeanInfo.getString("LBL_wizTitle"), true, new Object[]{okButton, cancelButton}, (Object)okButton, 0, new HelpCtx((class$org$netbeans$modules$openfile$OpenFile == null ? (class$org$netbeans$modules$openfile$OpenFile = OpenFile.class$("org.netbeans.modules.openfile.OpenFile")) : class$org$netbeans$modules$openfile$OpenFile).getName() + ".dialog"), new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == okButton) {
                    int idx = list.getSelectedIndex();
                    if (idx != -1) {
                        dirToMount[0] = (File)dirs.get(idx);
                        mountPackage[0] = (String)pkgs.get(idx);
                    } else {
                        System.err.println("Should not have accepted OK button");
                    }
                }
                dialog[0].dispose();
            }
        }));
        dialog[0].show();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SourceReader
    extends InputStreamReader {
        private int preRead = -1;
        private boolean inString = false;
        private boolean backslashLast = false;
        private boolean separatorLast = false;
        private static final char[] separators = new char[]{'.'};
        private static final char[] whitespaces = new char[]{' ', '\t', '\r', '\n'};

        public SourceReader(InputStream in) {
            super(in);
        }

        public SourceReader(InputStream in, String encoding) throws UnsupportedEncodingException {
            super(in, encoding);
        }

        public int read(char[] data, int pos, int len) throws IOException {
            int numRead = 0;
            char[] onechar = new char[1];
            while (numRead < len) {
                int c;
                if (this.preRead != -1) {
                    c = this.preRead;
                    this.preRead = -1;
                } else {
                    c = super.read(onechar, 0, 1);
                    if (c == -1) {
                        return numRead > 0 ? numRead : -1;
                    }
                    c = onechar[0];
                }
                if (c == 47 && !this.inString) {
                    this.preRead = super.read(onechar, 0, 1);
                    if (this.preRead == 1) {
                        this.preRead = onechar[0];
                    }
                    if (this.preRead != 42 && this.preRead != 47) {
                        data[pos++] = (char)c;
                        ++numRead;
                        if (this.preRead != -1) continue;
                        return numRead;
                    }
                    if (this.preRead == 42) {
                        this.preRead = -1;
                        do {
                            if ((c = this.moveToChar(42)) != 0) continue;
                            c = super.read(onechar, 0, 1);
                            if (c == 1) {
                                c = onechar[0];
                            }
                            if (c != 42) continue;
                            this.preRead = c;
                        } while (c != 47 && c != -1);
                    } else {
                        this.preRead = -1;
                        c = this.moveToChar(10);
                        if (c == 0) {
                            this.preRead = 10;
                        }
                    }
                    if (c != -1) continue;
                    return -1;
                }
                if (!this.inString) {
                    block24: {
                        if (SourceReader.isWhitespace(c)) {
                            do {
                                this.preRead = super.read(onechar, 0, 1);
                                if (this.preRead == -1) {
                                    return numRead > 0 ? numRead : -1;
                                }
                                this.preRead = onechar[0];
                                if (!SourceReader.isSeparator(this.preRead)) continue;
                                c = this.preRead;
                                this.preRead = -1;
                                break block24;
                            } while (SourceReader.isWhitespace(this.preRead));
                            if (this.separatorLast) {
                                c = this.preRead;
                                this.preRead = -1;
                            }
                        }
                    }
                    if (c == 34 || c == 39) {
                        this.inString = true;
                        this.separatorLast = false;
                    } else {
                        this.separatorLast = SourceReader.isSeparator(c);
                    }
                } else if (c == 34 || c == 39) {
                    if (!this.backslashLast) {
                        this.inString = false;
                    } else {
                        this.backslashLast = false;
                    }
                } else {
                    this.backslashLast = c == 92;
                }
                data[pos++] = (char)c;
                ++numRead;
            }
            return numRead;
        }

        private int moveToChar(int c) throws IOException {
            int cc;
            char[] onechar = new char[1];
            if (this.preRead != -1) {
                cc = this.preRead;
                this.preRead = -1;
            } else {
                cc = super.read(onechar, 0, 1);
                if (cc == 1) {
                    cc = onechar[0];
                }
            }
            while (cc != -1 && cc != c) {
                cc = super.read(onechar, 0, 1);
                if (cc != 1) continue;
                cc = onechar[0];
            }
            return cc == -1 ? -1 : 0;
        }

        private static boolean isSeparator(int c) {
            int i = 0;
            while (i < separators.length) {
                if (c == separators[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean isWhitespace(int c) {
            int i = 0;
            while (i < whitespaces.length) {
                if (c == whitespaces[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

