/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.io.File;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.modules.openfile.SettingsBeanInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class OpenFileAction
extends CallableSystemAction {
    static final long serialVersionUID = -3424129228987962529L;
    private static File currDir;
    static /* synthetic */ Class class$org$netbeans$modules$openfile$OpenFileAction;

    public String getName() {
        return SettingsBeanInfo.getString("LBL_openFile");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$openfile$OpenFileAction == null ? (class$org$netbeans$modules$openfile$OpenFileAction = OpenFileAction.class$("org.netbeans.modules.openfile.OpenFileAction")) : class$org$netbeans$modules$openfile$OpenFileAction);
    }

    protected String iconResource() {
        return "org/netbeans/modules/openfile/openFile.gif";
    }

    public void performAction() {
        JFileChooser chooser = new JFileChooser();
        HelpCtx.setHelpIDString((JComponent)chooser, (String)this.getHelpCtx().getHelpID());
        FileFilter currentFilter = chooser.getFileFilter();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        chooser.addChoosableFileFilter(new Filter(new String[]{".JAVA"}, NbBundle.getBundle(((Object)((Object)this)).getClass()).getString("TXT_JavaFilter")));
        chooser.addChoosableFileFilter(new Filter(new String[]{".TXT"}, NbBundle.getBundle(((Object)((Object)this)).getClass()).getString("TXT_TxtFilter")));
        chooser.setFileFilter(currentFilter);
        if (currDir == null) {
            String defaultDir = null;
            try {
                Enumeration enu = Repository.getDefault().getFileSystems();
                while (enu.hasMoreElements()) {
                    FileSystem fs = (FileSystem)enu.nextElement();
                    if (fs == null || !fs.isValid() || fs.isHidden() || fs instanceof JarFileSystem || fs.getSystemName() == null) continue;
                    defaultDir = fs.getSystemName();
                    break;
                }
            }
            catch (Exception ex) {
                defaultDir = null;
            }
            if (defaultDir != null) {
                currDir = new File(defaultDir);
            }
        }
        if (currDir != null) {
            chooser.setCurrentDirectory(currDir);
        }
        File[] files = null;
        while (chooser.showOpenDialog(null) == 0) {
            files = chooser.getSelectedFiles();
            if (files.length == 0) {
                File selected = chooser.getSelectedFile();
                if (selected != null) {
                    files = new File[]{selected};
                } else {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SettingsBeanInfo.getString("MSG_noFileSelected"), 2));
                    continue;
                }
            }
            int i = 0;
            while (i < files.length) {
                OpenFile.open(files[i], false, null, 0, -1);
                ++i;
            }
            break block3;
        }
        currDir = chooser.getCurrentDirectory();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Filter
    extends FileFilter {
        private String[] extensions;
        private String description;

        public Filter(String[] extensions, String description) {
            this.extensions = extensions;
            this.description = description;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            int i = 0;
            while (i < this.extensions.length) {
                if (file.getName().toUpperCase().endsWith(this.extensions[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

