/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.modules.openfile.Settings;
import org.netbeans.modules.openfile.SettingsBeanInfo;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class Server
implements Runnable {
    private static final int LENGTH = 512;
    private static boolean stop;
    private static DatagramSocket socket;
    private static final Set waitings;
    static /* synthetic */ Class class$org$netbeans$modules$openfile$Server;

    static void startup() {
        stop = false;
        if (!Settings.getDefault().isActualRunning()) {
            RequestProcessor rp = new RequestProcessor("OpenFile Server");
            rp.post((Runnable)new Server());
        }
    }

    public static void shutdown() {
        Server.shutDownWaitings();
        stop = true;
        if (Settings.getDefault().isActualRunning()) {
            try {
                int port = Settings.getDefault().getActualPort();
                if (port == 0) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        System.err.println("OpenFile: Port should not have been zero during shutdown!");
                    }
                    return;
                }
                DatagramPacket shutDownPacket = new DatagramPacket(new byte[]{88}, 1, InetAddress.getLocalHost(), port);
                DatagramSocket shutDownSocket = new DatagramSocket();
                try {
                    shutDownSocket.send(shutDownPacket);
                    Object var4_4 = null;
                    shutDownSocket.close();
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    shutDownSocket.close();
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static void initSocket() {
        if (socket != null) {
            socket.close();
        }
        int port = Settings.getDefault().getPort();
        try {
            socket = new DatagramSocket(port);
            Settings.getDefault().setActualPort0(port);
        }
        catch (SocketException se) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SettingsBeanInfo.getString("MSG_cannotBind", new Integer(port))));
            Settings.getDefault().setRunning(false);
            Settings.getDefault().setActualPort0(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Server.initSocket();
        DatagramPacket packet = new DatagramPacket(new byte[512], 512);
        Settings settings = Settings.getDefault();
        try {
            block23: {
                try {
                    block11: while (!stop && settings.isRunning()) {
                        byte res;
                        boolean wait;
                        int lineNumber;
                        if (settings.getPort() != settings.getActualPort()) {
                            Server.initSocket();
                        }
                        if (!settings.isActualRunning()) {
                            settings.setActualRunning0(true);
                        }
                        packet.setLength(512);
                        socket.receive(packet);
                        if (settings.getAccess() == 0 && !packet.getAddress().equals(InetAddress.getLocalHost())) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SettingsBeanInfo.getString("MSG_rejectHost", packet.getAddress())));
                            continue;
                        }
                        String fileName = new String(packet.getData(), packet.getOffset() + 1, packet.getLength() - 1);
                        int index = fileName.indexOf(64);
                        if (index == -1) {
                            lineNumber = -1;
                        } else {
                            try {
                                lineNumber = Integer.parseInt(fileName.substring(index + 1)) - 1;
                                fileName = fileName.substring(0, index);
                            }
                            catch (NumberFormatException nfe) {
                                ErrorManager.getDefault().notify((Throwable)nfe);
                                lineNumber = -1;
                            }
                        }
                        switch ((char)packet.getData()[packet.getOffset()]) {
                            case 'Y': {
                                wait = true;
                                break;
                            }
                            case 'N': {
                                wait = false;
                                break;
                            }
                            case 'X': {
                                if (!stop) continue block11;
                                break block23;
                            }
                            default: {
                                Class clazz;
                                if (class$org$netbeans$modules$openfile$Server == null) {
                                    clazz = class$org$netbeans$modules$openfile$Server = Server.class$("org.netbeans.modules.openfile.Server");
                                    throw new IOException(NbBundle.getBundle((Class)clazz).getString("EXC_bad_lead_char"));
                                }
                                clazz = class$org$netbeans$modules$openfile$Server;
                                throw new IOException(NbBundle.getBundle((Class)clazz).getString("EXC_bad_lead_char"));
                            }
                        }
                        final File f = new File(fileName);
                        if (f.exists() && f.isFile()) {
                            res = 0;
                            final InetAddress addr = packet.getAddress();
                            final int port = packet.getPort();
                            final int _lineNumber = lineNumber;
                            new Thread(new Runnable(){

                                public void run() {
                                    OpenFile.open(f, wait, addr, port, _lineNumber);
                                }
                            }).start();
                        } else {
                            final String _fileName = fileName;
                            new Thread(new Runnable(){

                                public void run() {
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SettingsBeanInfo.getString("MSG_fileNotFound", _fileName)));
                                }
                            }).start();
                            res = 1;
                        }
                        if (wait && res == 0) continue;
                        packet.getData()[0] = res;
                        packet.setLength(1);
                        socket.send(packet);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    settings.setActualRunning0(false);
                    settings.setRunning(false);
                    Object var13_15 = null;
                    if (socket != null) {
                        socket.close();
                    }
                    socket = null;
                    settings.setActualRunning0(false);
                    settings.setActualPort0(0);
                    return;
                }
            }
            Object var13_14 = null;
            if (socket != null) {
                socket.close();
            }
            socket = null;
            settings.setActualRunning0(false);
            settings.setActualPort0(0);
            return;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (socket != null) {
                socket.close();
            }
            socket = null;
            settings.setActualRunning0(false);
            settings.setActualPort0(0);
            throw throwable;
        }
    }

    static void waitFor(DataObject dataObject, InetAddress address, int port) {
        waitings.add(new Waiting(dataObject, address, port));
    }

    private static void shutDownWaitings() {
        Waiting[] allWaitings = waitings.toArray(new Waiting[waitings.size()]);
        int i = 0;
        while (i < allWaitings.length) {
            allWaitings[i].unWait((byte)2);
            ++i;
        }
        waitings.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        waitings = new HashSet();
    }

    private static class Waiting
    implements PropertyChangeListener,
    AncestorListener {
        private DataObject dataObject;
        private InetAddress address;
        private int port;
        private EditorCookie editorCookie;
        private JEditorPane observedPane;
        static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
        static /* synthetic */ Class class$org$openide$windows$TopComponent;

        public Waiting(DataObject dataObject, InetAddress address, int port) {
            this.dataObject = dataObject;
            this.address = address;
            this.port = port;
            this.init();
        }

        private void init() {
            this.dataObject.addPropertyChangeListener((PropertyChangeListener)this);
            this.editorCookie = (EditorCookie)this.dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = Waiting.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            if (this.editorCookie == null) {
                return;
            }
            JEditorPane[] panes = this.editorCookie.getOpenedPanes();
            if (panes == null || panes.length == 0) {
                return;
            }
            TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = Waiting.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, panes[0]);
            if (topComponent == null) {
                return;
            }
            topComponent.addAncestorListener(this);
        }

        private void clean() {
            this.dataObject.removePropertyChangeListener((PropertyChangeListener)this);
        }

        public void unWait(byte status) {
            this.clean();
            waitings.remove(this);
            if (socket != null) {
                DatagramPacket packet = new DatagramPacket(new byte[]{status}, 1, this.address, this.port);
                try {
                    socket.send(packet);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SettingsBeanInfo.getString("MSG_serverNotRunningWhenSaved", this.dataObject.getName())));
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.dataObject != evt.getSource()) {
                return;
            }
            if ("valid".equals(evt.getPropertyName())) {
                if (!this.dataObject.isValid()) {
                    this.unWait((byte)1);
                }
            } else if ("modified".equals(evt.getPropertyName()) && !this.dataObject.isModified()) {
                this.unWait((byte)0);
            }
        }

        public void ancestorAdded(AncestorEvent evt) {
        }

        public void ancestorMoved(AncestorEvent evt) {
        }

        public void ancestorRemoved(AncestorEvent evt) {
            JEditorPane[] panes = this.editorCookie.getOpenedPanes();
            if (panes == null || panes.length == 0) {
                this.unWait((byte)0);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

