/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.io.IOException;
import java.io.ObjectInput;
import java.text.MessageFormat;
import org.netbeans.modules.openfile.Server;
import org.netbeans.modules.openfile.SettingsBeanInfo;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;

public class Settings
extends SystemOption {
    private static final long serialVersionUID = 7655861665922160177L;
    private static final String PROP_ACCESS = "access";
    private static final String PROP_ACTUAL_RUNNING = "actualRunning";
    private static final String PROP_ACTUAL_PORT = "actualPort";
    private static boolean running;
    private static boolean actualRunning;
    private static int port;
    private static int actualPort;
    private static boolean inited;
    private static boolean pendingRunning;
    static final int ACCESS_LOCAL = 0;
    static final int ACCESS_ANY = 1;
    private static Settings defaultSettings;
    static /* synthetic */ Class class$org$netbeans$modules$openfile$Settings;

    public static Settings getDefault() {
        if (defaultSettings == null) {
            defaultSettings = (Settings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$openfile$Settings == null ? (class$org$netbeans$modules$openfile$Settings = Settings.class$("org.netbeans.modules.openfile.Settings")) : class$org$netbeans$modules$openfile$Settings), (boolean)true);
        }
        return defaultSettings;
    }

    public String displayName() {
        return SettingsBeanInfo.getString("LBL_openFileSettings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$openfile$Settings == null ? (class$org$netbeans$modules$openfile$Settings = Settings.class$("org.netbeans.modules.openfile.Settings")) : class$org$netbeans$modules$openfile$Settings);
    }

    protected void initialize() {
        super.initialize();
        running = false;
        inited = false;
        port = 7318;
        this.putProperty(PROP_ACCESS, new Integer(0), false);
        actualRunning = false;
        actualPort = 0;
    }

    public boolean isRunning() {
        ErrorManager em = ErrorManager.getDefault().getInstance("org.netbeans.modules.pdf");
        em.log("[pdf] Settings.getDefault(): " + org.netbeans.modules.pdf.Settings.getDefault());
        Settings settings = this;
        synchronized (settings) {
            if (!inited) {
                inited = true;
                this.setRunning(Utilities.isWindows());
            }
            boolean bl = running;
            return bl;
        }
    }

    public void setRunning(boolean run) {
        if (run == running) {
            return;
        }
        Settings settings = this;
        synchronized (settings) {
            if (this.isReadExternal()) {
                pendingRunning = run;
            } else {
                boolean old = running;
                running = run;
                if (old && !run) {
                    Server.shutdown();
                } else if (!old && run) {
                    Server.startup();
                }
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Settings settings = this;
        synchronized (settings) {
            super.readExternal(in);
            inited = true;
            this.setRunning(pendingRunning);
        }
    }

    public int getPort() {
        return port;
    }

    public void setPort(int newPort) {
        if (newPort <= 0 || newPort > 65535) {
            String msg = MessageFormat.format(SettingsBeanInfo.getString("MSG_portOutOfRange"), new Integer(newPort), new Integer(1), new Integer(65535));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            return;
        }
        if (newPort < 1024 && newPort != port && inited && Utilities.isUnix()) {
            String msg = SettingsBeanInfo.getString("MSG_onlyRootOnUnix");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
        }
        Settings settings = this;
        synchronized (settings) {
            boolean restart;
            boolean bl = restart = newPort != port && this.isActualRunning();
            if (restart) {
                Server.shutdown();
            }
            int old = port;
            port = newPort;
            if (restart && running) {
                Server.startup();
            }
        }
    }

    public int getAccess() {
        return (Integer)this.getProperty(PROP_ACCESS);
    }

    public void setAccess(int newAccess) {
        this.putProperty(PROP_ACCESS, new Integer(newAccess), true);
    }

    public boolean isActualRunning() {
        return actualRunning;
    }

    void setActualRunning0(boolean newRun) {
        boolean old;
        Settings settings = this;
        synchronized (settings) {
            old = actualRunning;
            actualRunning = newRun;
        }
        this.firePropertyChange(PROP_ACTUAL_RUNNING, old ? Boolean.TRUE : Boolean.FALSE, newRun ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getActualPort() {
        return actualPort;
    }

    void setActualPort0(int newPort) {
        int old;
        Settings settings = this;
        synchronized (settings) {
            old = actualPort;
            actualPort = newPort;
        }
        this.firePropertyChange(PROP_ACTUAL_PORT, new Integer(old), new Integer(newPort));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

