/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class LocationInfoPanel
extends JPanel {
    private FileSystem fileSystem = null;
    private String path = null;
    private Node selectedNode = null;
    private DataObject selectedDO = null;
    private JTextField fileSystemNameLabel;
    private JLabel fileSystemLabel;
    private JLabel pathLabel;
    private JLabel resultLabel;
    private JTextField packageNameLabel;
    private JButton showButton;
    static /* synthetic */ Class class$org$netbeans$modules$search$LocationInfoPanel;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public LocationInfoPanel() {
        this.initComponents();
        this.initAccessibility();
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$search$LocationInfoPanel == null ? (class$org$netbeans$modules$search$LocationInfoPanel = LocationInfoPanel.class$("org.netbeans.modules.search.LocationInfoPanel")) : class$org$netbeans$modules$search$LocationInfoPanel));
        this.resultLabel.setText(bundle.getString("TEXT_LABEL_LOCATION"));
        this.fileSystemLabel.setText(bundle.getString("TEXT_LABEL_FILESYSTEM"));
        this.pathLabel.setText(bundle.getString("TEXT_LABEL_PATH"));
        this.showButton.setText(bundle.getString("TEXT_BUTTON_SHOW"));
        this.showButton.setMnemonic(bundle.getString("TEXT_BUTTON_SHOW_MNEM").charAt(0));
        this.showButton.setToolTipText(bundle.getString("TEXT_BUTTON_SHOW_TOOLTIP"));
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$search$LocationInfoPanel == null ? (class$org$netbeans$modules$search$LocationInfoPanel = LocationInfoPanel.class$("org.netbeans.modules.search.LocationInfoPanel")) : class$org$netbeans$modules$search$LocationInfoPanel));
        this.fileSystemNameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_FileSystemName"));
        this.packageNameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_PackageName"));
        this.showButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_SHOW"));
    }

    private void initComponents() {
        this.resultLabel = new JLabel();
        this.fileSystemLabel = new JLabel();
        this.pathLabel = new JLabel();
        this.showButton = new JButton();
        this.fileSystemNameLabel = new JTextField();
        this.packageNameLabel = new JTextField();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.resultLabel, gridBagConstraints);
        this.fileSystemLabel.setLabelFor(this.fileSystemNameLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.fileSystemLabel, gridBagConstraints);
        this.pathLabel.setLabelFor(this.packageNameLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.pathLabel, gridBagConstraints);
        this.showButton.setText("jButton1");
        this.showButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocationInfoPanel.this.showButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.showButton, gridBagConstraints);
        this.fileSystemNameLabel.setEditable(false);
        this.fileSystemNameLabel.selectAll();
        this.fileSystemNameLabel.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LocationInfoPanel.this.fileSystemNameLabelFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 0);
        this.add((Component)this.fileSystemNameLabel, gridBagConstraints);
        this.packageNameLabel.setEditable(false);
        this.packageNameLabel.selectAll();
        this.packageNameLabel.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                LocationInfoPanel.this.packageNameLabelFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 0);
        this.add((Component)this.packageNameLabel, gridBagConstraints);
    }

    private void packageNameLabelFocusGained(FocusEvent evt) {
        this.packageNameLabel.selectAll();
    }

    private void fileSystemNameLabelFocusGained(FocusEvent evt) {
        this.fileSystemNameLabel.selectAll();
    }

    private void showButtonActionPerformed(ActionEvent evt) {
        this.showInExplorer();
    }

    public void showInfo(Node node) {
        String fsName = "";
        String pkgName = "";
        if (node != null) {
            this.selectedNode = node;
            this.fileSystem = null;
            this.selectedDO = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = LocationInfoPanel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (this.selectedDO != null) {
                FileObject folder = this.selectedDO.getPrimaryFile().getParent();
                if (folder != null) {
                    try {
                        this.fileSystem = folder.getFileSystem();
                        fsName = this.fileSystem.getDisplayName();
                        this.path = pkgName = folder.getPackageName('/') + "/";
                    }
                    catch (FileStateInvalidException ex) {
                        fsName = NbBundle.getBundle((Class)(class$org$netbeans$modules$search$LocationInfoPanel == null ? (class$org$netbeans$modules$search$LocationInfoPanel = LocationInfoPanel.class$("org.netbeans.modules.search.LocationInfoPanel")) : class$org$netbeans$modules$search$LocationInfoPanel)).getString("TEXT_NO_FILESYSTEM");
                    }
                }
                this.resultLabel.setVisible(true);
                this.fileSystemLabel.setVisible(true);
                this.pathLabel.setVisible(true);
                this.showButton.setVisible(true);
                this.showButton.setEnabled(true);
            }
        } else {
            this.selectedNode = null;
            this.fileSystem = null;
            this.showButton.setEnabled(false);
        }
        this.fileSystemNameLabel.setText(fsName);
        this.packageNameLabel.setText(pkgName);
    }

    private void showInExplorer() {
        if (this.fileSystem == null || this.selectedNode == null || this.selectedDO == null) {
            return;
        }
        Object[] comps = TopComponent.getRegistry().getOpened().toArray();
        boolean foundAndSelected = false;
        Node nodeFilesystems = RepositoryNodeFactory.getDefault().repository(DataFilter.ALL);
        int i = 0;
        while (i < comps.length) {
            Node rootContext;
            ExplorerPanel ep;
            ExplorerManager em;
            if (comps[i] instanceof ExplorerPanel && (em = (ep = (ExplorerPanel)comps[i]).getExplorerManager()) != null && (rootContext = em.getRootContext()) != null && nodeFilesystems.equals(rootContext)) {
                Node node = this.findNodeInRepository();
                if (node == null) break;
                try {
                    em.setSelectedNodes(new Node[]{node});
                    ep.open();
                    ep.requestFocus();
                    foundAndSelected = true;
                }
                catch (PropertyVetoException ex) {}
                break;
            }
            ++i;
        }
        if (!foundAndSelected) {
            this.showButton.setEnabled(false);
        }
    }

    private Node findNodeInRepository() {
        Node rootNode = RepositoryNodeFactory.getDefault().repository(DataFilter.ALL);
        Node node = null;
        Node[] nodes = rootNode.getChildren().getNodes();
        String filesysName = this.fileSystem.getDisplayName();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i].getDisplayName().equals(filesysName)) {
                node = nodes[i];
                break;
            }
            ++i;
        }
        if (this.path != null && !this.path.equals("")) {
            StringTokenizer pathItems = new StringTokenizer(this.path, "/");
            while (node != null && pathItems.hasMoreTokens()) {
                node = node.getChildren().findChild(pathItems.nextToken());
            }
        }
        if (node == null) {
            return null;
        }
        String nodeName = this.selectedNode.getName();
        Children ch = node.getChildren();
        if ((node = ch.findChild(nodeName)) == null) {
            return null;
        }
        Enumeration enumeration = null;
        block2: do {
            DataObject dobj;
            if ((dobj = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? LocationInfoPanel.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) != null && dobj == this.selectedDO) {
                return node;
            }
            node = null;
            if (enumeration == null) {
                enumeration = ch.nodes();
            }
            while (enumeration.hasMoreElements()) {
                Node nod = (Node)enumeration.nextElement();
                if (!nodeName.equals(nod.getName())) continue;
                node = nod;
                continue block2;
            }
        } while (node != null);
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

