/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.SearchDisplayer;
import org.netbeans.modules.search.SearchTask;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class ResultModel
implements TaskListener {
    private static final ErrorManager em = ErrorManager.getDefault().getInstance("org.netbeans.modules.search");
    private final ChangeEvent EVENT;
    public final String PROP_SORTED = "sorted";
    private ResultRootNode root;
    private SearchTask searchTask = null;
    private boolean done = false;
    private HashSet listeners = new HashSet();
    private List searchTypeList;
    private boolean useDisp = false;
    private SearchDisplayer disp = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private SearchGroup searchGroup;
    private PropertyChangeListener propListener;
    static /* synthetic */ Class class$org$netbeans$modules$search$ResultModel;

    public ResultModel(List searchTypeList, SearchGroup searchGroup) {
        this.searchTypeList = searchTypeList;
        this.searchGroup = searchGroup;
        this.EVENT = new ChangeEvent(this);
        this.root = new ResultRootNode();
    }

    public synchronized boolean acceptFoundObjects(Object[] foundObjects) {
        this.root.addFoundObjects(foundObjects);
        if (!this.done) {
            this.root.setDisplayName(MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = ResultModel.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("TXT_RootSearchedNodes"), Integer.toString(this.getFound())));
        }
        return true;
    }

    public SearchGroup getSearchGroup() {
        return this.searchGroup;
    }

    public void fillOutput() {
        if (this.useDisp) {
            this.disp.resetOutput();
        } else {
            this.disp = new SearchDisplayer();
            this.useDisp = true;
        }
        Node[] nodes = this.root.getChildren().getNodes();
        SearchType[] searchTypes = this.searchGroup.getSearchTypes();
        ArrayList<Node> detailNodes = new ArrayList<Node>(nodes.length * searchTypes.length * 3);
        int i = 0;
        while (i < searchTypes.length) {
            int j = 0;
            while (j < nodes.length) {
                Node[] details = searchTypes[i].getDetails(nodes[j]);
                if (details != null) {
                    detailNodes.addAll(Arrays.asList(details));
                }
                ++j;
            }
            ++i;
        }
        this.disp.acceptNodes(detailNodes.toArray(new Node[detailNodes.size()]));
    }

    public boolean isDone() {
        return this.done;
    }

    public void setTask(SearchTask searchTask) {
        this.searchTask = searchTask;
        this.searchTask.addTaskListener(this);
    }

    public Node getRoot() {
        return this.root;
    }

    public List getEnabledSearchTypes() {
        return this.searchTypeList;
    }

    public int getFound() {
        return this.root == null ? 0 : this.root.getNumberOfFoundNodes();
    }

    public boolean isSorted() {
        return this.root == null ? false : this.root.isSorted();
    }

    public Node sortNodes(boolean sort) {
        boolean sorted = this.root.isSorted();
        if (sort == sorted) {
            return this.root;
        }
        this.root.setDisplayName(this.getRootDisplayName());
        this.root.sort(sort);
        return this.root;
    }

    public void taskFinished(Task task) {
        this.done = true;
        this.root.setDisplayName(this.getRootDisplayName());
        this.fireChange();
        this.registerListening();
    }

    private void registerListening() {
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("org.openidex.search.result".equals(evt.getPropertyName())) {
                    if (evt.getNewValue() == null) {
                        ResultModel.this.root.removeFoundObject(evt.getOldValue());
                    } else {
                        ResultModel.this.root.addFoundObjects(new Object[]{evt.getNewValue()});
                    }
                }
            }
        };
        this.searchGroup.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propListener, (Object)this.searchGroup));
    }

    private String getRootDisplayName() {
        if (!this.isDone()) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = ResultModel.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("TEXT_SEARCHING___");
        }
        int found = this.getFound();
        return ResultModel.getRootDisplayNameHelp(found);
    }

    private static String getRootDisplayNameHelp(int found) {
        if (found == 1) {
            return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = ResultModel.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("TEXT_MSG_FOUND_A_NODE"), new Integer(found));
        }
        if (found > 1) {
            return MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = ResultModel.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("TEXT_MSG_FOUND_X_NODES"), new Integer(found));
        }
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = ResultModel.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("TEXT_MSG_NO_NODE_FOUND");
    }

    public void stop() {
        if (this.searchTask != null) {
            this.searchTask.stop();
        }
    }

    public void addChangeListener(ChangeListener lis) {
        this.listeners.add(lis);
    }

    public void removeChangeListener(ChangeListener lis) {
        this.listeners.remove(lis);
    }

    private void fireChange() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ChangeListener next = (ChangeListener)it.next();
            next.stateChanged(this.EVENT);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class FoundNode
    extends FilterNode
    implements PropertyChangeListener {
        private DataObject originalDataObject;
        private Object foundObject;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;
        static /* synthetic */ Class class$org$netbeans$modules$search$ResultModel;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$netbeans$modules$search$RemoveFromSearchAction;

        public FoundNode(Object foundObject) {
            super(ResultModel.this.searchGroup.getNodeForFoundObject(foundObject));
            this.foundObject = foundObject;
            this.originalDataObject = (DataObject)this.getOriginal().getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = FoundNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (this.originalDataObject == null) {
                return;
            }
            this.originalDataObject.addPropertyChangeListener((PropertyChangeListener)this);
            FileObject fileFolder = this.originalDataObject.getPrimaryFile().getParent();
            if (fileFolder != null) {
                String packageName = fileFolder.getPackageName('.');
                String hint = packageName.equals("") ? NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = FoundNode.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("HINT_result_default_package") : MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = FoundNode.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("HINT_result_package"), packageName);
                this.disableDelegation(48);
                this.setShortDescription(hint);
            }
        }

        public SystemAction[] getActions() {
            ArrayList<SystemAction> originalActions = new ArrayList<SystemAction>(Arrays.asList(super.getActions()));
            int deleteIndex = originalActions.indexOf(SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = FoundNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)));
            SystemAction removeFromSearch = SystemAction.get((Class)(class$org$netbeans$modules$search$RemoveFromSearchAction == null ? (class$org$netbeans$modules$search$RemoveFromSearchAction = FoundNode.class$("org.netbeans.modules.search.RemoveFromSearchAction")) : class$org$netbeans$modules$search$RemoveFromSearchAction));
            if (deleteIndex != -1) {
                originalActions.add(deleteIndex, removeFromSearch);
            } else {
                originalActions.add(null);
                originalActions.add(removeFromSearch);
            }
            return originalActions.toArray(new SystemAction[originalActions.size()]);
        }

        public void removeFromSearch() {
            if (this.originalDataObject != null) {
                this.originalDataObject.removePropertyChangeListener((PropertyChangeListener)this);
            }
            ResultModel.this.root.removeFoundObject(this.foundObject);
        }

        public void destroy() throws IOException {
            super.destroy();
            if (this.originalDataObject != null) {
                this.originalDataObject.removePropertyChangeListener((PropertyChangeListener)this);
            }
            ResultModel.this.root.removeFoundObject(this.foundObject);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("valid".equals(evt.getPropertyName()) && !this.originalDataObject.isValid()) {
                if (this.originalDataObject != null) {
                    this.originalDataObject.removePropertyChangeListener((PropertyChangeListener)this);
                }
                ResultModel.this.root.removeFoundObject(this.foundObject);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class ResultRootChildren
    extends Children.Keys {
        private Set keys;
        private final Comparator comparator;
        private boolean sorted = false;

        public ResultRootChildren() {
            this.keys = ResultModel.this.searchGroup.getResultObjects();
            this.comparator = new Comparator(this){
                private final /* synthetic */ ResultRootChildren this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object o1, Object o2) {
                    Node node2;
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    Node node1 = ResultModel.access$200(ResultRootChildren.access$300(this.this$1)).getNodeForFoundObject(o1);
                    if (node1 == (node2 = ResultModel.access$200(ResultRootChildren.access$300(this.this$1)).getNodeForFoundObject(o2))) {
                        return 0;
                    }
                    if (node1 == null) {
                        return 1;
                    }
                    if (node2 == null) {
                        return -1;
                    }
                    int result = node1.getDisplayName().compareTo(node2.getDisplayName());
                    return result == 0 ? -1 : result;
                }
            };
        }

        protected void addNotify() {
            this.setKeys(Collections.EMPTY_SET);
            RequestProcessor.getDefault().post(new Runnable(this){
                private final /* synthetic */ ResultRootChildren this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    ResultRootChildren.access$501(this.this$1, ResultRootChildren.access$400(this.this$1));
                }
            });
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            return new Node[]{new FoundNode(key)};
        }

        public void addFoundObjects(Object[] foundObjects) {
            if (em.isLoggable(1)) {
                em.log("addFoundObjects: " + Arrays.asList(foundObjects));
                em.notify((Throwable)new RuntimeException("++ addFoundObjects"));
            }
            this.keys.addAll(Arrays.asList(foundObjects));
            this.setKeys(this.keys);
        }

        public void removeFoundObject(Object foundObject) {
            if (em.isLoggable(1)) {
                em.log("removeFoundObjects: " + foundObject);
                em.notify((Throwable)new RuntimeException("-- removeFoundObjects"));
            }
            if (this.keys.remove(foundObject)) {
                this.sort(this.sorted);
            }
        }

        public void sort(boolean sort) {
            AbstractSet newKeys = sort ? new TreeSet(this.comparator) : new HashSet();
            newKeys.addAll(this.keys);
            this.setKeys(newKeys);
            this.sorted = sort;
        }

        public boolean isSorted() {
            return this.sorted;
        }

        static /* synthetic */ ResultModel access$300(ResultRootChildren x0) {
            return x0.ResultModel.this;
        }

        static /* synthetic */ Set access$400(ResultRootChildren x0) {
            return x0.keys;
        }

        static /* synthetic */ void access$501(ResultRootChildren x0, Collection x1) {
            super.setKeys(x1);
        }
    }

    private class ResultRootNode
    extends AbstractNode {
        static /* synthetic */ Class class$org$netbeans$modules$search$ResultModel;

        public ResultRootNode() {
            super((Children)new ResultRootChildren());
            this.setDisplayName(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$ResultModel == null ? (class$org$netbeans$modules$search$ResultModel = ResultRootNode.class$("org.netbeans.modules.search.ResultModel")) : class$org$netbeans$modules$search$ResultModel)).getString("TEXT_SEARCHING___"));
        }

        public void addFoundObjects(Object[] foundObjects) {
            ((ResultRootChildren)this.getChildren()).addFoundObjects(foundObjects);
            ResultModel.this.root.setDisplayName(ResultModel.this.getRootDisplayName());
        }

        public void removeFoundObject(Object foundObject) {
            ((ResultRootChildren)this.getChildren()).removeFoundObject(foundObject);
            ResultModel.this.root.setDisplayName(ResultModel.this.getRootDisplayName());
        }

        public void sort(boolean sort) {
            ((ResultRootChildren)this.getChildren()).sort(sort);
        }

        public boolean isSorted() {
            return ((ResultRootChildren)this.getChildren()).isSorted();
        }

        public int getNumberOfFoundNodes() {
            return this.getChildren().getNodes().length;
        }

        public Image getIcon(int type) {
            return Utilities.loadImage((String)"org/netbeans/modules/search/res/find.gif");
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

