/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.SearchProjectSettings;
import org.netbeans.modules.search.SearchTypePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openidex.search.SearchType;

public class SearchPanel
extends JPanel
implements PropertyChangeListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private DialogDescriptor dialogDescriptor;
    private JButton okButton;
    private JButton cancelButton;
    private Dialog dialog;
    private int returnStatus = 0;
    private List orderedSearchTypePanels;
    private boolean customized;
    private JTabbedPane tabbedPane;
    static /* synthetic */ Class class$org$netbeans$modules$search$SearchPanel;

    public SearchPanel(List searchTypeList) {
        this(searchTypeList, false);
    }

    public SearchPanel(List searchTypeList, boolean isCustomized) {
        this.orderedSearchTypePanels = new ArrayList(searchTypeList.size());
        this.customized = isCustomized;
        Map sortedCriteria = SearchProjectSettings.getInstance().sortCriteriaBySearchType();
        ArrayList<String> processedClassNames = new ArrayList<String>();
        Iterator it = searchTypeList.iterator();
        while (it.hasNext()) {
            SearchType searchType = (SearchType)it.next();
            String className = searchType.getClass().getName();
            if (processedClassNames.contains(className)) continue;
            processedClassNames.add(className);
            SearchTypePanel newPanel = new SearchTypePanel(searchType);
            Collection savedCriteria = sortedCriteria == null ? null : (Collection)sortedCriteria.get(className);
            int index = this.orderedSearchTypePanels.indexOf(newPanel);
            if (savedCriteria != null) {
                SearchTypePanel targetPanel = index == -1 ? newPanel : (SearchTypePanel)this.orderedSearchTypePanels.get(index);
                targetPanel.addSavedCriteria(Collections.unmodifiableCollection(savedCriteria));
            }
            if (index != -1) continue;
            this.orderedSearchTypePanels.add(newPanel);
            newPanel.addPropertyChangeListener(this);
        }
        this.initComponents();
        it = this.orderedSearchTypePanels.iterator();
        while (it.hasNext()) {
            this.tabbedPane.add((Component)it.next());
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SearchPanel.this.tabbedPaneStateChanged(evt);
            }
        });
        this.setName(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("TEXT_TITLE_CUSTOMIZE"));
        this.okButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("TEXT_BUTTON_SEARCH"));
        this.okButton.setEnabled(this.isCustomized());
        this.cancelButton = new JButton(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("TEXT_BUTTON_CANCEL"));
        Object[] options = new Object[]{this.okButton, this.cancelButton};
        this.initAccessibility();
        this.dialogDescriptor = new DialogDescriptor((Object)this, this.getName(), true, options, options[0], 0, this.getHelpCtx(), new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == SearchPanel.this.okButton) {
                    SearchPanel.this.doClose(1);
                } else {
                    SearchPanel.this.doClose(0);
                }
            }
        });
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("ACS_SearchPanel"));
        this.tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("ACSN_Tabs"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("ACSD_Tabs"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("ACS_TEXT_BUTTON_SEARCH"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$modules$search$SearchPanel == null ? (class$org$netbeans$modules$search$SearchPanel = SearchPanel.class$("org.netbeans.modules.search.SearchPanel")) : class$org$netbeans$modules$search$SearchPanel)).getString("ACS_TEXT_BUTTON_CANCEL"));
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabbedPane, gridBagConstraints);
    }

    private void tabbedPaneStateChanged(ChangeEvent evt) {
    }

    public boolean isCustomized() {
        return this.customized;
    }

    private List getOrderedSearchTypePanels() {
        return new ArrayList(this.orderedSearchTypePanels);
    }

    private String getTabText(int index) {
        try {
            return ((SearchTypePanel)this.getOrderedSearchTypePanels().get(index)).getName();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    public SearchType[] getCustomizedSearchTypes() {
        ArrayList<SearchType> searchTypeList = new ArrayList<SearchType>(this.orderedSearchTypePanels.size());
        Iterator it = this.orderedSearchTypePanels.iterator();
        while (it.hasNext()) {
            SearchTypePanel searchTypePanel = (SearchTypePanel)it.next();
            if (!searchTypePanel.isCustomized()) continue;
            searchTypeList.add(searchTypePanel.getSearchType());
        }
        return searchTypeList.toArray(new SearchType[searchTypeList.size()]);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void doClose(int returnStatus) {
        this.returnStatus = returnStatus;
        ((Component)this.dialog).setVisible(false);
        this.dialog.dispose();
    }

    public void showDialog() {
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        this.dialog.setModal(true);
        this.dialog.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                Component component;
                int selectedIndex = SearchPanel.this.tabbedPane.getSelectedIndex();
                if (selectedIndex < 0) {
                    selectedIndex = 0;
                }
                if ((component = SearchPanel.this.getTypeCustomizer(selectedIndex)) != null) {
                    component.requestFocus();
                }
                SearchPanel.this.dialog.removeComponentListener(this);
            }
        });
        this.dialog.pack();
        this.dialog.show();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("customized".equals(event.getPropertyName())) {
            this.customized = this.getCustomizedSearchTypes().length != 0;
            this.okButton.setEnabled(this.isCustomized());
        }
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setTitleAt(i, this.getTabText(i));
            this.tabbedPane.setIconAt(i, null);
            ++i;
        }
    }

    private HelpCtx getHelpCtx() {
        int index = this.tabbedPane.getModel().getSelectedIndex();
        SearchTypePanel panel = (SearchTypePanel)this.getOrderedSearchTypePanels().get(index);
        return panel.getHelpCtx();
    }

    private Component getTypeCustomizer(int index) {
        SearchTypePanel searchTypePanel = null;
        Iterator it = this.getOrderedSearchTypePanels().iterator();
        while (index >= 0 && it.hasNext()) {
            searchTypePanel = (SearchTypePanel)it.next();
            --index;
        }
        return searchTypePanel != null ? searchTypePanel.getComponent() : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

